/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class ArrayAccess
implements IArrayAccess {
    private ArrayReference ar;
    private BlockScope scope;
    private SourceContent source;
    private IExpression array;
    private IExpression index;

    public ArrayAccess(ArrayReference ar, BlockScope scope, SourceContent source) {
        this.ar = ar;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 2;
    }

    public int getStartPosition() {
        return this.ar.sourceStart;
    }

    public IExpression getArray() {
        if (this.array == null) {
            this.array = Wrapper.wrapExpression(this.ar.receiver, this.scope, this.source);
        }
        return this.array;
    }

    public IExpression getIndex() {
        if (this.index == null) {
            this.index = Wrapper.wrapExpression(this.ar.position, this.scope, this.source);
        }
        return this.index;
    }

    public ITypeBinding resolveTypeBinding() {
        ITypeBinding tb = this.getArray().resolveTypeBinding();
        if (!(tb instanceof ArrayTypeBinding)) {
            return null;
        }
        if (tb == null) {
            return null;
        }
        return this.getComponentType((ArrayTypeBinding)tb);
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            this.getArray().traverse(visitor);
            this.getIndex().traverse(visitor);
        }
        visitor.endVisit(this);
    }

    private ITypeBinding getComponentType(ArrayTypeBinding at) {
        int dim = at.getDimensions();
        if (dim == 1) {
            return at.getElementType();
        }
        return new ArrayTypeBinding(at.binding, dim - 1);
    }
}

