/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jdt;

import com.sap.tc.jtools.jlint.jdt.ClasspathLocation;
import com.sap.tc.jtools.jlint.jdt.ClasspathMultiDirectory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;

public class NameEnvironment
implements INameEnvironment {
    ClasspathLocation[] classpathLocations;
    String[] initialTypeNames;
    String[] additionalSourceFilenames;
    boolean isIncrementalBuild;
    ClasspathLocation[] binaryLocations;
    ClasspathMultiDirectory[] sourceLocations;

    public NameEnvironment(ClasspathLocation[] classpathLocations) {
        this.classpathLocations = classpathLocations;
        this.isIncrementalBuild = false;
        this.splitLocations();
        this.setNames(new String[0], new String[0]);
    }

    public NameEnvironment(IJavaProject javaProject) {
        try {
            IWorkspaceRoot workspaceRoot = javaProject.getProject().getWorkspace().getRoot();
            IResource outputFolder = workspaceRoot.findMember(javaProject.getOutputLocation());
            String outputFolderLocation = null;
            if (outputFolder != null && outputFolder.exists()) {
                outputFolderLocation = outputFolder.getLocation().toString();
            }
            this.classpathLocations = NameEnvironment.computeLocations(workspaceRoot, javaProject, outputFolderLocation, null, null);
            this.isIncrementalBuild = false;
        }
        catch (JavaModelException e) {
            this.classpathLocations = new ClasspathLocation[0];
        }
        this.splitLocations();
        this.setNames(new String[0], new String[0]);
    }

    /*
     * Unable to fully structure code
     */
    public static ClasspathLocation[] computeLocations(IWorkspaceRoot workspaceRoot, IJavaProject javaProject, String outputFolderLocation, ArrayList sourceFolders, HashMap binaryResources) throws JavaModelException {
        classpathEntries = ((JavaProject)javaProject).getExpandedClasspath(true, true);
        cpCount = 0;
        max = classpathEntries.length;
        classpathLocations = new ClasspathLocation[max];
        firstSourceFolder = true;
        i = 0;
        while (i < max) {
            block22: {
                block23: {
                    entry = classpathEntries[i];
                    path = entry.getPath();
                    target = JavaModel.getTarget((IContainer)workspaceRoot, (IPath)path, (boolean)true);
                    if (target == null) break block22;
                    if (!(target instanceof IResource)) break block23;
                    resource = (IResource)target;
                    switch (entry.getEntryKind()) {
                        case 3: {
                            if (outputFolderLocation != null) {
                                if (resource instanceof IContainer) {
                                    if (sourceFolders != null) {
                                        sourceFolders.add(resource);
                                        classpathLocations[cpCount++] = ClasspathLocation.forSourceFolder(resource.getLocation().toString(), outputFolderLocation);
                                        break;
                                    }
                                    if (firstSourceFolder) {
                                        firstSourceFolder = false;
                                        classpathLocations[cpCount++] = ClasspathLocation.forBinaryFolder(outputFolderLocation);
                                        break;
                                    }
                                }
                            }
                            break block22;
                        }
                        case 2: {
                            if (!(resource instanceof IProject) || !(prereqProject = (IProject)resource).isAccessible()) break block22;
                            outputLocation = JavaCore.create((IProject)prereqProject).getOutputLocation();
                            if (!prereqProject.getFullPath().equals((Object)outputLocation)) ** GOTO lbl35
                            prereqOutputFolder = prereqProject;
                            ** GOTO lbl38
lbl35:
                            // 1 sources

                            prereqOutputFolder = workspaceRoot.findMember(outputLocation);
                            if (prereqOutputFolder == null || !prereqOutputFolder.exists()) break block22;
                            if (!(prereqOutputFolder instanceof IFolder)) break block22;
lbl38:
                            // 2 sources

                            if (prereqOutputFolder.getLocation() != null) {
                                if (binaryResources != null) {
                                    existingResources = (IResource[])binaryResources.get(prereqProject);
                                    if (existingResources == null) {
                                        binaryResources.put(prereqProject, new IResource[]{prereqOutputFolder});
                                    } else {
                                        existingResources[0] = prereqOutputFolder;
                                    }
                                }
                                classpathLocations[cpCount++] = ClasspathLocation.forBinaryFolder(prereqOutputFolder.getLocation().toString());
                                break;
                            }
                            break block22;
                        }
                        case 1: {
                            if (resource.getLocation() == null) break block22;
                            if (!(resource instanceof IFile)) ** GOTO lbl57
                            extension = path.getFileExtension();
                            if (!"jar".equalsIgnoreCase(extension) && !"zip".equalsIgnoreCase(extension)) break block22;
                            classpathLocations[cpCount++] = ClasspathLocation.forLibrary(resource.getLocation().toString());
                            ** GOTO lbl59
lbl57:
                            // 1 sources

                            if (resource instanceof IFolder) {
                                classpathLocations[cpCount++] = ClasspathLocation.forBinaryFolder(resource.getLocation().toString());
                            }
lbl59:
                            // 4 sources

                            if (binaryResources != null) {
                                p = resource.getProject();
                                existingResources = (IResource[])binaryResources.get(p);
                                if (existingResources == null) {
                                    existingResources = new IResource[]{null, resource};
                                } else {
                                    size = existingResources.length;
                                    v0 = existingResources;
                                    existingResources = new IResource[size + 1];
                                    System.arraycopy(v0, 0, existingResources, 0, size);
                                    existingResources[size] = resource;
                                }
                                binaryResources.put(p, existingResources);
                                break;
                            }
                            break block22;
                        }
                    }
                    break block22;
                }
                if (target instanceof File && ("jar".equalsIgnoreCase(extension = path.getFileExtension()) || "zip".equalsIgnoreCase(extension))) {
                    classpathLocations[cpCount++] = ClasspathLocation.forLibrary(path.toString());
                }
            }
            ++i;
        }
        if (cpCount < max) {
            v1 = classpathLocations;
            classpathLocations = new ClasspathLocation[cpCount];
            System.arraycopy(v1, 0, classpathLocations, 0, cpCount);
        }
        return classpathLocations;
    }

    public void cleanup() {
        int i = 0;
        int length = this.classpathLocations.length;
        while (i < length) {
            this.classpathLocations[i].cleanup();
            ++i;
        }
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName) {
        String qBinaryFileName;
        if (this.initialTypeNames != null) {
            int i = 0;
            int length = this.initialTypeNames.length;
            while (i < length) {
                if (qualifiedTypeName.equals(this.initialTypeNames[i])) {
                    if (this.isIncrementalBuild) {
                        throw new AbortCompilation(true, (RuntimeException)new AbortIncrementalBuildException(qualifiedTypeName));
                    }
                    return null;
                }
                ++i;
            }
        }
        String binaryFileName = qBinaryFileName = qualifiedTypeName + ".class";
        String qPackageName = "";
        if (qualifiedTypeName.length() > typeName.length) {
            int typeNameStart = qBinaryFileName.length() - typeName.length - 6;
            qPackageName = qBinaryFileName.substring(0, typeNameStart - 1);
            binaryFileName = qBinaryFileName.substring(typeNameStart);
        }
        if (this.sourceLocations != null && this.sourceLocations[0].isPackage(qPackageName)) {
            NameEnvironmentAnswer answer;
            if (this.additionalSourceFilenames != null) {
                String qSourceFileName = qualifiedTypeName + ".java";
                int i = 0;
                int length = this.sourceLocations.length;
                while (i < length) {
                    NameEnvironmentAnswer answer2 = this.sourceLocations[i].findSourceFile(qSourceFileName, qPackageName, typeName, this.additionalSourceFilenames);
                    if (answer2 != null) {
                        return answer2;
                    }
                    ++i;
                }
            }
            if ((answer = this.sourceLocations[0].findClass(binaryFileName, qPackageName, qBinaryFileName)) != null) {
                return answer;
            }
        }
        int i = 0;
        int length = this.binaryLocations.length;
        while (i < length) {
            NameEnvironmentAnswer answer = this.binaryLocations[i].findClass(binaryFileName, qPackageName, qBinaryFileName);
            if (answer != null) {
                return answer;
            }
            ++i;
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith((char[][])compoundName, (char)'/')), compoundName[compoundName.length - 1]);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith((char[][])packageName, (char[])typeName, (char)'/')), typeName);
        }
        return null;
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        return this.isPackage(new String(CharOperation.concatWith((char[][])compoundName, (char[])packageName, (char)'/')));
    }

    public boolean isPackage(String qualifiedPackageName) {
        if (this.sourceLocations != null && this.sourceLocations[0].isPackage(qualifiedPackageName)) {
            return true;
        }
        int i = 0;
        int length = this.binaryLocations.length;
        while (i < length) {
            if (this.binaryLocations[i].isPackage(qualifiedPackageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setNames(String[] initialTypeNames, String[] additionalSourceFilenames) {
        this.initialTypeNames = initialTypeNames;
        this.additionalSourceFilenames = additionalSourceFilenames;
        int i = 0;
        int length = this.classpathLocations.length;
        while (i < length) {
            this.classpathLocations[i].reset();
            ++i;
        }
    }

    private void splitLocations() {
        int length = this.classpathLocations.length;
        ArrayList<ClasspathLocation> sLocations = new ArrayList<ClasspathLocation>(length);
        ArrayList<ClasspathLocation> bLocations = new ArrayList<ClasspathLocation>(length);
        int i = 0;
        while (i < length) {
            ClasspathLocation classpath = this.classpathLocations[i];
            if (classpath instanceof ClasspathMultiDirectory) {
                sLocations.add(classpath);
            } else {
                bLocations.add(classpath);
            }
            ++i;
        }
        if (sLocations.isEmpty()) {
            this.sourceLocations = null;
        } else {
            this.sourceLocations = new ClasspathMultiDirectory[sLocations.size()];
            sLocations.toArray(this.sourceLocations);
        }
        this.binaryLocations = new ClasspathLocation[bLocations.size()];
        bLocations.toArray(this.binaryLocations);
    }

    void tagAsIncrementalBuild() {
        this.isIncrementalBuild = true;
    }
}

