/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javaelements;

import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.javaelements.Field;
import com.sap.tc.jtools.jlint.javaelements.FieldInterface;
import com.sap.tc.jtools.jlint.javaelements.Method;
import com.sap.tc.jtools.jlint.javaelements.MethodInterface;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

public class Class
implements ClassInterface,
Persistable {
    private String pckName;
    private String className;
    private boolean intf;
    private int modifiers;
    private Method[] methods;
    private Field[] fields;
    private Class[] innerClasses;
    private String superclass;
    private String[] superinterfaces;

    public Class(String pckName, String className, String superclass, String[] superinterfaces, boolean intf, int modifiers, Method[] methods, Field[] fields, Class[] innerClasses) {
        this.pckName = pckName;
        this.className = className;
        this.superclass = superclass;
        this.superinterfaces = superinterfaces;
        this.intf = intf;
        this.modifiers = modifiers;
        this.methods = methods;
        this.fields = fields;
        this.innerClasses = innerClasses;
        int i = 0;
        while (i < methods.length) {
            methods[i].setDefiningClass(this);
            ++i;
        }
        int i2 = 0;
        while (i2 < fields.length) {
            fields[i2].setDefiningClass(this);
            ++i2;
        }
    }

    public Class(StructureTree tree) throws BadTreeException {
        if (tree.getHeader().getTag().equals("CLASS")) {
            this.intf = false;
        } else if (tree.getHeader().getTag().equals("INTERFACE")) {
            this.intf = true;
        } else {
            throw new BadTreeException("wrong tag in class object: " + tree.getHeader().getTag());
        }
        this.pckName = tree.getParameter("PKG");
        this.className = tree.getParameter("NAME");
        this.superclass = tree.getParameter("SUPERCLASS");
        StructureTree[] siTrees = tree.getChildren("SUPERINTERFACE");
        this.superinterfaces = new String[siTrees.length];
        int i = 0;
        while (i < siTrees.length) {
            this.superinterfaces[i] = siTrees[i].getText();
            ++i;
        }
        this.modifiers = Integer.parseInt(tree.getParameter("MODIFIERS"));
        StructureTree[] methodTrees = tree.getChildren("METHOD");
        StructureTree[] constructorTrees = tree.getChildren("CONSTRUCTOR");
        this.methods = new Method[methodTrees.length + constructorTrees.length];
        int i2 = 0;
        while (i2 < methodTrees.length) {
            this.methods[i2] = new Method(methodTrees[i2], this);
            ++i2;
        }
        int i3 = 0;
        while (i3 < constructorTrees.length) {
            this.methods[methodTrees.length + i3] = new Method(constructorTrees[i3], this);
            ++i3;
        }
        StructureTree[] classTrees = tree.getChildren("CLASS");
        StructureTree[] interfaceTrees = tree.getChildren("INTERFACE");
        this.innerClasses = new Class[classTrees.length + interfaceTrees.length];
        int i4 = 0;
        while (i4 < classTrees.length) {
            this.innerClasses[i4] = new Class(classTrees[i4]);
            ++i4;
        }
        int i5 = 0;
        while (i5 < interfaceTrees.length) {
            this.innerClasses[classTrees.length + i5] = new Class(interfaceTrees[i5]);
            ++i5;
        }
        StructureTree[] fieldTrees = tree.getChildren("FIELD");
        this.fields = new Field[fieldTrees.length];
        int i6 = 0;
        while (i6 < fieldTrees.length) {
            this.fields[i6] = new Field(fieldTrees[i6], this);
            ++i6;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public FieldInterface[] getFields() {
        return this.fields;
    }

    public boolean isInterface() {
        return this.intf;
    }

    public MethodInterface[] getMethods() {
        return this.methods;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getPckName() {
        return this.pckName;
    }

    public StructureTree toStructureTree() {
        String classOrInterface = this.intf ? "INTERFACE" : "CLASS";
        Header header = new Header(classOrInterface);
        header.setParameter("PKG", this.pckName);
        header.setParameter("NAME", this.className);
        header.setParameter("MODIFIERS", Integer.toString(this.modifiers));
        if (this.superclass != null) {
            header.setParameter("SUPERCLASS", this.superclass);
        }
        StructureTree tree = new StructureTree(header);
        int i = 0;
        while (i < this.superinterfaces.length) {
            Header siHeader = new Header("SUPERINTERFACE");
            StructureTree siTree = new StructureTree(siHeader);
            siTree.setText(this.superinterfaces[i]);
            tree.addNewChild(siTree);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.fields.length) {
            tree.addNewChild(this.fields[i2].toStructureTree());
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.methods.length) {
            tree.addNewChild(this.methods[i3].toStructureTree());
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.innerClasses.length) {
            tree.addNewChild(this.innerClasses[i4].toStructureTree());
            ++i4;
        }
        return tree;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public String[] getSuperinterfaces() {
        return this.superinterfaces;
    }

    public ClassInterface[] getInnerClasses() {
        return this.innerClasses;
    }
}

