/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff.wrapper;

import com.sap.tc.jtools.jlint.javaelements.Class;
import com.sap.tc.jtools.jlint.javaelements.Field;
import com.sap.tc.jtools.jlint.javaelements.Method;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import java.util.ArrayList;

public class Wrapper {
    public static Class wrap(ITypeDeclaration td) {
        IReferenceTypeBinding tmp = td.resolveBinding();
        Class result = Wrapper.wrap(tmp);
        return result;
    }

    public static Field wrap(IFieldDeclaration declaration) {
        IVariableBinding tmp = declaration.resolveBinding();
        Field result = Wrapper.wrap(tmp);
        return result;
    }

    public static Method wrap(IMethodDeclaration declaration) {
        IMethodBinding tmp = declaration.resolveBinding();
        Method result = Wrapper.wrap(tmp);
        return result;
    }

    public static Class wrap(IReferenceTypeBinding tb) {
        String pckName = tb.getPackage().getName();
        String className = pckName == null ? tb.getName() : tb.getName().substring(pckName.length() + 1);
        boolean intf = tb.isInterface();
        int modifiers = tb.getModifiers() % 2048 & 0xFFFFFFDF;
        IMethodBinding[] methodsToBeWrapped = tb.getDeclaredMethods();
        ArrayList<Method> methodList = new ArrayList<Method>();
        int i = 0;
        while (i < methodsToBeWrapped.length) {
            methodList.add(Wrapper.wrap(methodsToBeWrapped[i]));
            ++i;
        }
        Method[] methods = methodList.toArray(new Method[methodList.size()]);
        IVariableBinding[] fieldsToBeWrapped = tb.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int i2 = 0;
        while (i2 < fieldsToBeWrapped.length) {
            fieldList.add(Wrapper.wrap(fieldsToBeWrapped[i2]));
            ++i2;
        }
        Field[] fields = fieldList.toArray(new Field[fieldList.size()]);
        String superclass = null;
        if (tb.getSuperclass() != null && !tb.getSuperclass().getName().equals("java.lang.Object")) {
            superclass = tb.getSuperclass().getName();
        } else if (!intf) {
            superclass = "java.lang.Object";
        }
        IReferenceTypeBinding[] siBindings = tb.getInterfaces();
        String[] superinterfaces = new String[siBindings.length];
        int i3 = 0;
        while (i3 < superinterfaces.length) {
            superinterfaces[i3] = siBindings[i3].getName();
            ++i3;
        }
        IReferenceTypeBinding[] innerTypeDeclarations = tb.getDeclaredTypes();
        Class[] innerClasses = new Class[innerTypeDeclarations.length];
        int i4 = 0;
        while (i4 < innerTypeDeclarations.length) {
            innerClasses[i4] = Wrapper.wrap(innerTypeDeclarations[i4]);
            ++i4;
        }
        return new Class(pckName, className, superclass, superinterfaces, intf, modifiers, methods, fields, innerClasses);
    }

    public static Field wrap(IVariableBinding field) {
        int modifiers = field.getModifiers() % 2048;
        return new Field(field.getName(), modifiers, field.getType().getName(), null);
    }

    public static Method wrap(IMethodBinding method) {
        String methodName = method.isConstructor() ? null : method.getName();
        boolean isConstructor = method.isConstructor();
        int modifiers = method.getModifiers() % 2048;
        String returnType = isConstructor ? null : method.getReturnType().getName();
        ITypeBinding[] paramBindings = method.getParameterTypes();
        String[] parameterTypes = new String[paramBindings.length];
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = paramBindings[i].getName();
            ++i;
        }
        IReferenceTypeBinding[] excepBindings = method.getExceptionTypes();
        String[] excepTypes = new String[excepBindings.length];
        int i2 = 0;
        while (i2 < excepTypes.length) {
            excepTypes[i2] = excepBindings[i2].getName();
            ++i2;
        }
        return new Method(methodName, isConstructor, modifiers, returnType, parameterTypes, excepTypes);
    }
}

