/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff.comparator;

import com.sap.tc.jtools.jlint.javadiff.comparator.FilterInterface;
import com.sap.tc.jtools.jlint.javadiff.comparator.ListenerInterface;
import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.javaelements.FieldInterface;
import com.sap.tc.jtools.jlint.javaelements.MethodInterface;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Comparator {
    private ListenerInterface listener;
    private FilterInterface filter = new FilterInterface(){

        public boolean ignore(ClassInterface cls) {
            return false;
        }

        public boolean ignore(FieldInterface field) {
            return false;
        }

        public boolean ignore(MethodInterface method) {
            return false;
        }
    };

    public void compareClasses(ClassInterface c1, ClassInterface c2) {
        ClassInterface class2;
        FieldInterface field2;
        if (c1.getModifiers() != c2.getModifiers()) {
            this.listener.differentClassModifiers(c1, c2);
        }
        String sc1 = c1.getSuperclass();
        String sc2 = c2.getSuperclass();
        if (sc1 == null && sc2 != null || sc1 != null && sc2 == null || sc1 != null && sc2 != null && !sc1.equals(sc2)) {
            this.listener.differentSuperclass(c1, c2);
        }
        HashSet<String> si1 = new HashSet<String>();
        HashSet<String> si2 = new HashSet<String>();
        si1.addAll(Arrays.asList(c1.getSuperinterfaces()));
        si2.addAll(Arrays.asList(c2.getSuperinterfaces()));
        Iterator iter = si1.iterator();
        while (iter.hasNext()) {
            String si = (String)iter.next();
            if (!si2.contains(si)) {
                this.listener.extraSuperInterfaceIn1(c1, si);
                continue;
            }
            si2.remove(si);
        }
        Iterator iter2 = si2.iterator();
        while (iter2.hasNext()) {
            String si = (String)iter2.next();
            this.listener.extraSuperInterfaceIn2(c2, si);
        }
        FieldInterface[] fields1 = c1.getFields();
        HashMap<String, FieldInterface> fieldMap1 = new HashMap<String, FieldInterface>();
        int i = 0;
        while (i < fields1.length) {
            if (!this.filter.ignore(fields1[i])) {
                fieldMap1.put(fields1[i].getName(), fields1[i]);
            }
            ++i;
        }
        FieldInterface[] fields2 = c2.getFields();
        HashMap<String, FieldInterface> fieldMap2 = new HashMap<String, FieldInterface>();
        int i2 = 0;
        while (i2 < fields2.length) {
            if (!this.filter.ignore(fields2[i2])) {
                fieldMap2.put(fields2[i2].getName(), fields2[i2]);
            }
            ++i2;
        }
        Iterator iter3 = fieldMap1.keySet().iterator();
        while (iter3.hasNext()) {
            String fieldName = (String)iter3.next();
            FieldInterface field1 = (FieldInterface)fieldMap1.get(fieldName);
            field2 = (FieldInterface)fieldMap2.get(fieldName);
            if (field2 == null) {
                this.listener.extraFieldIn1(field1);
                continue;
            }
            this.compareFields(field1, field2);
            fieldMap2.remove(fieldName);
        }
        Iterator iter4 = fieldMap2.keySet().iterator();
        while (iter4.hasNext()) {
            String fieldName = (String)iter4.next();
            field2 = (FieldInterface)fieldMap2.get(fieldName);
            this.listener.extraFieldIn2(field2);
        }
        ClassInterface[] classes1 = c1.getInnerClasses();
        HashMap<String, ClassInterface> classMap1 = new HashMap<String, ClassInterface>();
        int i3 = 0;
        while (i3 < classes1.length) {
            if (!this.filter.ignore(classes1[i3])) {
                classMap1.put(classes1[i3].getClassName(), classes1[i3]);
            }
            ++i3;
        }
        ClassInterface[] classes2 = c2.getInnerClasses();
        HashMap<String, ClassInterface> classMap2 = new HashMap<String, ClassInterface>();
        int i4 = 0;
        while (i4 < classes2.length) {
            if (!this.filter.ignore(classes2[i4])) {
                classMap2.put(classes2[i4].getClassName(), classes2[i4]);
            }
            ++i4;
        }
        Iterator iter5 = classMap1.keySet().iterator();
        while (iter5.hasNext()) {
            String className = (String)iter5.next();
            ClassInterface class1 = (ClassInterface)classMap1.get(className);
            class2 = (ClassInterface)classMap2.get(className);
            if (class2 == null) {
                this.listener.extraClassIn1(c1, class1);
                continue;
            }
            this.compareClasses(class1, class2);
            classMap2.remove(className);
        }
        Iterator iter6 = classMap2.keySet().iterator();
        while (iter6.hasNext()) {
            String className = (String)iter6.next();
            class2 = (ClassInterface)classMap2.get(className);
            this.listener.extraClassIn2(c1, class2);
        }
        MethodInterface[] methods1 = c1.getMethods();
        HashMap<String, MethodInterface> methodMap1 = new HashMap<String, MethodInterface>();
        int i5 = 0;
        while (i5 < methods1.length) {
            if (!this.filter.ignore(methods1[i5])) {
                String methodNameAndSignature = methods1[i5].getMethodName() + "@";
                String[] params = methods1[i5].getParameterTypes();
                int j = 0;
                while (j < params.length) {
                    methodNameAndSignature = methodNameAndSignature + params[j] + ";";
                    ++j;
                }
                methodMap1.put(methodNameAndSignature, methods1[i5]);
            }
            ++i5;
        }
        MethodInterface[] methods2 = c2.getMethods();
        HashMap<String, MethodInterface> methodMap2 = new HashMap<String, MethodInterface>();
        int i6 = 0;
        while (i6 < methods2.length) {
            if (!this.filter.ignore(methods2[i6])) {
                String methodNameAndSignature = methods2[i6].getMethodName() + "@";
                String[] params = methods2[i6].getParameterTypes();
                int j = 0;
                while (j < params.length) {
                    methodNameAndSignature = methodNameAndSignature + params[j] + ";";
                    ++j;
                }
                methodMap2.put(methodNameAndSignature, methods2[i6]);
            }
            ++i6;
        }
        HashMap<String, MethodInterface> spareMethods1 = new HashMap<String, MethodInterface>();
        Iterator iter7 = methodMap1.keySet().iterator();
        while (iter7.hasNext()) {
            String methodName = (String)iter7.next();
            MethodInterface method1 = (MethodInterface)methodMap1.get(methodName);
            MethodInterface method2 = (MethodInterface)methodMap2.get(methodName);
            if (method2 == null) {
                spareMethods1.put(methodName, method1);
                continue;
            }
            this.compareMethods(method1, method2);
            methodMap2.remove(methodName);
        }
        Iterator iter8 = spareMethods1.keySet().iterator();
        while (iter8.hasNext()) {
            String methodName = (String)iter8.next();
            MethodInterface method1 = (MethodInterface)methodMap1.get(methodName);
            String method1NameOnly = method1.getMethodName();
            boolean found = false;
            Iterator iterator = methodMap2.keySet().iterator();
            while (iterator.hasNext()) {
                String method2Name = (String)iterator.next();
                if (!method2Name.startsWith(method1NameOnly + "@")) continue;
                MethodInterface method2 = (MethodInterface)methodMap2.get(method2Name);
                this.listener.differentMethodSignatures(method1, method2);
                this.compareMethods(method1, method2);
                methodMap2.remove(method2Name);
                found = true;
                break;
            }
            if (found) continue;
            this.listener.extraMethodIn1(method1);
        }
        Iterator iter9 = methodMap2.keySet().iterator();
        while (iter9.hasNext()) {
            String methodName = (String)iter9.next();
            MethodInterface method2 = (MethodInterface)methodMap2.get(methodName);
            this.listener.extraMethodIn2(method2);
        }
    }

    public void compareMethods(MethodInterface m1, MethodInterface m2) {
        String[] exc2;
        String[] exc1;
        if (m1.getModifiers() != m2.getModifiers()) {
            this.listener.differentMethodModifiers(m1, m2);
        }
        if (!m1.isConstructor() && !m1.getReturnType().equals(m2.getReturnType())) {
            this.listener.differentReturnTypes(m1, m2);
        }
        if ((exc1 = m1.getExceptionTypes()).length != (exc2 = m2.getExceptionTypes()).length) {
            this.listener.differentExceptions(m1, m2);
        } else {
            int i = 0;
            while (i < exc1.length) {
                if (!exc1[i].equals(exc2[i])) {
                    this.listener.differentExceptions(m1, m2);
                    break;
                }
                ++i;
            }
        }
    }

    public void compareFields(FieldInterface f1, FieldInterface f2) {
        if (f1.getModifiers() != f2.getModifiers()) {
            this.listener.differentFieldModifiers(f1, f2);
        }
        if (!f1.getType().equals(f2.getType())) {
            this.listener.differentFieldTypes(f1, f2);
        }
        if (f1.getValue() != null && !f1.getValue().equals(f2.getValue()) || f1.getValue() == null && f2.getValue() != null) {
            this.listener.differentFieldValues(f1, f2);
        }
    }

    public void attachListener(ListenerInterface l) {
        this.listener = l;
    }

    public void attachFilter(FilterInterface f) {
        this.filter = f;
    }
}

