/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff;

import com.sap.tc.jtools.jlint.javadiff.comparator.Comparator;
import com.sap.tc.jtools.jlint.javadiff.comparator.ListenerInterface;
import com.sap.tc.jtools.jlint.javadiff.util.APIFilter;
import com.sap.tc.jtools.jlint.javaelements.Class;
import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.javaelements.FieldInterface;
import com.sap.tc.jtools.jlint.javaelements.MethodInterface;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;

public class Main {
    public static final String API_SUFFIX = "_api.xml";
    private static String root1;
    private static String root2;
    private static Comparator comparator;

    public static void main(String[] args) {
        root1 = args[0];
        if (root1.endsWith("\\") || root1.endsWith("/")) {
            root1 = root1.substring(0, root1.length() - 1);
        }
        if ((root2 = args[1]).endsWith("\\") || root2.endsWith("/")) {
            root2 = root2.substring(0, root2.length() - 1);
        }
        File dir1 = new File(args[0]);
        File dir2 = new File(args[1]);
        comparator = new Comparator();
        comparator.attachFilter(new APIFilter());
        comparator.attachListener(new Listener());
        Main.checkDirectories(dir1, dir2);
    }

    private static void checkDirectories(File dir1, File dir2) {
        File currentFile2;
        HashMap<String, File> children1Map = new HashMap<String, File>();
        File[] children1 = dir1.listFiles();
        int i = 0;
        while (i < children1.length) {
            children1Map.put(children1[i].getName(), children1[i]);
            ++i;
        }
        HashMap<String, File> children2Map = new HashMap<String, File>();
        File[] children2 = dir2.listFiles();
        int i2 = 0;
        while (i2 < children2.length) {
            children2Map.put(children2[i2].getName(), children2[i2]);
            ++i2;
        }
        Iterator iter = children1Map.keySet().iterator();
        while (iter.hasNext()) {
            String currentFileName = (String)iter.next();
            File currentFile1 = (File)children1Map.get(currentFileName);
            currentFile2 = (File)children2Map.get(currentFileName);
            if (currentFile1.isDirectory()) {
                if (currentFile2 == null || !currentFile2.isDirectory()) {
                    System.out.println("missing package in 2: " + dir2.getAbsolutePath().substring(root2.length() + 1) + File.separator + currentFileName);
                    continue;
                }
                Main.checkDirectories(currentFile1, currentFile2);
            } else {
                if (currentFile2 == null || !currentFile2.isFile()) {
                    System.out.println("missing class in 2: " + dir2.getAbsolutePath().substring(root2.length() + 1) + File.separator + currentFileName.substring(0, currentFileName.length() - API_SUFFIX.length()));
                    continue;
                }
                Main.checkFiles(currentFile1, currentFile2);
            }
            children2Map.remove(currentFileName);
        }
        Iterator iter2 = children2Map.keySet().iterator();
        while (iter2.hasNext()) {
            String currentFileName = (String)iter2.next();
            currentFile2 = (File)children2Map.get(currentFileName);
            if (currentFile2.isDirectory()) {
                System.out.println("missing package in 1: " + dir1.getAbsolutePath().substring(root1.length() + 1) + File.separator + currentFileName + "\n");
                continue;
            }
            System.out.println("missing class in 1: " + dir2.getAbsolutePath().substring(root2.length() + 1) + File.separator + currentFileName.substring(0, currentFileName.length() - API_SUFFIX.length()) + "\n");
        }
    }

    private static void checkFiles(File file1, File file2) {
        try {
            Class c1 = new Class(XMLTool.parseReader((Reader)new FileReader(file1)));
            Class c2 = new Class(XMLTool.parseReader((Reader)new FileReader(file2)));
            comparator.compareClasses(c1, c2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Listener
    implements ListenerInterface {
        private Listener() {
        }

        public void extraFieldIn1(FieldInterface field1) {
            System.out.println(this.getPrefix(field1) + ": extra field in 1\n");
        }

        public void extraFieldIn2(FieldInterface field2) {
            System.out.println(this.getPrefix(field2) + ": extra field in 2\n");
        }

        public void extraMethodIn1(MethodInterface method1) {
            System.out.println(this.getPrefix(method1) + ": extra method in 1\n");
        }

        public void extraMethodIn2(MethodInterface method2) {
            System.out.println(this.getPrefix(method2) + ": extra method in 2\n");
        }

        public void differentMethodSignatures(MethodInterface method1, MethodInterface method2) {
            System.out.println("different method signatures:\n   1:" + this.getPrefix(method1) + "\n   2:" + this.getPrefix(method2) + "\n");
        }

        public void differentClassModifiers(ClassInterface c1, ClassInterface c2) {
            System.out.println("different class modifiers:\n   1:" + this.getPrefix(c1) + " --> " + c1.getModifiers() + "\n" + "   2:" + this.getPrefix(c2) + " --> " + c2.getModifiers() + "\n");
        }

        public void differentSuperclass(ClassInterface c1, ClassInterface c2) {
            System.out.println("different superclass:\n   1:" + this.getPrefix(c1) + " --> " + c1.getSuperclass() + "\n" + "   2:" + this.getPrefix(c2) + " --> " + c2.getSuperclass() + "\n");
        }

        public void extraSuperInterfaceIn1(ClassInterface c1, String si) {
            System.out.println("extra super interface in 1: " + si + "\n" + "   " + this.getPrefix(c1) + "\n");
        }

        public void extraSuperInterfaceIn2(ClassInterface c2, String si) {
            System.out.println("extra super interface in 2: " + si + "\n" + "   " + this.getPrefix(c2) + "\n");
        }

        public void extraClassIn1(ClassInterface c1, ClassInterface cls) {
            System.out.println("extra class in 1:\n   " + this.getPrefix(c1) + "\n" + "     :" + this.getPrefix(cls) + "\n");
        }

        public void extraClassIn2(ClassInterface c2, ClassInterface cls) {
            System.out.println("extra class in 2:\n   " + this.getPrefix(c2) + "\n" + "     :" + this.getPrefix(cls) + "\n");
        }

        public void differentMethodModifiers(MethodInterface m1, MethodInterface m2) {
            System.out.println("different method modifiers:\n   1:" + this.getPrefix(m1) + " --> " + m1.getModifiers() + "\n" + "   2:" + this.getPrefix(m2) + " --> " + m2.getModifiers() + "\n");
        }

        public void differentReturnTypes(MethodInterface m1, MethodInterface m2) {
            System.out.println("different return types:\n   1:" + this.getPrefix(m1) + " --> " + m1.getReturnType() + "\n" + "   2:" + this.getPrefix(m2) + " --> " + m2.getReturnType() + "\n");
        }

        public void differentExceptions(MethodInterface m1, MethodInterface m2) {
            System.out.println("different exceptions:\n   1:" + this.getPrefix(m1) + "\n" + "   2:" + this.getPrefix(m2) + "\n");
        }

        public void differentFieldModifiers(FieldInterface f1, FieldInterface f2) {
            System.out.println("different field modifiers:\n   1:" + this.getPrefix(f1) + " --> " + f1.getModifiers() + "\n" + "   2:" + this.getPrefix(f2) + " --> " + f2.getModifiers() + "\n");
        }

        public void differentFieldTypes(FieldInterface f1, FieldInterface f2) {
            System.out.println("different field types:\n   1:" + this.getPrefix(f1) + " --> " + f1.getType() + "\n" + "   2:" + this.getPrefix(f2) + " --> " + f2.getType() + "\n");
        }

        public void differentFieldValues(FieldInterface f1, FieldInterface f2) {
            System.out.println("different field values:\n   1:" + this.getPrefix(f1) + " --> " + f1.getValue() + "\n" + "   2:" + this.getPrefix(f2) + " --> " + f2.getValue() + "\n");
        }

        private String getPrefix(ClassInterface c) {
            String out = "";
            out = out + "class: " + c.getPckName() + "." + c.getClassName() + "  ";
            return out;
        }

        private String getPrefix(FieldInterface f) {
            ClassInterface c = f.getDefiningClass();
            String out = this.getPrefix(c);
            out = out + "field: " + f.getName() + "  ";
            return out;
        }

        private String getPrefix(MethodInterface m) {
            ClassInterface c = m.getDefiningClass();
            String sig = "@";
            String[] sigComponents = m.getParameterTypes();
            int i = 0;
            while (i < sigComponents.length) {
                sig = sig + sigComponents[i] + ";";
                ++i;
            }
            String out = this.getPrefix(c);
            String methodName = m.getMethodName();
            if (methodName == null) {
                methodName = "<constructor>";
            }
            out = out + "method: " + methodName + sig + "  ";
            return out;
        }
    }
}

