/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.services;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.services.MetamodelSelectionContentProvider;
import com.sap.ide.metamodel.core.services.MetamodelSelectionLabelProvider;
import com.sap.ide.metamodel.core.services.TextPool;
import com.sap.ide.metamodel.core.services.WDErrorDialog;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class ServicesUI {
    private static boolean mShowAgain = true;
    public static TracerI mTracer = TracingManager.getTracer((Class)(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI));
    private static final TextPool mTextPool = new TextPool();
    private static final String PLUGIN_ID_TEXT = mTextPool.getText(201);
    private static final String PLUGIN_NAME = mTextPool.getText(200);
    private static final String CLASS = mTextPool.getText(202);
    private static final String METHOD = mTextPool.getText(203);
    private static final String EXCEPTION = mTextPool.getText(204);
    private static final String MESSAGE = mTextPool.getText(205);
    private static final String INTERNAL_ERROR = mTextPool.getText(9);
    private static final String INTERNAL_WARNING = mTextPool.getText(11);
    private static final String NONE = mTextPool.getText(300);
    private static final String PACKAGE_SELECTION = mTextPool.getText(207);
    private static final String CHOOSE = mTextPool.getText(208);
    private static final String NO_PACKAGES = mTextPool.getText(209);
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$services$ServicesUI;

    public static void internalErrorDialog(Class theClass, String methodName, String message, Throwable throwable, Plugin plugin) {
        Throwable throwableToLog = throwable != null ? throwable : new Throwable("Call Stack of internalError call");
        if (mShowAgain && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            WDErrorDialog dialog = new WDErrorDialog(plugin, theClass, methodName, message, throwableToLog);
            dialog.open();
            dialog.close();
        }
    }

    public static void internalError(Class theClass, String methodName, String message, Throwable throwable, Plugin plugin, boolean logOnly) {
        String pluginId = plugin == null ? "" : plugin.getDescriptor().getUniqueIdentifier();
        String msg = ServicesUI.composeStringFrom(theClass, methodName, message, throwable, plugin);
        Throwable throwableToLog = throwable != null ? throwable : new Throwable("Call Stack of internalError call");
        mTracer.error(msg, throwableToLog);
        if (mShowAgain && !logOnly && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            WDErrorDialog dialog = new WDErrorDialog(plugin, theClass, methodName, message, throwableToLog);
            dialog.open();
            dialog.close();
        }
    }

    protected static void setShowAgain(boolean showAgain) {
        mShowAgain = showAgain;
    }

    public static void internalWarning(Class theClass, String methodName, String message, Throwable throwable, Plugin plugin) {
        String msg = ServicesUI.composeStringFrom(theClass, methodName, message, throwable, plugin);
        mTracer.warning(msg, throwable);
    }

    public static void logMessage(Class theClass, String methodName, String message, Plugin plugin) {
        String msg = ServicesUI.composeStringFrom(theClass, methodName, message, null, plugin);
        String pluginId = plugin == null ? "" : plugin.getDescriptor().getUniqueIdentifier();
        Status status = new Status(1, pluginId, 1, msg, null);
        plugin.getLog().log((IStatus)status);
    }

    public static String composeStringFrom(Class theClass, String methodName, String message, Throwable throwable, Plugin plugin) {
        String pluginName = plugin == null ? "" : plugin.getDescriptor().getLabel();
        String pluginId = plugin == null ? "" : plugin.getDescriptor().getUniqueIdentifier();
        String className = theClass == null ? "" : theClass.getName();
        String method = methodName == null ? "" : methodName;
        String messageText = message == null ? "" : message;
        String exceptionText = throwable == null ? "" : throwable.getClass().getName() + ": " + throwable.getMessage();
        String msg = new String();
        String sep = System.getProperty("line.separator");
        msg = INTERNAL_ERROR;
        msg = msg + sep + "   " + PLUGIN_NAME + ": " + pluginName;
        msg = msg + sep + "   " + PLUGIN_ID_TEXT + "  : " + pluginId;
        msg = msg + sep + "   " + CLASS + "      : " + className;
        msg = msg + sep + "   " + METHOD + "     : " + method;
        msg = msg + sep + "   " + MESSAGE + "    : " + messageText;
        msg = msg + sep + "   " + EXCEPTION + "  : " + exceptionText;
        msg = msg + sep;
        return msg;
    }

    public static void logMessage(String message, Plugin plugin) {
        String pluginId = plugin == null ? "" : plugin.getDescriptor().getUniqueIdentifier();
        Status status = new Status(1, pluginId, 1, message, null);
        plugin.getLog().log((IStatus)status);
    }

    public static IPackageFragment browsePackages(IPackageFragmentRoot sourceRoot, Shell shell) {
        return ServicesUI.browsePackages(sourceRoot, null, shell);
    }

    public static IPackageFragment browsePackages(IPackageFragmentRoot sourceRoot, IPackageFragment preselectedPackage, Shell shell) {
        if (sourceRoot == null) {
            ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", "Invalid method call: some of the parameters are null.", null, MetamodelCoreEclipsePlugin.getDefault(), false);
            return null;
        }
        String str = sourceRoot.getPath().makeRelative().toString();
        IResource resource = null;
        try {
            resource = sourceRoot.getCorrespondingResource();
        }
        catch (JavaModelException e) {
            ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", "Could not find corresponding resource.", e, MetamodelCoreEclipsePlugin.getDefault(), false);
        }
        if (resource != null) {
            int resourceType = resource.getType();
            if (resourceType == 4 || resourceType == 2) {
                IProject project = resource.getProject();
                if (!project.isOpen()) {
                    ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", "Project is closed" + project.getFullPath().toString(), null, MetamodelCoreEclipsePlugin.getDefault(), false);
                }
                if (resource.exists()) {
                    try {
                        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                            if (resourceType == 4) {
                                ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", "Container " + str + " is not a Java Project.", null, MetamodelCoreEclipsePlugin.getDefault(), false);
                            } else {
                                ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", "Container " + str + " is not in a Java Project.", null, MetamodelCoreEclipsePlugin.getDefault(), false);
                            }
                        }
                    }
                    catch (CoreException e) {
                        ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", "Container " + str + " is not a Java Project.", e, MetamodelCoreEclipsePlugin.getDefault(), false);
                    }
                    IJavaProject jProject = sourceRoot.getJavaProject();
                    if (!jProject.isOnClasspath((IJavaElement)sourceRoot)) {
                        ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", "Container " + str + " is not on classpath.", null, MetamodelCoreEclipsePlugin.getDefault(), false);
                    }
                    if (sourceRoot.isArchive()) {
                        ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", "Container " + str + " is binary.", null, MetamodelCoreEclipsePlugin.getDefault(), false);
                    }
                } else {
                    ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", str + " is not a folder.", null, MetamodelCoreEclipsePlugin.getDefault(), false);
                }
            } else {
                ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", "Container " + str + " does not exist.", null, MetamodelCoreEclipsePlugin.getDefault(), false);
            }
        }
        Vector<IJavaElement> elementVector = new Vector<IJavaElement>();
        Object[] packages = null;
        try {
            if (sourceRoot != null) {
                packages = sourceRoot.getChildren();
            }
        }
        catch (JavaModelException e) {
            ServicesUI.internalError(class$com$sap$ide$metamodel$core$services$ServicesUI == null ? (class$com$sap$ide$metamodel$core$services$ServicesUI = ServicesUI.class$("com.sap.ide.metamodel.core.services.ServicesUI")) : class$com$sap$ide$metamodel$core$services$ServicesUI, "browsePackages()", "Could not get packages.", e, MetamodelCoreEclipsePlugin.getDefault(), false);
        }
        if (packages != null) {
            int i = 1;
            while (i < packages.length) {
                elementVector.add(packages[i]);
                ++i;
            }
            packages = elementVector.toArray(new IJavaElement[0]);
        } else {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(PACKAGE_SELECTION);
        dialog.setMessage(CHOOSE);
        dialog.setEmptyListMessage(NO_PACKAGES);
        dialog.setElements(packages);
        if (preselectedPackage != null) {
            dialog.setInitialSelections(new Object[]{preselectedPackage});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    public static IProject[] selectMetamodel(IWorkspaceRoot workspaceRoot) {
        MetamodelSelectionContentProvider contentProvider = new MetamodelSelectionContentProvider();
        MetamodelSelectionLabelProvider labelProvider = new MetamodelSelectionLabelProvider();
        ListSelectionDialog dialog = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)workspaceRoot, (IStructuredContentProvider)contentProvider, (ILabelProvider)labelProvider, mTextPool.getText(211));
        if (dialog.open() == 0) {
            dialog.close();
            Object[] objects = dialog.getResult();
            IProject[] selectedProjects = new IProject[objects.length];
            int i = 0;
            while (i < objects.length) {
                selectedProjects[i] = (IProject)objects[i];
                ++i;
            }
            return selectedProjects;
        }
        return null;
    }

    public static Metamodel[] showSelectMetamodelDialog(Metamodel[] allMetamodels) {
        return ServicesUI.showSelectMetamodelDialog(allMetamodels, mTextPool.getText(210), mTextPool.getText(211));
    }

    public static Metamodel[] showSelectMetamodelDialog(Metamodel[] allMetamodels, String dialogTitle, String dialogMessage) {
        MetamodelSelectionContentProvider contentProvider = new MetamodelSelectionContentProvider();
        MetamodelSelectionLabelProvider labelProvider = new MetamodelSelectionLabelProvider();
        ListSelectionDialog dialog = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)allMetamodels, (IStructuredContentProvider)contentProvider, (ILabelProvider)labelProvider, dialogMessage);
        dialog.setTitle(dialogTitle);
        if (dialog.open() == 0) {
            dialog.close();
            Object[] objects = dialog.getResult();
            Metamodel[] selectedMetamodels = new Metamodel[objects.length];
            int i = 0;
            while (i < objects.length) {
                selectedMetamodels[i] = (Metamodel)objects[i];
                ++i;
            }
            return selectedMetamodels;
        }
        return null;
    }

    public static boolean askUserToLogonToDtr() {
        String[] buttons = new String[]{mTextPool.getText(411), IDialogConstants.CANCEL_LABEL};
        MessageDialog dialog = ServicesUI.createMessageDialog(mTextPool.getText(412), mTextPool.getText(413), buttons, 2, null, 0);
        return dialog.open() == 0;
    }

    public static boolean askUserToConfirm(String title, String message) {
        return ServicesUI.askUserToConfirm(title, message, 0);
    }

    public static boolean askUserToConfirm(String title, String message, int defaultButtonIndex) {
        String[] buttons = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        MessageDialog dialog = ServicesUI.createMessageDialog(title, message, buttons, 3, null, defaultButtonIndex);
        return dialog.open() == 0;
    }

    public static boolean askUserToDecide(String title, String message) {
        return ServicesUI.askUserToDecide(title, message, 0);
    }

    public static boolean askUserToDecide(String title, String message, int defaultButtonIndex) {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        MessageDialog dialog = ServicesUI.createMessageDialog(title, message, buttons, 3, null, defaultButtonIndex);
        return dialog.open() == 0;
    }

    public static MessageDialog createMessageDialog(String dialogTitle, String dialogMessage, String[] buttons, int dialogImageType, Image titleImage, int defaultButtonIndex) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return new MessageDialog(shell, dialogTitle, titleImage, dialogMessage, dialogImageType, buttons, defaultButtonIndex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

