/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.services;

import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.services.TextPool;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MMCCheckServices {
    public static IStatus isValidMDONameLength(String name) {
        if (name.length() > 30) {
            return new Status(2, MetamodelCoreEclipsePlugin.getDefault().getDescriptor().getUniqueIdentifier(), 2, TextPool.getInstance().getText(445), null);
        }
        return new Status(0, MetamodelCoreEclipsePlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "", null);
    }

    public static CheckResult isValidMDOName(String name) {
        return MMCCheckServices.isValidFileName(name);
    }

    public static CheckResult isValidFileName(String name) {
        CheckResult checkResult = MMCCheckServices.isValidIdentifier(name);
        if (!checkResult.isOk()) {
            return checkResult;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (status.getSeverity() == 0) {
            return new CheckResult(true, null);
        }
        return new CheckResult(false, status.getMessage());
    }

    public static CheckResult isValidIdentifier(String s) {
        if (s != null && s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '_') {
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c))) {
                    return MMCCheckServices.getFailedResult(s);
                }
                ++i;
            }
            return new CheckResult(true, null);
        }
        return MMCCheckServices.getFailedResult(s);
    }

    private static CheckResult getFailedResult(String identifier) {
        String message = TextPool.getInstance().getText(444, identifier);
        return new CheckResult(false, message);
    }

    public static class CheckResult {
        boolean mOk;
        String mMessage;

        CheckResult(boolean ok, String message) {
            this.mOk = ok;
            this.mMessage = message;
        }

        public String getMessage() {
            return this.mMessage;
        }

        public boolean isOk() {
            return this.mOk;
        }

        public void setMessage(String message) {
            this.mMessage = message;
        }

        public void setOk(boolean ok) {
            this.mOk = ok;
        }
    }
}

