/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.selectionconverter;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ProjectSelectionConverter
implements ISelectionProvider,
ISelectionChangedListener {
    private HashSet myListeners = new HashSet();
    private TreeViewer mTreeViewer;

    public ProjectSelectionConverter(TreeViewer viewer) {
        this.mTreeViewer = viewer;
        this.mTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.myListeners.add(listener);
    }

    public ISelection getSelection() {
        ISelection sel = this.mTreeViewer.getSelection();
        if (sel instanceof StructuredSelection) {
            StructuredSelection ssel = (StructuredSelection)sel;
            Object[] obj = ssel.toArray();
            int i = 0;
            while (i < obj.length) {
                if (obj[i] instanceof Entity) {
                    String projectName;
                    Entity entity = (Entity)obj[i];
                    if (entity instanceof Model && (projectName = entity.getModel().getUniqueName().getName()) != null && projectName.length() > 0) {
                        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        return new StructuredSelection((Object)eclipseProject);
                    }
                    return new StructuredSelection((Object)new DefaultElementWrapper((Element)entity));
                }
                ++i;
            }
        }
        return new StructuredSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.myListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        SelectionChangedEvent propertyEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            ((ISelectionChangedListener)it.next()).selectionChanged(propertyEvent);
        }
    }
}

