/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.repository;

import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.core.plugin.MMDtrException;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.plugin.StoredFile;
import com.sap.ide.metamodel.core.repository.AddToSourceControlDialog;
import com.sap.ide.metamodel.core.repository.CheckoutDialog;
import com.sap.ide.metamodel.core.repository.IMMRepositoryObjectProvider;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.services.MultilineTextDialog;
import com.sap.ide.metamodel.general.MDOAccessProblem;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RepositoryServices {
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$repository$RepositoryServices;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$plugin$DtrHelper;

    private static boolean allowsAddToSourceControl(VfsActionOnFolderItem[] vfsActionsOnFolderItem) {
        int i = 0;
        while (i < vfsActionsOnFolderItem.length) {
            VfsActionOnFolderItem action = vfsActionsOnFolderItem[i];
            if (action == VfsActionOnFolderItem.CREATE_AND_CHECKOUT) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean refreshFiles(DAVTeamProvider teamProvider, MMRepositoryObject[] repositoryObjects) {
        ArrayList<IFile> fileList = new ArrayList<IFile>();
        int i = 0;
        while (i < repositoryObjects.length) {
            MMRepositoryObject repositoryObject = repositoryObjects[i];
            IFile[] files = repositoryObject.getFiles();
            int j = 0;
            while (j < files.length) {
                IFile file = files[j];
                if (file.exists()) {
                    fileList.add(file);
                }
                ++j;
            }
            ++i;
        }
        IFile[] files = fileList.toArray(new IFile[fileList.size()]);
        boolean succeeded = DtrHelper.refreshFiles(teamProvider, files);
        return succeeded;
    }

    public static void addToSourceControl(IProject project, MMRepositoryObjectList repositoryObjectList) {
        String message = "";
        boolean checkoutPossible = true;
        ArrayList<IFile> fileList = new ArrayList<IFile>();
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)project);
        if (teamProvider == null) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$repository$RepositoryServices == null ? (class$com$sap$ide$metamodel$core$repository$RepositoryServices = RepositoryServices.class$("com.sap.ide.metamodel.core.repository.RepositoryServices")) : class$com$sap$ide$metamodel$core$repository$RepositoryServices, "addToSourceControl", "teamProvider==null", null, false);
            return;
        }
        if (!RepositoryServices.refreshFiles(teamProvider, repositoryObjectList.getRepositoryObjects())) {
            return;
        }
        MMRepositoryObject[] repositoryObjects = repositoryObjectList.getRepositoryObjects();
        int i = 0;
        while (i < repositoryObjects.length) {
            MMRepositoryObject repositoryObject = repositoryObjects[i];
            message = message + "\n" + repositoryObject.getType() + " " + repositoryObject.getName();
            IFile[] files = repositoryObject.getFiles();
            int j = 0;
            while (j < files.length) {
                block19: {
                    IFile file = files[j];
                    if (file.exists()) {
                        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = DtrHelper.getVfsActivityRecordedFolderItem(teamProvider, file);
                        if (vfsActivityRecordedFolderItem == null) {
                            message = message + "\n        error: getting VfsActivityRecordedFolderItem failed for " + file.getFullPath().toString();
                            checkoutPossible = false;
                        } else if (!RepositoryServices.isWorkspaceModifiable((IVfsFolderItem)vfsActivityRecordedFolderItem)) {
                            message = message + "\n        problem: DTR workspace is not modifiable " + file.getFullPath().toString();
                            checkoutPossible = false;
                        } else if (vfsActivityRecordedFolderItem.hasLocalRemoteNameClash()) {
                            message = message + "\n        problem: same file already exists in DTR " + file.getFullPath().toString();
                            checkoutPossible = false;
                        } else if (vfsActivityRecordedFolderItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
                            fileList.add(file);
                            message = message + "\n        info: file is checked out for delete " + file.getFullPath().toString();
                        } else {
                            boolean isNew;
                            try {
                                isNew = DtrHelper.isLocalOnlyAndNotCheckedOut(teamProvider, file);
                            }
                            catch (MMDtrException e) {
                                checkoutPossible = false;
                                break block19;
                            }
                            if (isNew) {
                                VfsActionOnFolderItem[] vfsActionsOnFolderItem = vfsActivityRecordedFolderItem.getActionsForCurrentState();
                                if (RepositoryServices.allowsAddToSourceControl(vfsActionsOnFolderItem)) {
                                    fileList.add(file);
                                    message = message + "\n        " + file.getFullPath().toString();
                                } else {
                                    message = message + "\n        problem: adding file not possible " + file.getFullPath().toString();
                                    checkoutPossible = false;
                                }
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        String title = "Add new Files to Repository";
        AddToSourceControlDialog dialog = new AddToSourceControlDialog(title, message, checkoutPossible);
        dialog.open();
        if (dialog.getDoCheckout()) {
            RepositoryServices.addFilesToSourceControl(teamProvider, fileList);
        }
    }

    public static boolean containsReadonlyFiles(MMRepositoryObject[] repositoryObjects) {
        int i = 0;
        while (i < repositoryObjects.length) {
            MMRepositoryObject repositoryObject = repositoryObjects[i];
            IFile[] files = repositoryObject.getFiles();
            int j = 0;
            while (j < files.length) {
                IFile file = files[j];
                if (file.exists() && file.isReadOnly()) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static MMRepositoryObject[] getReadonlyRepositoryObjects(MMRepositoryObject[] repositoryObjects) {
        ArrayList<MMRepositoryObject> readonlyRepositoryObjects = new ArrayList<MMRepositoryObject>();
        int i = 0;
        while (i < repositoryObjects.length) {
            MMRepositoryObject repositoryObject = repositoryObjects[i];
            IFile[] files = repositoryObject.getFiles();
            int j = 0;
            while (j < files.length) {
                IFile file = files[j];
                if (file.exists() && file.isReadOnly()) {
                    readonlyRepositoryObjects.add(repositoryObject);
                    break;
                }
                ++j;
            }
            ++i;
        }
        MMRepositoryObject[] readonlyRepositoryObjectsAsArray = readonlyRepositoryObjects.toArray(new MMRepositoryObject[readonlyRepositoryObjects.size()]);
        return readonlyRepositoryObjectsAsArray;
    }

    public static boolean checkWriteability(MainDevelopmentObject[] mdos, IMMRepositoryObjectProvider repositoryObjectProvider) {
        MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
        int i = 0;
        while (i < mdos.length) {
            MainDevelopmentObject mdo = mdos[i];
            MMRepositoryObject repositoryObject = repositoryObjectProvider.getRepositoryObject(mdo, false);
            if (repositoryObject != null) {
                repositoryObjectList.addRepositoryObject(repositoryObject);
            } else {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$repository$RepositoryServices == null ? RepositoryServices.class$("com.sap.ide.metamodel.core.repository.RepositoryServices") : class$com$sap$ide$metamodel$core$repository$RepositoryServices, "checkWriteability", "could not find RepositoryObject for " + mdo.getQualifiedName(), null, false);
            }
            ++i;
        }
        return RepositoryServices.checkWriteability(repositoryObjectList.getRepositoryObjects());
    }

    public static boolean checkWriteability(MMRepositoryObject[] repositoryObjects) {
        MMRepositoryObject[] readonlyRepositoryObjects = RepositoryServices.getReadonlyRepositoryObjects(repositoryObjects);
        if (readonlyRepositoryObjects.length == 0) {
            return true;
        }
        String projectName = repositoryObjects[0].getMetamodel().getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (DtrHelper.isProjectUnderSourceControl(project)) {
            String title = "Operation not possible";
            String message = "The operation requires the writeability of the following Objects:";
            boolean checkoutSucceeded = RepositoryServices.showReadonlyRepositoryObjectsAndCheckout(project, readonlyRepositoryObjects, title, message);
            return checkoutSucceeded;
        }
        RepositoryServices.showReadonlyRepositoryObjectsInNonDTRProject(readonlyRepositoryObjects);
        return false;
    }

    public static void checkout(MMRepositoryObject[] repositoryObjects) {
        MMRepositoryObject[] readonlyRepositoryObjects = RepositoryServices.getReadonlyRepositoryObjects(repositoryObjects);
        if (readonlyRepositoryObjects.length == 0) {
            return;
        }
        String projectName = repositoryObjects[0].getMetamodel().getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (DtrHelper.isProjectUnderSourceControl(project)) {
            String title = "Checkout";
            String message = null;
            RepositoryServices.showReadonlyRepositoryObjectsAndCheckout(project, readonlyRepositoryObjects, title, message);
        }
    }

    static boolean showReadonlyRepositoryObjectsAndCheckout(IProject project, MMRepositoryObject[] repositoryObjects, String title, String message) {
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)project);
        if (teamProvider == null) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$repository$RepositoryServices == null ? (class$com$sap$ide$metamodel$core$repository$RepositoryServices = RepositoryServices.class$("com.sap.ide.metamodel.core.repository.RepositoryServices")) : class$com$sap$ide$metamodel$core$repository$RepositoryServices, "showReadonlyRepositoryObjectsAndCheckout", "teamProvider==null", null, false);
            return false;
        }
        if (!DtrHelper.isUserLoggedOn(project) && !DtrHelper.logon(project)) {
            return false;
        }
        if (!RepositoryServices.refreshFiles(teamProvider, repositoryObjects)) {
            return false;
        }
        String lMessage = message != null && message.length() > 0 ? message + "\n" : "";
        boolean checkoutPossible = true;
        boolean filesCheckedOutByOthersExist = false;
        int i = 0;
        while (i < repositoryObjects.length) {
            MMRepositoryObject repositoryObject = repositoryObjects[i];
            lMessage = lMessage + "\n" + repositoryObject.getType() + " " + repositoryObject.getName();
            IFile[] files = repositoryObject.getFiles();
            int j = 0;
            while (j < files.length) {
                IFile file = files[j];
                if (file.exists()) {
                    if (file.isReadOnly()) {
                        IVfsFolderItem vfsFolderItem = teamProvider.getFolderItem((IResource)file);
                        if (vfsFolderItem == null) {
                            String errorMessage = "getFolderItem failed for " + file.getFullPath().toString();
                            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = RepositoryServices.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "showReadonlyRepositoryObjectsAndCheckout", errorMessage, null, false);
                            return false;
                        }
                        if (!RepositoryServices.isWorkspaceModifiable(vfsFolderItem)) {
                            lMessage = lMessage + "\n======>problem: DTR workspace is not modifiable " + file.getFullPath().toString();
                            checkoutPossible = false;
                        } else {
                            VfsFolderItemLocationState state = vfsFolderItem.getLocationState();
                            if (state == VfsFolderItemLocationState.LOCAL_ONLY) {
                                lMessage = lMessage + "\n======>problem: readonly but not in DTR " + file.getFullPath().toString();
                                checkoutPossible = false;
                            } else if (state != VfsFolderItemLocationState.SYNCED_TO_LATEST) {
                                lMessage = lMessage + "\n======>    problem: not synced to latest " + file.getFullPath().toString();
                                checkoutPossible = false;
                            } else {
                                String[] otherCheckouters = RepositoryServices.getOtherCheckouters(teamProvider, file);
                                if (otherCheckouters != null && otherCheckouters.length > 0) {
                                    filesCheckedOutByOthersExist = true;
                                    String users = "";
                                    int k = 0;
                                    while (k < otherCheckouters.length) {
                                        users = users.length() == 0 ? otherCheckouters[k] : users + "," + otherCheckouters[k];
                                        ++k;
                                    }
                                    lMessage = lMessage + "\n======>WARNING: already checked out by " + users + ":" + file.getFullPath().toString();
                                } else {
                                    lMessage = lMessage + "\n        readonly: " + file.getFullPath().toString();
                                }
                            }
                        }
                    } else {
                        lMessage = lMessage + "\n        " + file.getFullPath().toString();
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!checkoutPossible) {
            lMessage = "Checkout is not possible. See below for details.\n\n" + lMessage;
        }
        CheckoutDialog checkoutDialog = new CheckoutDialog(title, lMessage, checkoutPossible, filesCheckedOutByOthersExist);
        checkoutDialog.open();
        if (checkoutDialog.getDoCheckout()) {
            boolean checkoutSucceeded = RepositoryServices.checkout(teamProvider, repositoryObjects);
            return checkoutSucceeded;
        }
        return false;
    }

    static void showReadonlyRepositoryObjectsInNonDTRProject(MMRepositoryObject[] repositoryObjects) {
        String message = "The operation requires the writeability of the following Objects:\n";
        message = message + "The project is not in DTR, but there are readonly files!\n";
        int i = 0;
        while (i < repositoryObjects.length) {
            MMRepositoryObject repositoryObject = repositoryObjects[i];
            message = message + "\n" + repositoryObject.getType() + " " + repositoryObject.getName();
            IFile[] files = repositoryObject.getFiles();
            int j = 0;
            while (j < files.length) {
                IFile file = files[j];
                if (file.exists() && file.isReadOnly()) {
                    message = message + "\n        readonly: " + file.getFullPath().toString();
                }
                ++j;
            }
            ++i;
        }
        String title = "Operation not possible";
        CheckoutDialog checkoutDialog = new CheckoutDialog(title, message, false, false);
        checkoutDialog.open();
    }

    private static String[] getOtherCheckouters(DAVTeamProvider teamProvider, IFile file) {
        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = DtrHelper.getVfsActivityRecordedFolderItem(teamProvider, file);
        if (vfsActivityRecordedFolderItem == null) {
            return null;
        }
        IVfsFile vfsFile = vfsActivityRecordedFolderItem.asFile();
        if (vfsFile == null) {
            String errorMessage = "asFile failed for " + file.getFullPath().toString();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = RepositoryServices.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "isCheckedOutByOtherUser", errorMessage, null, false);
            return null;
        }
        boolean checkedout = vfsFile.isCheckedOutByOthers();
        if (checkedout) {
            return vfsFile.getOtherCheckouters();
        }
        return null;
    }

    private static void switchStateFromDeleteToEdit(IFile file, IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem, IVfsActivity vfsActivity) {
        String message;
        StringBuffer buffer = new StringBuffer();
        StoredFile.readFile(file, buffer);
        String path = file.getLocation().toString();
        try {
            File nativeFile = new File(path);
            nativeFile.delete();
        }
        catch (Exception e) {
            String message2 = "deleting file failed: " + path;
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = RepositoryServices.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "switchStateFromDeleteToEdit", message2, e, false);
            return;
        }
        try {
            vfsActivityRecordedFolderItem.uncheckout();
        }
        catch (VfsException e) {
            message = "uncheckout failed: " + vfsActivityRecordedFolderItem.getLocalPath();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = RepositoryServices.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "switchStateFromDeleteToEdit", message, e, false);
        }
        try {
            vfsActivityRecordedFolderItem.checkOutForEdit(vfsActivity);
        }
        catch (VfsException e) {
            message = "checkOutForEdit failed: " + vfsActivityRecordedFolderItem.getLocalPath();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = RepositoryServices.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "switchStateFromDeleteToEdit", message, e, false);
        }
        StoredFile.writeFile(file, buffer);
    }

    private static void addFilesToSourceControl(DAVTeamProvider teamProvider, List files) {
        IVfsActivity vfsActivity = null;
        boolean result = true;
        String message = "";
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            IFile file = (IFile)iterator.next();
            IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = DtrHelper.getVfsActivityRecordedFolderItem(teamProvider, file);
            if (vfsActivityRecordedFolderItem == null) continue;
            if (vfsActivity == null) {
                vfsActivity = RepositoryServices.getActivity(vfsActivityRecordedFolderItem);
            }
            if (vfsActivity == null) {
                return;
            }
            if (file.isReadOnly()) {
                message = message + "Add failed: file is readonly: " + file.getFullPath().toString() + "\n";
                result = false;
                continue;
            }
            if (vfsActivityRecordedFolderItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
                RepositoryServices.switchStateFromDeleteToEdit(file, vfsActivityRecordedFolderItem, vfsActivity);
                continue;
            }
            try {
                vfsActivityRecordedFolderItem.createAndCheckout(vfsActivity);
            }
            catch (VfsException e) {
                message = message + "Add failed: " + e.getMessage() + " " + file.getFullPath().toString() + "\n";
                result = false;
            }
        }
        if (!result) {
            MultilineTextDialog multilineTextDialog = new MultilineTextDialog("Errors occured on add", message);
            multilineTextDialog.open();
        }
    }

    private static boolean checkout(DAVTeamProvider teamProvider, MMRepositoryObject[] repositoryObjects) {
        IVfsActivity vfsActivity = null;
        boolean result = true;
        String message = "";
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.open();
        IProgressMonitor progressMonitor = dialog.getProgressMonitor();
        progressMonitor.beginTask("Checkout files", repositoryObjects.length);
        int i = 0;
        while (i < repositoryObjects.length) {
            MMRepositoryObject repositoryObject = repositoryObjects[i];
            IFile[] files = repositoryObject.getFiles();
            int j = 0;
            while (j < files.length) {
                IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem;
                IFile file = files[j];
                if (file.exists() && file.isReadOnly() && (vfsActivityRecordedFolderItem = DtrHelper.getVfsActivityRecordedFolderItem(teamProvider, file)) != null) {
                    if (vfsActivity == null) {
                        vfsActivity = RepositoryServices.getActivity(vfsActivityRecordedFolderItem);
                    }
                    if (vfsActivity == null) {
                        dialog.close();
                        return false;
                    }
                    progressMonitor.subTask("checkout " + file.getFullPath().toString());
                    try {
                        vfsActivityRecordedFolderItem.checkOutForEdit(vfsActivity);
                    }
                    catch (VfsException e) {
                        message = message + "Checkout failed: " + e.getMessage() + " " + file.getFullPath().toString() + "\n";
                        result = false;
                    }
                }
                ++j;
            }
            progressMonitor.worked(1);
            ++i;
        }
        dialog.close();
        if (!result) {
            MultilineTextDialog multilineTextDialog = new MultilineTextDialog("Errors occured on checkout", message);
            multilineTextDialog.open();
        }
        return result;
    }

    private static IVfsActivity getActivity(IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem) {
        IVfsWorkspace workspace = vfsActivityRecordedFolderItem.getWorkspace();
        if (WorkspacesWithDefaultActivity.usingDefaultActivity((IVfsWorkspace)workspace)) {
            IVfsActivity vfsActivity;
            try {
                vfsActivity = workspace.getDefaultActivity();
            }
            catch (VfsException e) {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$repository$RepositoryServices == null ? (class$com$sap$ide$metamodel$core$repository$RepositoryServices = RepositoryServices.class$("com.sap.ide.metamodel.core.repository.RepositoryServices")) : class$com$sap$ide$metamodel$core$repository$RepositoryServices, "getActivity", "getDefaultActivity failed", e, false);
                return null;
            }
            return vfsActivity;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SelectActivityDialog selectActivityDialog = new SelectActivityDialog(shell, workspace);
        int selectActivityDialogResult = selectActivityDialog.open();
        if (selectActivityDialogResult != 0) {
            return null;
        }
        IVfsActivity[] activities = selectActivityDialog.getActivitySelection();
        IVfsActivity vfsActivity = activities != null && activities.length > 0 ? activities[0] : null;
        return vfsActivity;
    }

    public static void getRepositoryObjectsAffectedByMDODeletion(IMMRepositoryObjectProvider repositoryObjectProvider, MainDevelopmentObject mdo, MMRepositoryObjectList result) {
        MDOAccessProblem[] accessProblems = mdo.checkForDelete();
        int i = 0;
        while (i < accessProblems.length) {
            MDOAccessProblem accessProblem = accessProblems[i];
            MainDevelopmentObject accessProblemMdo = accessProblem.getMDO();
            MMRepositoryObject repositoryObject = repositoryObjectProvider.getRepositoryObject(accessProblemMdo, true);
            if (repositoryObject != null) {
                result.addRepositoryObject(repositoryObject);
            } else {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$repository$RepositoryServices == null ? RepositoryServices.class$("com.sap.ide.metamodel.core.repository.RepositoryServices") : class$com$sap$ide$metamodel$core$repository$RepositoryServices, "getRepositoryObjectsAffectedByMDODeletion", "could not find RepositoryObject for " + mdo.getQualifiedName(), null, false);
            }
            ++i;
        }
    }

    private static boolean isWorkspaceModifiable(IVfsFolderItem vfsFolderItem) {
        boolean modifiable = false;
        try {
            modifiable = vfsFolderItem.asActivityRecordedFolderItem().getWorkspace().isModifiable();
        }
        catch (NullPointerException e) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$repository$RepositoryServices == null ? (class$com$sap$ide$metamodel$core$repository$RepositoryServices = RepositoryServices.class$("com.sap.ide.metamodel.core.repository.RepositoryServices")) : class$com$sap$ide$metamodel$core$repository$RepositoryServices, "isWorkspaceModifiable", "Exception occured", e, false);
        }
        return modifiable;
    }

    public static boolean checkWriteability(MainDevelopmentObject[] mdos) {
        MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
        int i = 0;
        while (i < mdos.length) {
            MainDevelopmentObject mdo = mdos[i];
            MMRepositoryObject repositoryObject = RepositoryServices.getRepositoryObject(mdo);
            if (repositoryObject != null) {
                repositoryObjectList.addRepositoryObject(repositoryObject);
            } else {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$repository$RepositoryServices == null ? RepositoryServices.class$("com.sap.ide.metamodel.core.repository.RepositoryServices") : class$com$sap$ide$metamodel$core$repository$RepositoryServices, "checkWriteability(MainDevelopmentObject[] mdos)", "could not find RepositoryObject for " + mdo.getQualifiedName(), null, false);
            }
            ++i;
        }
        return RepositoryServices.checkWriteability(repositoryObjectList.getRepositoryObjects());
    }

    private static MMRepositoryObject getRepositoryObject(MainDevelopmentObject mdo) {
        MetamodelManager metamodelManager = MetamodelManager.getMetamodelManager(mdo.getMetamodel().getName());
        IMMRepositoryObjectProvider[] providers = metamodelManager.getRepositoryObjectProvider();
        MMRepositoryObject repositoryObject = MetamodelManager.getRepositoryObject(mdo, providers);
        return repositoryObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

