/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.repository;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MMRepositoryObject {
    private Metamodel mMetamodel;
    private String mType;
    private String mName;
    private boolean mIncludesAllLanguageFiles;
    private IProject mProject;
    private String mProjectName;
    private ArrayList mMDOs;
    private ArrayList mAdditionalFiles;

    public MMRepositoryObject(Metamodel metamodel, String type, String name, boolean includesAllLanguageFiles) {
        this.mMetamodel = metamodel;
        this.mType = type;
        this.mName = name;
        this.mIncludesAllLanguageFiles = true;
        this.mMDOs = new ArrayList();
        this.mAdditionalFiles = new ArrayList();
        this.mProjectName = metamodel.getName();
        this.mProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
    }

    public Metamodel getMetamodel() {
        return this.mMetamodel;
    }

    public String getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public void addMDO(MainDevelopmentObject mdo) {
        if (mdo.originatesInArchive()) {
            String message = "MDO is part of an archive! " + mdo.getAbsolutePath();
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "addMDO", message, null, false);
            return;
        }
        this.mMDOs.add(mdo);
    }

    public int getMDOCount() {
        return this.mMDOs.size();
    }

    public void addAdditionalFile(IPath path) {
        IFile file = this.mProject.getFile(path);
        if (file != null) {
            this.mAdditionalFiles.add(file);
        }
    }

    public int getAdditionalFileCount() {
        return this.mAdditionalFiles.size();
    }

    public MainDevelopmentObject getMDO(int index) {
        return (MainDevelopmentObject)this.mMDOs.get(index);
    }

    public IFile getMDOFile(int index) {
        MainDevelopmentObject mdo = (MainDevelopmentObject)this.mMDOs.get(index);
        return this.getFile(mdo.getAbsolutePath());
    }

    public IFile getAdditionalFile(int index) {
        IFile file = (IFile)this.mAdditionalFiles.get(index);
        return file;
    }

    private ArrayList getLanguageFiles() {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.mMDOs.size()) {
            MainDevelopmentObject mdo = (MainDevelopmentObject)this.mMDOs.get(i);
            if (this.mIncludesAllLanguageFiles) {
                String[] languages = mdo.getTextPool().getAvailableLanguages();
                int j = 0;
                while (j < languages.length) {
                    this.addLanguageFile(mdo, languages[j], list);
                    ++j;
                }
            } else if (mdo.getMasterLanguage().equals(this.mMetamodel.getLanguage())) {
                this.addLanguageFile(mdo, "", list);
                this.addLanguageFile(mdo, mdo.getMasterLanguage(), list);
            } else {
                this.addLanguageFile(mdo, "", list);
            }
            ++i;
        }
        return list;
    }

    private void addLanguageFile(MainDevelopmentObject mdo, String language, ArrayList list) {
        String languageFilePath = mdo.getTextPool().getAbsolutePath(language);
        IFile file = this.getFile(languageFilePath);
        if (file != null) {
            list.add(file);
        }
    }

    private IFile getFile(String absolutePath) {
        Path path = new Path(absolutePath);
        IPath location = this.mProject.getLocation();
        int nrOfMatchingSegments = path.matchingFirstSegments(location);
        if (nrOfMatchingSegments <= 0) {
            String message = "nrOfMatchingSegments == 0 path = " + path + " location = " + location;
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "getFile", message, null, false);
            return null;
        }
        IPath lPath = path.removeFirstSegments(nrOfMatchingSegments);
        IFile file = this.mProject.getFile(lPath);
        return file;
    }

    public IFile[] getFiles() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        result.addAll(this.mAdditionalFiles);
        result.addAll(this.getLanguageFiles());
        int i = 0;
        while (i < this.mMDOs.size()) {
            MainDevelopmentObject mdo = (MainDevelopmentObject)this.mMDOs.get(i);
            IFile file = this.getFile(mdo.getAbsolutePath());
            if (file != null) {
                result.add(file);
            }
            ++i;
        }
        return result.toArray(new IFile[0]);
    }

    public static boolean coverSameRepositoryObject(MMRepositoryObject object1, MMRepositoryObject object2) {
        if (object1.mMetamodel != object2.mMetamodel) {
            return false;
        }
        boolean result = object1.mType.equals(object2.mType) && object1.mName.equals(object2.mName);
        return result;
    }

    public void mergeRepositoryObject(MMRepositoryObject repositoryObject) {
        this.mIncludesAllLanguageFiles |= repositoryObject.mIncludesAllLanguageFiles;
        int size = repositoryObject.mAdditionalFiles.size();
        int i = 0;
        while (i < size) {
            IFile file = (IFile)repositoryObject.mAdditionalFiles.get(i);
            if (!this.containsAdditionalFile(file)) {
                this.mAdditionalFiles.add(file);
            }
            ++i;
        }
        size = repositoryObject.mMDOs.size();
        int i2 = 0;
        while (i2 < size) {
            MainDevelopmentObject mdo = (MainDevelopmentObject)repositoryObject.mMDOs.get(i2);
            if (!this.containsMDO(mdo)) {
                this.mMDOs.add(mdo);
            }
            ++i2;
        }
    }

    public boolean containsAdditionalFile(IFile file) {
        int size = this.mAdditionalFiles.size();
        int i = 0;
        while (i < size) {
            IFile lFile = (IFile)this.mAdditionalFiles.get(i);
            if (lFile.equals((Object)file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsMDO(MainDevelopmentObject mdo) {
        boolean result = this.mMDOs.contains(mdo);
        return result;
    }
}

