/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.repository;

import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.core.services.TextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CheckoutDialog
extends Dialog {
    private static int CHECKOUT_BUTTON_ID = 1025;
    private Text mTextField = null;
    private String mMessage = null;
    private String mTitle = null;
    private boolean mCheckoutEnabled;
    private boolean mFilesCheckedOutByOthersExist;
    private boolean mDoCheckout = false;

    public boolean getDoCheckout() {
        return this.mDoCheckout;
    }

    public CheckoutDialog(String title, String message, boolean checkoutEnabled, boolean filesCheckedOutByOthersExist) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.mCheckoutEnabled = checkoutEnabled;
        this.mFilesCheckedOutByOthersExist = filesCheckedOutByOthersExist;
        this.mMessage = message;
        this.mTitle = title;
        this.setShellStyle(67696);
    }

    protected void buttonPressed(int id) {
        if (id == CHECKOUT_BUTTON_ID) {
            String message;
            String title;
            if (this.mFilesCheckedOutByOthersExist && !ServicesUI.askUserToConfirm(title = TextPool.getInstance().getText(420), message = TextPool.getInstance().getText(422), 1)) {
                return;
            }
            this.mDoCheckout = true;
            this.close();
        }
        super.buttonPressed(id);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.mTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        boolean cancelButtonIsDefault = true;
        if (this.mCheckoutEnabled) {
            this.createButton(parent, CHECKOUT_BUTTON_ID, "Check Out ", true);
            cancelButtonIsDefault = false;
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, cancelButtonIsDefault);
    }

    protected final Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        ((GridLayout)parentComposite.getLayout()).numColumns = 2;
        Image image = JFaceResources.getImageRegistry().get("dialog_info_image");
        if (image != null) {
            Label label = new Label(parentComposite, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        IGridLayoutPane userArea = PaneFactory.createGridLayoutPane((Composite)parentComposite, (int)1);
        GridData userAreaData = new GridData(1808);
        userArea.setLayoutData((Object)userAreaData);
        IGridLayoutData gridLayoutData = userArea.createGridLayoutData(4, 4, true, false);
        this.mTextField = userArea.addTextPane(this.mMessage, true, true, gridLayoutData);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 800;
        this.mTextField.setLayoutData((Object)gridData);
        return parentComposite;
    }
}

