/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.project;

import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.dc.DevComponentService;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.project.ProjectReloadNotificator;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.TextPool;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.exception.LoadException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectService {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String PROJECT_PROPERTY_HAS_METAMODEL_LOCAL_NAME = "projectHasMetamodelProperty";
    private static final String PROJECT_PROPERTY_HAS_METAMODEL_KEY = "com.sap.ide.metamodel.core.projectHasMetamodelProperty";
    private static final QualifiedName PROJECT_PROPERTY_HAS_METAMODEL = new QualifiedName("com.sap.ide.metamodel.core.projectHasMetamodelProperty", "projectHasMetamodelProperty");
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$project$ProjectService;

    public static void addPublicPartJars(IProject project, IPath[] fullPaths) {
        ProjectService.addPublicPartJars(project, fullPaths, true);
    }

    private static void addPublicPartJars(IProject project, IPath[] fullPaths, boolean reload) {
        if (fullPaths.length < 1) {
            return;
        }
        if (!ProjectService.isMetamodelUpdateRelevantProject(project)) {
            return;
        }
        boolean updateNecessary = false;
        Metamodel metamodel = MetamodelManager.getMetamodel(project.getName());
        String[] setArchives = metamodel.getArchives();
        int i = 0;
        while (i < fullPaths.length) {
            String jarPath = fullPaths[i].toString();
            if (ProjectService.isDCTypeMetamodelRelevant(jarPath)) {
                if (!ProjectService.isContained(setArchives, jarPath)) {
                    if (ProjectService.isWDOrDDContentArchive(jarPath)) {
                        ServicesEclipse.addContentArchiveIgnoreSameName(metamodel, jarPath);
                    } else {
                        metamodel.addArchive(jarPath);
                    }
                    updateNecessary = true;
                    MetamodelCoreEclipsePlugin.logMessage("Added metamodel archive: " + jarPath);
                } else {
                    MetamodelCoreEclipsePlugin.internalWarning(class$com$sap$ide$metamodel$core$project$ProjectService == null ? ProjectService.class$("com.sap.ide.metamodel.core.project.ProjectService") : class$com$sap$ide$metamodel$core$project$ProjectService, "addPublicPartJars(IProject, IPath[]", "Archive was already added to metamodel [" + metamodel.toString() + "]: " + jarPath, new Exception());
                }
            }
            ++i;
        }
        if (updateNecessary && reload) {
            try {
                if (metamodel.isModified()) {
                    ProjectReloadNotificator.showReloadProjectPopup(project.getName());
                } else {
                    MetamodelManager.reloadMetamodel(project.getName());
                }
            }
            catch (Exception e) {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$project$ProjectService == null ? (class$com$sap$ide$metamodel$core$project$ProjectService = ProjectService.class$("com.sap.ide.metamodel.core.project.ProjectService")) : class$com$sap$ide$metamodel$core$project$ProjectService, "addPublicPartJars(IProject, IPath[], boolean)", e.getMessage(), e, true);
            }
        }
    }

    private static boolean isWDOrDDContentArchive(String jarPath) {
        String contentType = DevComponentService.getPublicPartManifestAttributeValue(jarPath, "MM-Content");
        return contentType.equals("Dictionary") || contentType.equals("Web Dynpro");
    }

    public static void refreshMetamodelJARs(Metamodel metamodel) {
        Root[] roots = metamodel.getRoots();
        int i = 0;
        while (i < roots.length) {
            try {
                roots[i].rescanRootMDOs();
            }
            catch (LoadException e) {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$project$ProjectService == null ? ProjectService.class$("com.sap.ide.metamodel.core.project.ProjectService") : class$com$sap$ide$metamodel$core$project$ProjectService, "refreshMetamodelJARs(Metamodel)", e.getMessage(), e, false);
            }
            ++i;
        }
    }

    public static void updateMetamodelJarsFromClasspath(IProject project) {
        IJavaProject javaProject = ServicesEclipse.getJavaProject(project.getName());
        if (javaProject == null) {
            return;
        }
        MetamodelCoreEclipsePlugin.logMessage("Updating metamodel archives from classpath for project " + project.getName());
        IClasspathEntry[] classpathEntries = null;
        try {
            classpathEntries = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$project$ProjectService == null ? (class$com$sap$ide$metamodel$core$project$ProjectService = ProjectService.class$("com.sap.ide.metamodel.core.project.ProjectService")) : class$com$sap$ide$metamodel$core$project$ProjectService, "updateMetamodelJarsFromClasspath(IProject)", e.getMessage(), e, false);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < classpathEntries.length) {
            if (classpathEntries[i].getEntryKind() == 1) {
                IPath path = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntries[i]).getPath();
                list.add(path);
            }
            ++i;
        }
        Metamodel metamodel = MetamodelManager.getMetamodel(project.getName());
        String[] contentJARs = ProjectService.getContentJars(metamodel.getArchives());
        int i2 = 0;
        while (i2 < contentJARs.length) {
            Path path = new Path(contentJARs[i2]);
            if (!list.contains(path)) {
                list.add(path);
            }
            ++i2;
        }
        IPath[] paths = new IPath[list.size()];
        paths = list.toArray(paths);
        metamodel.removeAllArchives();
        ProjectService.addPublicPartJars(project, paths, false);
    }

    public static IClasspathEntry[] getMetamodelRelevantEntries(IClasspathEntry[] classpathEntrys) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < classpathEntrys.length) {
            String path;
            if (classpathEntrys[i].getEntryKind() == 1 && ProjectService.isDCTypeMetamodelRelevant(path = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntrys[i]).getPath().toString())) {
                list.add(classpathEntrys[i]);
            }
            ++i;
        }
        IClasspathEntry[] relevantEntrys = new IClasspathEntry[list.size()];
        relevantEntrys = list.toArray(relevantEntrys);
        return relevantEntrys;
    }

    public static IPath[] getFullPaths(IClasspathEntry[] classpathEntrys) {
        IPath[] paths = new IPath[classpathEntrys.length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntrys[i]).getPath();
            ++i;
        }
        return paths;
    }

    private static boolean isDCTypeMetamodelRelevant(String fullPublicPartArchivePath) {
        boolean isRelevant = false;
        String dcType = DevComponentService.getPublicPartManifestAttributeValue(fullPublicPartArchivePath, "DC-Type");
        if (dcType != null && dcType.length() > 0 && (dcType.equals("Dictionary") || dcType.equals("Common Model") || dcType.equals("Web Dynpro"))) {
            isRelevant = true;
        }
        return isRelevant;
    }

    private static String[] getContentJars(String[] metamodelJars) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < metamodelJars.length) {
            String mmContent = DevComponentService.getPublicPartManifestAttributeValue(metamodelJars[i], "MM-Content");
            if (mmContent != null && mmContent.length() > 0) {
                list.add(metamodelJars[i]);
            }
            ++i;
        }
        String[] contentJars = new String[list.size()];
        contentJars = list.toArray(contentJars);
        return contentJars;
    }

    public static boolean projectExists(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project == null) {
            return false;
        }
        return project.exists();
    }

    public static boolean isContained(String[] entries, String entry) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i].equals(entry)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isMetamodelUpdateRelevantProject(IProject project) {
        boolean isRelevant = false;
        if (project == null || !project.isAccessible()) {
            return false;
        }
        IProjectNature nature = null;
        try {
            nature = project.getNature("com.sap.dictionary.tools.archivebuilder.DictionaryNature");
            if (nature != null) {
                isRelevant = true;
            } else {
                nature = project.getNature("com.sap.ide.webdynpro.archivebuilder.WebDynproNature");
                if (nature != null) {
                    isRelevant = true;
                }
            }
        }
        catch (CoreException e) {
            String message = "Error checking project nature.";
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$project$ProjectService == null ? (class$com$sap$ide$metamodel$core$project$ProjectService = ProjectService.class$("com.sap.ide.metamodel.core.project.ProjectService")) : class$com$sap$ide$metamodel$core$project$ProjectService, "isMetamodelUpdateRelevantProject(IProject)", message, null, false);
        }
        return isRelevant;
    }

    public static boolean checkMetamodelLanguage(Metamodel metamodel) {
        String projectName = metamodel.getName();
        IDCExtendedProject dcProject = ServicesEclipse.getComponentProject(projectName);
        if (dcProject == null) {
            return true;
        }
        String dcLanguage = dcProject.getLanguage();
        String metamodelLanguage = metamodel.getLanguage();
        return metamodelLanguage.equals(dcLanguage);
    }

    public static FileInfo getFileInfo(IProject project, IFile file) {
        FileInfo fileInfo = new FileInfo();
        IJavaProject javaProject = ProjectService.getJavaProject(project);
        if (javaProject == null) {
            return null;
        }
        IPackageFragment packageFragment = null;
        IPath path = file.getFullPath().removeLastSegments(1);
        try {
            packageFragment = javaProject.findPackageFragment(path);
        }
        catch (JavaModelException e) {
            return null;
        }
        if (packageFragment == null) {
            return null;
        }
        fileInfo.setPackageName(packageFragment.getElementName());
        String name = file.getName();
        int dotIndex = name.indexOf(46);
        if (dotIndex == -1) {
            fileInfo.setExtension("");
            fileInfo.setName(name);
        } else {
            fileInfo.setName(name.substring(0, dotIndex));
            fileInfo.setExtension(name.substring(dotIndex + 1, name.length()));
        }
        return fileInfo;
    }

    private static IJavaProject getJavaProject(IProject project) {
        IProjectNature nature = null;
        IJavaProject javaProject = null;
        try {
            nature = project.getNature("org.eclipse.jdt.core.javanature");
            if (nature instanceof IJavaProject) {
                javaProject = (IJavaProject)nature;
            }
        }
        catch (CoreException e) {
            return null;
        }
        return javaProject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class FileInfo {
        private String mPackageName;
        private String mName;
        private String mExtension;

        public String getExtension() {
            return this.mExtension;
        }

        public String getName() {
            return this.mName;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public void setExtension(String string) {
            this.mExtension = string;
        }

        public void setName(String string) {
            this.mName = string;
        }

        public void setPackageName(String string) {
            this.mPackageName = string;
        }
    }
}

