/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.project;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.TextPool;
import com.sap.ide.metamodel.general.exception.I18NException;
import com.sap.ide.metamodel.general.i18n.I18NService;
import com.sap.ide.metamodel.general.i18n.LanguageInfo;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private List mArchiveList = null;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        IGridLayoutPane propertyPane = PaneFactory.createGridLayoutPane((Composite)root, (int)2);
        propertyPane.addTextLabel(mTextPool.getText(417));
        IGridLayoutData gd = propertyPane.createGridLayoutData(4, 1, true, false);
        propertyPane.addTextField(this.getProjectLanguage(), true, gd);
        propertyPane.addTextLabel(mTextPool.getText(418));
        propertyPane.addPlaceholder();
        gd = propertyPane.createGridLayoutData(4, 4, true, true, 2, 1);
        gd.getGridData().widthHint = 200;
        this.mArchiveList = propertyPane.addList(this.getMetamodelArchivePaths(), false, gd);
        propertyPane.addTextLabel(mTextPool.getText(419));
        return root;
    }

    private String getProjectLanguage() {
        IProject project;
        Metamodel metamodel;
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject && (metamodel = MetamodelManager.getMetamodel((project = (IProject)adaptable).getName())) != null) {
            String language = metamodel.getLanguage();
            I18NService service = I18NService.getInstance();
            LanguageInfo[] languageInfos = null;
            try {
                languageInfos = service.getValidLanguages();
            }
            catch (I18NException e) {
                MetamodelCoreEclipsePlugin.internalError(((Object)((Object)this)).getClass(), "getProjectLanguage()", e.getMessage(), e, false);
                return "<ERROR>";
            }
            int i = 0;
            while (i < languageInfos.length) {
                if (languageInfos[i].getName().equals(language)) {
                    return languageInfos[i].getDescription();
                }
                ++i;
            }
        }
        return "<ERROR>";
    }

    private Metamodel getProjectMetamodel() {
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            IProject project = (IProject)adaptable;
            return MetamodelManager.getMetamodel(project.getName());
        }
        return null;
    }

    private String[] getMetamodelArchivePaths() {
        Metamodel metamodel = this.getProjectMetamodel();
        String[] ret = new String[]{};
        if (metamodel != null) {
            ret = metamodel.getArchives();
        }
        int i = 0;
        while (i < ret.length) {
            Path path = new Path(ret[i]);
            ret[i] = path.lastSegment() + " - " + path.removeLastSegments(1);
            ++i;
        }
        return ret;
    }
}

