/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.project;

import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.component.IProjectUpdatedListener;
import com.sap.ide.eclipse.dii.component.JavaProjectUpdatedEvent;
import com.sap.ide.eclipse.dii.component.ProjectUpdatedEvent;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.project.ProjectReloadNotificator;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.TextPool;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public class MetamodelProjectUpdatedListener
implements IProjectUpdatedListener {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static HashMap mInstanceMap = new HashMap();
    private IProject mProject = null;
    private IDevelopmentConfiguration mDevelopmentConfiguration = null;
    private IResourceChangeListener mResourceChangeListener = null;
    private boolean mReloadNeccessary = false;

    private MetamodelProjectUpdatedListener(IProject project) {
        this.mProject = project;
        IDCExtendedProject componentProject = ServicesEclipse.getComponentProject(project.getName());
        if (componentProject != null) {
            this.mDevelopmentConfiguration = componentProject.getConfiguration();
        }
        this.mResourceChangeListener = new MetamodelJARResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.mResourceChangeListener);
    }

    public static MetamodelProjectUpdatedListener getInstance(IProject project) {
        MetamodelProjectUpdatedListener listener = null;
        if (mInstanceMap.containsKey(project)) {
            listener = (MetamodelProjectUpdatedListener)mInstanceMap.get(project);
        } else {
            listener = new MetamodelProjectUpdatedListener(project);
            mInstanceMap.put(project, listener);
        }
        return listener;
    }

    public static boolean projectHasListener(IProject project) {
        return mInstanceMap.containsKey(project);
    }

    public static void deleteInstanceForProject(IProject project) {
        MetamodelProjectUpdatedListener instance = MetamodelProjectUpdatedListener.getInstance(project);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(instance.getResourceChangeListener());
        mInstanceMap.remove(project);
    }

    public IDevelopmentConfiguration getDevelopmentConfiguration() {
        return this.mDevelopmentConfiguration;
    }

    public void projectUpdated(ProjectUpdatedEvent e) {
        MetamodelCoreEclipsePlugin.logMessage("Received project updated event");
        IProject project = null;
        if (e.getSource() instanceof IProject) {
            project = (IProject)e.getSource();
        } else {
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "projectUpdated(ProjectUpdatedEvent)", "Source object is no project", new Exception(), true);
        }
        Metamodel metamodel = MetamodelManager.getMetamodel(project.getName());
        if (e instanceof JavaProjectUpdatedEvent) {
            MetamodelCoreEclipsePlugin.logMessage("Update metamodel jars for metamodel " + metamodel.getName());
            JavaProjectUpdatedEvent event = (JavaProjectUpdatedEvent)e;
            project = event.getJavaProject().getProject();
            JavaProjectUpdatedEvent.ClassPathDelta delta = event.getClassPathDelta();
            boolean reload = false;
            IClasspathEntry[] removedEntries = delta.removed;
            IPath[] paths = new IPath[removedEntries.length];
            int i = 0;
            while (i < removedEntries.length) {
                paths[i] = JavaCore.getResolvedClasspathEntry((IClasspathEntry)removedEntries[i]).getPath();
                ++i;
            }
            if (paths.length > 0) {
                reload = true;
            }
            IClasspathEntry[] addedEntries = delta.added;
            paths = new IPath[addedEntries.length];
            int i2 = 0;
            while (i2 < addedEntries.length) {
                paths[i2] = JavaCore.getResolvedClasspathEntry((IClasspathEntry)addedEntries[i2]).getPath();
                ++i2;
            }
            if (paths.length > 0) {
                reload = true;
            }
            if (reload) {
                if (metamodel.isModified()) {
                    ProjectReloadNotificator.showReloadProjectPopup(project.getName());
                } else {
                    MetamodelManager.reloadMetamodel(project.getName());
                }
            }
        }
    }

    private IResourceChangeListener getResourceChangeListener() {
        return this.mResourceChangeListener;
    }

    private class MetamodelJARResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private MetamodelJARResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!ProjectService.isMetamodelUpdateRelevantProject(MetamodelProjectUpdatedListener.this.mProject)) {
                return;
            }
            MetamodelProjectUpdatedListener.this.mReloadNeccessary = false;
            try {
                if (event != null && event.getDelta() != null) {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException e) {
                MetamodelCoreEclipsePlugin.internalError(this.getClass(), "resourceChanged(IResourceChangeEvent)", e.getMessage(), e, true);
            }
            if (MetamodelProjectUpdatedListener.this.mReloadNeccessary) {
                try {
                    Metamodel metamodel = MetamodelManager.getMetamodel(MetamodelProjectUpdatedListener.this.mProject.getName());
                    if (metamodel.isModified()) {
                        ProjectReloadNotificator.showReloadProjectPopup(MetamodelProjectUpdatedListener.this.mProject.getName());
                    } else {
                        MetamodelManager.reloadMetamodel(MetamodelProjectUpdatedListener.this.mProject.getName());
                    }
                }
                catch (Exception e) {
                    MetamodelCoreEclipsePlugin.internalError(this.getClass(), "resourceChanged(IResourceChangeEvent)", e.getMessage(), e, true);
                }
            }
            MetamodelProjectUpdatedListener.this.mReloadNeccessary = false;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IProject project = delta.getResource().getProject();
            if (project == null) {
                return true;
            }
            if (!project.isAccessible()) {
                return false;
            }
            if (!(delta.getResource() instanceof IFile)) {
                return true;
            }
            IFile file = (IFile)delta.getResource();
            if (file.getFileExtension() == null) {
                return false;
            }
            if (!file.getFileExtension().equalsIgnoreCase("jar")) {
                return false;
            }
            Metamodel metamodel = MetamodelManager.getMetamodel(MetamodelProjectUpdatedListener.this.mProject.getName());
            String fileName = file.getLocation().toString();
            String[] archives = metamodel.getArchives();
            if (ProjectService.isContained(archives, fileName)) {
                MetamodelProjectUpdatedListener.this.mReloadNeccessary = true;
                return false;
            }
            return true;
        }
    }
}

