/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.plugin;

import com.sap.ide.metamodel.core.plugin.StoredFile;
import com.sap.ide.metamodel.general.DevelopmentObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class StoredFilesManager {
    private Map mStoredFiles = new HashMap();
    private IProject mProject;

    StoredFilesManager(IProject project) {
        this.mProject = project;
    }

    public void addStoredFile(DevelopmentObject developmentObject, IPath path) {
        if (this.mStoredFiles.containsKey(developmentObject) || path == null) {
            return;
        }
        StoredFile storedFile = new StoredFile(this.mProject, developmentObject, path);
        if (storedFile.init()) {
            this.mStoredFiles.put(developmentObject, storedFile);
        }
    }

    void clearStoredFiles() {
        this.mStoredFiles.clear();
    }

    void persistStoredFiles() {
        Iterator iterator = this.mStoredFiles.values().iterator();
        while (iterator.hasNext()) {
            StoredFile storedFile = (StoredFile)iterator.next();
            storedFile.persist();
        }
        this.clearStoredFiles();
    }
}

