/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.plugin;

import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.component.IProjectUpdatedListener;
import com.sap.ide.eclipse.dii.component.InfrastructureManager;
import com.sap.ide.eclipse.dii.component.ProjectConsistencyManager;
import com.sap.ide.generationfwk.eclipse.progressmonitor.StatusLineProgressMonitor;
import com.sap.ide.login.UserValidator;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.MetamodelObserver;
import com.sap.ide.metamodel.MetamodelTicket;
import com.sap.ide.metamodel.core.actions.SaveActionManager;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.editor.MetamodelEditorPart;
import com.sap.ide.metamodel.core.generation.GenerationObjectChangedCache;
import com.sap.ide.metamodel.core.generation.IGenerationTransactionManager;
import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.core.plugin.EclipseSourcePathIdentifier;
import com.sap.ide.metamodel.core.plugin.HierarchyDeltaProvider;
import com.sap.ide.metamodel.core.plugin.ICoreModelExtender;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.plugin.MetamodelHelper;
import com.sap.ide.metamodel.core.plugin.StoredFilesManager;
import com.sap.ide.metamodel.core.project.MetamodelProjectUpdatedListener;
import com.sap.ide.metamodel.core.project.ProjectReloadNotificator;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.core.repository.IMMRepositoryObjectProvider;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.core.services.MultilineTextDialog;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.CommitResult;
import com.sap.ide.metamodel.general.MDOAccessProblem;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocation;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.RollbackResult;
import com.sap.ide.metamodel.general.RootMDOEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.TransactionResult;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.general.i18n.LanguageObject;
import com.sap.ide.metamodel.general.refactoring.RefactoredMDO;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dii.component.DCChangeListener;
import com.tssap.dii.component.IDCProject;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import com.tssap.util.projectinfo.ProjectInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.IIgnoreInfo;
import org.eclipse.team.core.Team;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class MetamodelManager
implements MDOLocator,
MetamodelObserver {
    private static Map mInstanceMap = new HashMap();
    private static final String LINE_SEP = "\n";
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String DOT = ".";
    private static final char DOT_CHAR = '.';
    private MetamodelTicket mMetamodelTicket;
    String mProjectName;
    Metamodel mMetamodel;
    private GenerationObjectChangedCache mGenerationObjectChangedCache;
    private static Set mGenerationTransactionManagers = new HashSet();
    private StoredFilesManager mStoredFilesManager;
    private Set mFilesToDelete = new HashSet();
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$plugin$MetamodelManager;

    public static synchronized boolean hasMetamodelManager(String projectName) {
        MetamodelManager metamodelManager = (MetamodelManager)mInstanceMap.get(projectName);
        return metamodelManager != null;
    }

    public static synchronized MetamodelManager getMetamodelManager(String projectName) {
        MetamodelManager metamodelManager = (MetamodelManager)mInstanceMap.get(projectName);
        if (metamodelManager == null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null || !project.exists()) {
                String message = "Fatal Error: project is not exisiting. projectName = " + projectName;
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "getMetamodelManager", message, null, false);
                return null;
            }
            metamodelManager = new MetamodelManager(projectName);
            mInstanceMap.put(projectName, metamodelManager);
            ProjectService.updateMetamodelJarsFromClasspath(project);
            IDCExtendedProject componentProject = ServicesEclipse.getComponentProject(projectName);
            if (componentProject != null) {
                if (InfrastructureManager.isProjectInitialised((IProject)project)) {
                    metamodelManager.performDCInfrastructureDependantInitializations(componentProject, project);
                } else {
                    MetamodelInitializationListener listener = new MetamodelInitializationListener(componentProject, project, metamodelManager);
                    InfrastructureManager.addInitialisationListener((InfrastructureManager.InitialisationListener)listener);
                }
            } else {
                String language = ProjectInfo.getProperty((IProject)project, (String)"com.sap.ide.metamodel.project.masterlanguage");
                metamodelManager.setMetamodelLanguage(language);
            }
        }
        return metamodelManager;
    }

    void performDCInfrastructureDependantInitializations(IDCExtendedProject componentProject, IProject project) {
        MetamodelManager.registerProjectUpdatedListener(componentProject, project);
        this.setMetamodelLanguageForDCProject(componentProject);
        ICoreModelExtender[] extenders = MetamodelCoreEclipsePlugin.getDefault().getExtenders();
        int i = 0;
        while (i < extenders.length) {
            ICoreModelExtender extender = extenders[i];
            try {
                extender.doDCProjectInitialization(componentProject, this.mMetamodel);
            }
            catch (Throwable t) {
                MetamodelCoreEclipsePlugin.internalError(this.getClass(), "performDCInfrastructureDependantInitializations", "Exception occured", t, true);
            }
            ++i;
        }
        MMCDCChangeListener listener = new MMCDCChangeListener(this);
        componentProject.addDCChangeListener((DCChangeListener)listener);
    }

    static synchronized void releaseMetamodelManager(String projectName) {
        MetamodelManager metamodelManager = (MetamodelManager)mInstanceMap.get(projectName);
        if (metamodelManager != null) {
            metamodelManager.cleanUpListeners();
            ICoreModelExtender[] extenders = MetamodelCoreEclipsePlugin.getDefault().getExtenders();
            int i = 0;
            while (i < extenders.length) {
                ICoreModelExtender extender = extenders[i];
                try {
                    extender.preMetamodelShutdown(metamodelManager.mMetamodel);
                }
                catch (Throwable t) {
                    MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager") : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "releaseMetamodelManager", "Exception occured", t, true);
                }
                ++i;
            }
            try {
                metamodelManager.mMetamodel.shutDown();
            }
            catch (MetamodelException e) {
                String message = "shutdown of Metamodel failed. projectName = " + projectName;
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "releaseMetamodelManager", message, e, true);
            }
            mInstanceMap.remove(projectName);
            metamodelManager.mMetamodel = null;
            MetamodelCoreEclipsePlugin.logMessage("Removed  Metamodel for project " + projectName);
        }
    }

    public void cleanUpListeners() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
        if (project != null && MetamodelProjectUpdatedListener.projectHasListener(project)) {
            MetamodelProjectUpdatedListener listener = MetamodelProjectUpdatedListener.getInstance(project);
            IDevelopmentConfiguration developmentConfiguration = listener.getDevelopmentConfiguration();
            if (developmentConfiguration != null) {
                ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)developmentConfiguration).removeProjectUpdateListener((IProjectUpdatedListener)listener);
                MetamodelCoreEclipsePlugin.logMessage("Removed ProjectUpdatedListener for project " + project.getName());
            } else {
                MetamodelCoreEclipsePlugin.internalError(this.getClass(), "cleanUpListeners()", "Could not remove ProjectUpdatedListener for project " + project.getName() + " because Development Configuration could not be retrieved.", null, true);
            }
            MetamodelProjectUpdatedListener.deleteInstanceForProject(project);
        }
    }

    public static Metamodel getMetamodel(String projectName) {
        MetamodelManager metamodelManager = MetamodelManager.getMetamodelManager(projectName);
        if (metamodelManager != null) {
            return metamodelManager.getMetamodel();
        }
        return null;
    }

    public static boolean modifiedMetamodelsExist() {
        Collection values = mInstanceMap.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            MetamodelManager metamodelManager = (MetamodelManager)iterator.next();
            Metamodel metamodel = metamodelManager.getMetamodel();
            if (!metamodel.isModified()) continue;
            return true;
        }
        return false;
    }

    public static Metamodel[] getModifiedMetamodels() {
        ArrayList<Metamodel> result = new ArrayList<Metamodel>();
        Collection values = mInstanceMap.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            MetamodelManager metamodelManager = (MetamodelManager)iterator.next();
            Metamodel metamodel = metamodelManager.getMetamodel();
            if (!metamodel.isModified()) continue;
            result.add(metamodel);
        }
        return result.toArray(new Metamodel[0]);
    }

    public static Metamodel[] getAllMetamodels() {
        ArrayList<Metamodel> result = new ArrayList<Metamodel>();
        Collection values = mInstanceMap.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            MetamodelManager metamodelManager = (MetamodelManager)iterator.next();
            Metamodel metamodel = metamodelManager.getMetamodel();
            result.add(metamodel);
        }
        return result.toArray(new Metamodel[0]);
    }

    private MetamodelManager(String projectName) {
        this.mProjectName = projectName;
        try {
            this.mMetamodel = new Metamodel(this.mProjectName, (MDOLocator)this);
        }
        catch (MetamodelException e) {
            String message = "creating Metamodel failed. projectName = " + projectName;
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "MetamodelManager", message, e, false);
        }
        this.mMetamodelTicket = this.mMetamodel.enableSecureMode();
        this.mMetamodel.enableMetamodelEventing();
        this.mMetamodel.enableKeyCaching();
        this.mMetamodel.attachMetamodelObserver((MetamodelObserver)this);
        this.mMetamodel.disableFileDeletion();
        this.mGenerationObjectChangedCache = new GenerationObjectChangedCache(this.mProjectName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
        this.mStoredFilesManager = new StoredFilesManager(project);
    }

    public StoredFilesManager getStoredFilesManager() {
        return this.mStoredFilesManager;
    }

    private void setMetamodelLanguageForDCProject(IDCExtendedProject componentProject) {
        String language = null;
        if (componentProject != null) {
            language = componentProject.getLanguage();
            MetamodelCoreEclipsePlugin.logMessage("Setting language for " + this.mMetamodel.getName() + " to " + language);
        } else {
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "setMetamodelLanguageForDCProject", "componentProject == null", null, true);
        }
        this.setMetamodelLanguage(language);
    }

    private void setMetamodelLanguage(String language) {
        if (language == null || language.length() == 0) {
            language = "en";
        }
        try {
            this.mMetamodel.setLanguage(language);
        }
        catch (MetamodelException e) {
            String message = "setLanguage failed";
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "setMetamodelLanguage", message, e, false);
        }
    }

    public GenerationObjectChangedCache getGenerationObjectChangedCache() {
        return this.mGenerationObjectChangedCache;
    }

    private void setUser() {
        UserValidator.Data data = UserValidator.getDefaultServerData();
        String user = data != null ? data.getUser() : System.getProperty("user.name");
        this.mMetamodel.setUserId(user);
    }

    public boolean saveAllMetaData() {
        if (!this.mMetamodel.isModified()) {
            return true;
        }
        MetamodelCoreEclipsePlugin.logMessage("Saving Metadata for project " + this.mProjectName);
        final boolean[] result = new boolean[]{false};
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                result[0] = MetamodelManager.this.saveAllMetaDataInternal();
            }
        });
        return result[0];
    }

    private boolean saveAllMetaDataInternal() {
        boolean succeeded = true;
        try {
            IMetamodelSaveParticipant[] saveParticipants = MetamodelHelper.getAllActiveMetamodelEditors(this.mMetamodel);
            int i = 0;
            while (i < saveParticipants.length) {
                try {
                    saveParticipants[i].preSave();
                }
                catch (Throwable t) {
                    String message = "presave failed. projectName = " + this.mProjectName;
                    MetamodelCoreEclipsePlugin.internalError(this.getClass(), "saveAllMetaData", message, t, false);
                }
                ++i;
            }
            this.setUser();
            CommitResult commitResult = null;
            try {
                commitResult = this.mMetamodel.commitChanges(this.mMetamodelTicket);
            }
            catch (SaveException e) {
                succeeded = false;
                String message = "saving Metamodel failed. projectName = " + this.mProjectName;
                MetamodelCoreEclipsePlugin.internalError(this.getClass(), "saveAllMetaData", message, e, false);
            }
            catch (DeleteException e) {
                succeeded = false;
                String message = "saving Metamodel failed. projectName = " + this.mProjectName;
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "saveAllMetaData", message, e, false);
            }
            final CommitResult lCommitResult = commitResult;
            this.storeFilesToDelete(lCommitResult);
            IProgressMonitor progressMonitor = StatusLineProgressMonitor.getStatusLineProgressMonitor((boolean)true);
            try {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        int worked = 10;
                        monitor.subTask("refreshing files");
                        MetamodelManager.refresh(MetamodelManager.this.mProjectName, lCommitResult);
                        monitor.worked(worked);
                        monitor.subTask("adding new files to DTR");
                        MetamodelManager.this.processNewFiles(lCommitResult, monitor);
                        monitor.worked(worked);
                        monitor.subTask("deleting files");
                        MetamodelManager.this.processDeletedFiles(lCommitResult, monitor);
                        monitor.worked(worked);
                        monitor.subTask("updating...");
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, progressMonitor);
                }
                catch (OperationCanceledException e) {
                    progressMonitor.setCanceled(false);
                }
                catch (CoreException e) {
                    MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "saveAllMetaData", "CommitResultRefresher failed", e, false);
                }
                Object var11_18 = null;
                this.mFilesToDelete.clear();
            }
            catch (Throwable throwable) {
                Object var11_19 = null;
                this.mFilesToDelete.clear();
                progressMonitor.done();
                throw throwable;
            }
            progressMonitor.done();
            Iterator lIterator = mGenerationTransactionManagers.iterator();
            while (lIterator.hasNext()) {
                ((IGenerationTransactionManager)lIterator.next()).commitNotification(this.mProjectName, lCommitResult);
            }
            int i2 = 0;
            while (i2 < saveParticipants.length) {
                try {
                    saveParticipants[i2].postSave();
                }
                catch (Throwable t) {
                    String message = "postSave failed. projectName = " + this.mProjectName;
                    MetamodelCoreEclipsePlugin.internalError(this.getClass(), "saveAllMetaData", message, t, false);
                }
                ++i2;
            }
            if (!lCommitResult.hasSucceeded()) {
                succeeded = false;
                this.showMDOAccessProblems((TransactionResult)lCommitResult);
            }
            this.mStoredFilesManager.clearStoredFiles();
        }
        catch (Throwable t) {
            String message = "saving Metamodel failed. projectName = " + this.mProjectName;
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "saveAllMetaData", message, t, false);
        }
        return succeeded;
    }

    private void storeFilesToDelete(CommitResult commitResult) {
        this.mFilesToDelete.clear();
        String[] files = commitResult.getAllDeletedFiles();
        int i = 0;
        while (i < files.length) {
            Path path = new Path(files[i]);
            this.mFilesToDelete.add(path);
            ++i;
        }
    }

    private boolean isDeletionPending(String pathString) {
        Path path = new Path(pathString);
        return this.mFilesToDelete.contains(path);
    }

    private static boolean mdoPathChanged(RefactoredMDO refactoredMDO) {
        MainDevelopmentObject lMDO = (MainDevelopmentObject)refactoredMDO.getObject();
        return !refactoredMDO.getOriginalAbsolutePath().equals(lMDO.getAbsolutePath());
    }

    private static void addRefacturedMDOs(CommitResult commitResult, List mdoList) {
        RefactoredMDO[] refactoredMDOs = commitResult.getRefactoredMDOs();
        int i = 0;
        while (i < refactoredMDOs.length) {
            RefactoredMDO refactoredMDO = refactoredMDOs[i];
            if (MetamodelManager.mdoPathChanged(refactoredMDO)) {
                mdoList.add((MainDevelopmentObject)refactoredMDO.getObject());
            }
            ++i;
        }
    }

    public void processDeletedFiles(CommitResult commitResult, IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        ArrayList<IFile> filesToDelete = new ArrayList<IFile>();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
        String[] deletedFiles = commitResult.getAllDeletedFiles();
        int i = 0;
        while (i < deletedFiles.length) {
            String absolutePath = deletedFiles[i];
            IFile file = this.getFile(absolutePath);
            filesToDelete.add(file);
            ++i;
        }
        if (filesToDelete.size() > 0) {
            DtrHelper.deleteFiles(project, filesToDelete, progressMonitor);
        }
    }

    private void doDDICHack() {
        String EXT_TABLE = "*.dtdbtable";
        String EXT_LANGUAGE = "*.dtdbtable_*.xlf";
        String EXT_LANGUAGE2 = "*.dtdbtable.xlf";
        String EXT_INDEX = "*.dtdbindex";
        boolean addTableExt = true;
        boolean addLanguageExt = true;
        boolean addLanguageExt2 = true;
        boolean addIndexExt = true;
        boolean isChanged = false;
        IIgnoreInfo[] ignoreInfo = Team.getAllIgnores();
        String[] patterns = new String[ignoreInfo.length + 4];
        boolean[] enabled = new boolean[ignoreInfo.length + 4];
        int i = 0;
        while (i < ignoreInfo.length) {
            patterns[i] = ignoreInfo[i].getPattern();
            enabled[i] = ignoreInfo[i].getEnabled();
            if (patterns[i].equalsIgnoreCase("*.dtdbtable")) {
                addTableExt = false;
                if (!enabled[i]) {
                    enabled[i] = true;
                    isChanged = true;
                }
            } else if (patterns[i].equalsIgnoreCase("*.dtdbtable_*.xlf")) {
                addLanguageExt = false;
                if (!enabled[i]) {
                    enabled[i] = true;
                    isChanged = true;
                }
            } else if (patterns[i].equalsIgnoreCase("*.dtdbtable.xlf")) {
                addLanguageExt2 = false;
                if (!enabled[i]) {
                    enabled[i] = true;
                    isChanged = true;
                }
            } else if (patterns[i].equalsIgnoreCase("*.dtdbindex")) {
                addIndexExt = false;
                if (!enabled[i]) {
                    enabled[i] = true;
                    isChanged = true;
                }
            }
            ++i;
        }
        int i2 = ignoreInfo.length - 1;
        if (addTableExt) {
            patterns[++i2] = "*.dtdbtable";
            enabled[i2] = true;
        }
        if (addLanguageExt) {
            patterns[++i2] = "*.dtdbtable_*.xlf";
            enabled[i2] = true;
        }
        if (addLanguageExt2) {
            patterns[++i2] = "*.dtdbtable.xlf";
            enabled[i2] = true;
        }
        if (addIndexExt) {
            patterns[++i2] = "*.dtdbindex";
            enabled[i2] = true;
        }
        if (!(isChanged || addTableExt || addLanguageExt || addLanguageExt2 || addIndexExt)) {
            return;
        }
        String[] hPatterns = new String[i2 + 1];
        boolean[] hEnabled = new boolean[i2 + 1];
        int j = 0;
        while (j < hEnabled.length) {
            hPatterns[j] = patterns[j];
            hEnabled[j] = enabled[j];
            ++j;
        }
        try {
            Team.setAllIgnores((String[])hPatterns, (boolean[])hEnabled);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void doDDICHack2(CommitResult commitResult) {
        String string2;
        String string1;
        MainDevelopmentObject[] createdMDOs = commitResult.getCreatedMDOs();
        LanguageObject[] languageObjects = commitResult.getCreatedLanguageObjects();
        int i = 0;
        while (i < createdMDOs.length) {
            if (MetamodelManager.isDBTableObject(createdMDOs[i])) {
                this.setDerived(createdMDOs[i].getAbsolutePath());
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < languageObjects.length) {
            LanguageObject languageObject = languageObjects[i2];
            if (MetamodelManager.isDBTableObject(languageObject.getMDO())) {
                this.setDerived(languageObject.getAbsolutePath());
            }
            ++i2;
        }
        String EXT_TABLE = "*.dtdbtable";
        String EXT_TABLE_BLANK = " *.dtdbtable";
        String EXT_TABLE_FALSE = "*.dtdbtable\n" + FALSE;
        String EXT_LANGUAGE = "*.dtdbtable_*.xlf";
        String EXT_LANGUAGE_BLANK = " *.dtdbtable_*.xlf";
        String EXT_LANGUAGE_FALSE = "*.dtdbtable_*.xlf\n" + FALSE;
        String EXT_INDEX = "*.dtdbindex";
        String EXT_INDEX_FALSE = "*.dtdbindex\n" + FALSE;
        String IGNORE_FILES = "ignore_files";
        Plugin plugin = Platform.getPlugin((String)"org.eclipse.team.core");
        Preferences pref = plugin.getPluginPreferences();
        String sPref = plugin.getPluginPreferences().getString("ignore_files");
        if (sPref == null) {
            sPref = EMPTY_STRING;
        }
        boolean addExtension = false;
        int indexFalse = -1;
        int indexBlank = -1;
        int index = sPref.indexOf("*.dtdbtable");
        if (index == -1) {
            addExtension = true;
        } else {
            indexBlank = sPref.indexOf(" *.dtdbtable");
            if (indexBlank >= 0 && indexBlank <= index && (index = sPref.indexOf("*.dtdbtable", indexBlank + 2)) == -1) {
                addExtension = true;
            }
            if (!addExtension) {
                indexFalse = sPref.indexOf(EXT_TABLE_FALSE, index);
            }
        }
        if (addExtension) {
            sPref = sPref.endsWith(LINE_SEP) || sPref.length() == 0 ? sPref + "*.dtdbtable" + LINE_SEP + TRUE + LINE_SEP : LINE_SEP + sPref + "*.dtdbtable" + LINE_SEP + TRUE + LINE_SEP;
            pref.setValue("ignore_files", sPref);
        } else if (indexFalse >= 0) {
            string1 = sPref.substring(0, indexFalse + 11) + LINE_SEP + TRUE;
            string2 = sPref.substring(indexFalse + 18);
            if (!string2.startsWith(LINE_SEP)) {
                string2 = LINE_SEP + string2;
            }
            if (!string2.endsWith(LINE_SEP)) {
                string2 = string2 + LINE_SEP;
            }
            sPref = string1 + string2;
            pref.setValue("ignore_files", sPref);
        }
        addExtension = false;
        indexFalse = -1;
        indexBlank = -1;
        index = sPref.indexOf("*.dtdbtable_*.xlf");
        if (index == -1) {
            addExtension = true;
        } else {
            indexBlank = sPref.indexOf(" *.dtdbtable_*.xlf");
            if (indexBlank >= 0 && indexBlank <= index && (index = sPref.indexOf("*.dtdbtable_*.xlf", indexBlank + 2)) == -1) {
                addExtension = true;
            }
            if (!addExtension) {
                indexFalse = sPref.indexOf(EXT_LANGUAGE_FALSE, index);
            }
        }
        if (addExtension) {
            sPref = sPref.endsWith(LINE_SEP) || sPref.length() == 0 ? sPref + "*.dtdbtable_*.xlf" + LINE_SEP + TRUE + LINE_SEP : LINE_SEP + sPref + "*.dtdbtable_*.xlf" + LINE_SEP + TRUE + LINE_SEP;
            pref.setValue("ignore_files", sPref);
        } else if (indexFalse >= 0) {
            string1 = sPref.substring(0, indexFalse + 17) + LINE_SEP + TRUE;
            string2 = sPref.substring(indexFalse + 24);
            if (!string2.startsWith(LINE_SEP)) {
                string2 = LINE_SEP + string2;
            }
            if (!string2.endsWith(LINE_SEP)) {
                string2 = string2 + LINE_SEP;
            }
            sPref = string1 + string2;
            pref.setValue("ignore_files", sPref);
        }
        addExtension = false;
        indexFalse = -1;
        index = sPref.indexOf("*.dtdbindex");
        if (index == -1) {
            addExtension = true;
        } else {
            indexFalse = sPref.indexOf(EXT_INDEX_FALSE, index);
        }
        if (addExtension) {
            sPref = sPref.endsWith(LINE_SEP) || sPref.length() == 0 ? sPref + "*.dtdbindex" + LINE_SEP + TRUE + LINE_SEP : LINE_SEP + sPref + "*.dtdbindex" + LINE_SEP + TRUE + LINE_SEP;
            pref.setValue("ignore_files", sPref);
        } else if (indexFalse >= 0) {
            string1 = sPref.substring(0, indexFalse + 11) + LINE_SEP + TRUE;
            string2 = sPref.substring(indexFalse + 18);
            if (!string2.startsWith(LINE_SEP)) {
                string2 = LINE_SEP + string2;
            }
            if (!string2.endsWith(LINE_SEP)) {
                string2 = string2 + LINE_SEP;
            }
            sPref = string1 + string2;
            pref.setValue("ignore_files", sPref);
        }
        plugin.savePluginPreferences();
    }

    public void processNewFiles(CommitResult commitResult, IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        this.doDDICHack();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
        if (!DtrHelper.isProjectUnderSourceControl(project)) {
            return;
        }
        ArrayList<MainDevelopmentObject> createdMDOs = new ArrayList<MainDevelopmentObject>();
        createdMDOs.addAll(Arrays.asList(commitResult.getCreatedMDOs()));
        MetamodelManager.addRefacturedMDOs(commitResult, createdMDOs);
        LanguageObject[] languageObjects = commitResult.getCreatedLanguageObjects();
        if (createdMDOs.size() + languageObjects.length <= 0) {
            return;
        }
        if (!DtrHelper.isUserLoggedOn(project)) {
            return;
        }
        MMRepositoryObjectList repositoryObjects = new MMRepositoryObjectList();
        IMMRepositoryObjectProvider[] providers = this.getRepositoryObjectProvider();
        int i = 0;
        while (i < createdMDOs.size()) {
            MMRepositoryObject repositoryObject = MetamodelManager.getRepositoryObject((MainDevelopmentObject)createdMDOs.get(i), providers);
            if (repositoryObject != null) {
                repositoryObjects.addRepositoryObject(repositoryObject);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < languageObjects.length) {
            LanguageObject languageObject = languageObjects[i2];
            MMRepositoryObject repositoryObject = MetamodelManager.getRepositoryObject(languageObject.getMDO(), providers);
            if (repositoryObject != null) {
                repositoryObjects.addRepositoryObject(repositoryObject);
            }
            ++i2;
        }
        if (repositoryObjects.getSize() > 0) {
            RepositoryServices.addToSourceControl(project, repositoryObjects);
        }
    }

    private static boolean isDBTableObject(MainDevelopmentObject mdo) {
        if (mdo == null || mdo.getMetaClass() == null) {
            return false;
        }
        String metaClass = mdo.getMetaClass().getName();
        return metaClass.equals("com.sap.ide.metamodel.dictionary.datatype.DtDbTable") || metaClass.equals("com.sap.ide.metamodel.dictionary.datatype.DtDbIndex");
    }

    private void setDerived(String path) {
        IFile file = this.getFile(path);
        try {
            file.setDerived(true);
        }
        catch (CoreException e) {
            String message = "setDerived failed for " + path;
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "setDerived", message, e, false);
        }
    }

    public static MMRepositoryObject getRepositoryObject(MainDevelopmentObject mdo, IMMRepositoryObjectProvider[] providers) {
        int i = 0;
        while (i < providers.length) {
            IMMRepositoryObjectProvider provider = providers[i];
            MMRepositoryObject repositoryObject = provider.getRepositoryObject(mdo, true);
            if (repositoryObject != null) {
                return repositoryObject;
            }
            ++i;
        }
        String className = EMPTY_STRING;
        if (mdo.getMetaClass() != null) {
            className = mdo.getMetaClass().getName();
        }
        String message = "RepositoryObjectProvider missing for " + className + SPACE + mdo.getQualifiedName();
        MetamodelCoreEclipsePlugin.internalWarning(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "getRepositoryObject", message, null);
        return null;
    }

    private void showMDOAccessProblems(TransactionResult transactionResult) {
        String dialogText = EMPTY_STRING;
        MDOAccessProblem[] mdoAccessProblem = transactionResult.getObstacles();
        int i = 0;
        while (i < mdoAccessProblem.length) {
            String reason;
            MDOAccessProblem accessProblem = mdoAccessProblem[i];
            String path = accessProblem.getAbsolutePath();
            switch (accessProblem.getReason()) {
                case 1: {
                    reason = "cannot load";
                    break;
                }
                case 2: {
                    reason = "cannot save";
                    break;
                }
                case 3: {
                    reason = "cannot delete";
                    break;
                }
                case 5: {
                    reason = "cannot reload";
                    break;
                }
                case 6: {
                    reason = "cannot save language";
                    break;
                }
                case 7: {
                    reason = "cannot delete language";
                    break;
                }
                case 9: {
                    reason = "cannot reload language";
                    break;
                }
                default: {
                    reason = "unknown";
                }
            }
            String message = reason + SPACE + accessProblem.getAbsolutePath();
            dialogText = dialogText.length() > 0 ? dialogText + LINE_SEP + message : message;
            ++i;
        }
        dialogText = dialogText + "\n\nPlease check the files e.g. for writeability / existence.";
        String title = transactionResult instanceof CommitResult ? "Saving Metadata failed" : "Rollback failed";
        MultilineTextDialog multilineTextDialog = new MultilineTextDialog(title, dialogText);
        multilineTextDialog.open();
    }

    public boolean rollbackMetaData() {
        MetamodelCoreEclipsePlugin.logMessage("Rollback Metadata for project " + this.mProjectName);
        boolean succeeded = true;
        try {
            RollbackResult rollbackResult = null;
            try {
                rollbackResult = this.mMetamodel.rollbackChanges(this.mMetamodelTicket);
            }
            catch (LoadException e) {
                succeeded = false;
                String message = "Rollback of Metamodel failed. projectName = " + this.mProjectName;
                MetamodelCoreEclipsePlugin.internalError(this.getClass(), "rollbackMetaData", message, e, false);
            }
            this.mStoredFilesManager.persistStoredFiles();
            UniqueName modelUniqueName = ModelAccess.createModelUniqueName((String)this.mProjectName);
            ViewManager viewManager = ViewAccess.getViewManager((UniqueName)modelUniqueName);
            viewManager.updateAllViews();
            this.refreshTSModel();
            IMetamodelSaveParticipant[] saveParticipants = MetamodelHelper.getAllActiveMetamodelEditors(this.mMetamodel);
            int i = 0;
            while (i < saveParticipants.length) {
                saveParticipants[i].postRollback();
                ++i;
            }
            Iterator lIterator = mGenerationTransactionManagers.iterator();
            while (lIterator.hasNext()) {
                ((IGenerationTransactionManager)lIterator.next()).rollbackNotification(this.mProjectName, rollbackResult);
            }
            if (!rollbackResult.hasSucceeded()) {
                succeeded = false;
                this.showMDOAccessProblems((TransactionResult)rollbackResult);
            }
        }
        catch (Throwable t) {
            String message = "Rollback of Metamodel failed. projectName = " + this.mProjectName;
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "rollbackMetaData", message, t, false);
        }
        return succeeded;
    }

    public void refreshTSModel() {
        HierarchyDeltaProvider hierarchyDeltaProvider = HierarchyDeltaProvider.getHierarchyDeltaProvider(this.mProjectName);
        if (hierarchyDeltaProvider == null) {
            return;
        }
        hierarchyDeltaProvider.totalUpdate();
        final UniqueName modelUniqueName = ModelAccess.createModelUniqueName((String)this.mProjectName);
        Model model = ModelAccess.getModel((UniqueName)modelUniqueName);
        if (model != null) {
            model.getExtensionManager().modelContentsChanged();
        } else {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "refreshTSModel", "could not find Model " + modelUniqueName.toString(), null, false);
        }
        ModelAccess.runCommandLater((Runnable)new Runnable(){

            public void run() {
                ViewManager viewManager = ViewAccess.getViewManager((UniqueName)modelUniqueName);
                viewManager.updateAllViews();
            }
        });
    }

    public static boolean saveAllMetaData(String projectName) {
        MetamodelManager metamodelManager = MetamodelManager.getMetamodelManager(projectName);
        if (metamodelManager == null) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "saveAllMetaData", "could not find MetamodelManager for project " + projectName, null, false);
            return false;
        }
        return metamodelManager.saveAllMetaData();
    }

    public static boolean saveAllMetaData(Metamodel metamodel) {
        if (metamodel == null) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "saveAllMetaData", "metamodel == null", null, false);
            return false;
        }
        MetamodelManager metamodelManager = MetamodelManager.getMetamodelManager(metamodel.getName());
        if (metamodelManager == null) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "saveAllMetaData", "could not find MetamodelManager for project " + metamodel.getName(), null, false);
            return false;
        }
        return metamodelManager.saveAllMetaData();
    }

    public static boolean rollbackMetaData(Metamodel metamodel) {
        if (metamodel == null) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "rollbackMetaData", "metamodel == null", null, false);
            return false;
        }
        MetamodelManager metamodelManager = MetamodelManager.getMetamodelManager(metamodel.getName());
        if (metamodelManager == null) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "rollbackMetaData", "could not find MetamodelManager for project " + metamodel.getName(), null, false);
            return false;
        }
        return metamodelManager.rollbackMetaData();
    }

    private static void addFile(String pathString, HashSet folders, ArrayList foldersToRefresh) {
        Path path = new Path(pathString);
        if (path == null) {
            return;
        }
        if (!folders.contains((path = path.removeLastSegments(1).removeTrailingSeparator()).toString())) {
            folders.add(path.toString());
            foldersToRefresh.add(path);
        }
    }

    public static void refresh(String projectName, CommitResult commitResult) {
        ArrayList foldersToRefresh = new ArrayList();
        HashSet folders = new HashSet();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        MainDevelopmentObject[] mdos = commitResult.getCreatedMDOs();
        int i = 0;
        while (i < mdos.length) {
            MetamodelManager.addFile(mdos[i].getAbsolutePath(), folders, foldersToRefresh);
            ++i;
        }
        mdos = commitResult.getDeletedMDOs();
        int i2 = 0;
        while (i2 < mdos.length) {
            MetamodelManager.addFile(mdos[i2].getAbsolutePath(), folders, foldersToRefresh);
            ++i2;
        }
        mdos = commitResult.getModifiedMDOs();
        int i3 = 0;
        while (i3 < mdos.length) {
            Path path = new Path(mdos[i3].getAbsolutePath());
            MetamodelManager.refreshFile(project, (IPath)path);
            ++i3;
        }
        LanguageObject[] languageObjects = commitResult.getCreatedLanguageObjects();
        int i4 = 0;
        while (i4 < languageObjects.length) {
            MetamodelManager.addFile(languageObjects[i4].getAbsolutePath(), folders, foldersToRefresh);
            ++i4;
        }
        languageObjects = commitResult.getDeletedLanguageObjects();
        int i5 = 0;
        while (i5 < languageObjects.length) {
            MetamodelManager.addFile(languageObjects[i5].getAbsolutePath(), folders, foldersToRefresh);
            ++i5;
        }
        languageObjects = commitResult.getModifiedLanguageObjects();
        int i6 = 0;
        while (i6 < languageObjects.length) {
            Path path = new Path(languageObjects[i6].getAbsolutePath());
            MetamodelManager.refreshFile(project, (IPath)path);
            ++i6;
        }
        int i7 = 0;
        while (i7 < foldersToRefresh.size()) {
            MetamodelManager.refresh(project, (IPath)foldersToRefresh.get(i7), false, null);
            ++i7;
        }
    }

    public static void refresh(IProject project, IPath path, boolean refreshSubtree, IProgressMonitor progressMonitor) {
        IPath location;
        int nrOfMatchingSegments;
        IPath lPath;
        IFolder folder;
        if (project == null || path == null) {
            return;
        }
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        if ((folder = project.getFolder(lPath = (nrOfMatchingSegments = (path = path.removeTrailingSeparator()).matchingFirstSegments(location = project.getLocation())) > 0 ? path.removeFirstSegments(nrOfMatchingSegments) : path)) == null) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "refresh", "folder was not found in project: " + path.toString(), null, false);
            return;
        }
        IFolder resource = folder;
        int depth = refreshSubtree ? 2 : 1;
        try {
            long time1 = System.currentTimeMillis();
            resource.refreshLocal(depth, progressMonitor);
            long time2 = System.currentTimeMillis();
            MetamodelCoreEclipsePlugin.logMessage("refreshing<" + (time2 - time1) + "ms>: " + resource.getFullPath().toString() + " for " + path.toString());
        }
        catch (CoreException e) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "refresh", "refreshLocal failed for " + path.toString(), e, false);
            return;
        }
    }

    public static void refreshFile(IProject project, IPath path) {
        if (project == null || path == null) {
            return;
        }
        IPath location = project.getLocation();
        int nrOfMatchingSegments = path.matchingFirstSegments(location);
        IPath lPath = nrOfMatchingSegments > 0 ? path.removeFirstSegments(nrOfMatchingSegments) : path;
        IFile file = project.getFile(lPath);
        if (file == null) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "refresh", "file was not found in project: " + path.toString(), null, false);
            return;
        }
        try {
            long time1 = System.currentTimeMillis();
            file.refreshLocal(0, null);
            long time2 = System.currentTimeMillis();
            MetamodelCoreEclipsePlugin.logMessage("refreshing<" + (time2 - time1) + "ms>: " + file.getFullPath().toString());
        }
        catch (CoreException e) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "refresh", "refreshLocal failed for " + path.toString(), e, false);
            return;
        }
    }

    public Metamodel getMetamodel() {
        return this.mMetamodel;
    }

    public MDOLocation[] getRootMDOLocations(RootMDOEnum rootMDOType) {
        return this.getFileLocations(rootMDOType.getFileExtension());
    }

    public MDOLocation[] getFileLocations(String fileExtension) {
        ArrayList result = new ArrayList();
        ArrayList packageRootPaths = new ArrayList();
        packageRootPaths.addAll(this.getProjectSourcePaths());
        int i = 0;
        while (i < packageRootPaths.size()) {
            String fileName = (String)packageRootPaths.get(i);
            File folder = new File(fileName);
            if (folder.exists() && folder.isDirectory()) {
                this.getFileLocations(folder, EMPTY_STRING, DOT + fileExtension, result);
            }
            ++i;
        }
        MDOLocation[] helperArray = new MDOLocation[]{};
        MDOLocation[] results = result.toArray(helperArray);
        return results;
    }

    void getFileLocations(File folder, String currentPackage, String fileExtension, ArrayList result) {
        File[] children = folder.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (children[i].isFile() && children[i].getName().endsWith(fileExtension)) {
                    String absolutePath = children[i].getAbsolutePath();
                    MDOLocation location = new MDOLocation(absolutePath, currentPackage);
                    result.add(location);
                } else if (children[i].isDirectory()) {
                    String nextPackage = currentPackage == null || currentPackage.length() <= 0 ? children[i].getName() : currentPackage + '.' + children[i].getName();
                    this.getFileLocations(children[i], nextPackage, fileExtension, result);
                }
                ++i;
            }
        }
    }

    public String getSourcePath() {
        ArrayList sourcePaths = this.getProjectSourcePaths();
        if (sourcePaths.isEmpty()) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
        int i = 0;
        while (i < sourcePaths.size()) {
            String sourcePathString = (String)sourcePaths.get(i);
            Path sourcePath = new Path(sourcePathString);
            if (!ServicesEclipse.isGenerationSourcePath(project, (IPath)sourcePath)) {
                return sourcePathString;
            }
            ++i;
        }
        return null;
    }

    public String getSourcePath(SourcePathIdentifier identifier) {
        if (!(identifier instanceof EclipseSourcePathIdentifier)) {
            return null;
        }
        EclipseSourcePathIdentifier eclipseSourcePathIdentifier = (EclipseSourcePathIdentifier)identifier;
        if (eclipseSourcePathIdentifier.getOwner() == this) {
            return eclipseSourcePathIdentifier.getSourcePath().toOSString();
        }
        return null;
    }

    public String getMDOPath(String mdoPackage, String mdoName, MDOEnum mdoType) {
        return this.getMDOPath(mdoPackage, mdoName, mdoType.getFileExtension());
    }

    public String getMDOPath(String mdoPackage, String mdoName, String fileExtension) {
        String fileName = mdoName + DOT + fileExtension;
        IStatus status = ResourcesPlugin.getWorkspace().validateName(fileName, 1);
        if (status.getCode() != 0) {
            return null;
        }
        String relativeMDOPath = MetamodelManager.getRelativePath(mdoPackage, mdoName, fileExtension);
        ArrayList packageRootPaths = new ArrayList();
        ArrayList sourcePaths = this.getProjectSourcePaths();
        packageRootPaths.addAll(sourcePaths);
        int i = 0;
        while (i < packageRootPaths.size()) {
            String path = packageRootPaths.get(i) + relativeMDOPath;
            if (!this.isDeletionPending(path) && this.fileExists(path)) {
                return path;
            }
            ++i;
        }
        return null;
    }

    public String[] getRootMDOPaths(String mdoPackage, RootMDOEnum rootMDOType) {
        ArrayList sourcePaths = this.getProjectSourcePaths();
        return this.getPathsOfFilesInPackage(sourcePaths, mdoPackage, rootMDOType.getFileExtension());
    }

    public String[] getPackages(RootMDOEnum rootMDOType) {
        return this.getAllPackagesContainingFilesOfType(this.mProjectName, rootMDOType.getFileExtension());
    }

    private static String getRelativePath(String packageName, String fileName, String fileExtension) {
        String lPath = new String();
        if (packageName != null && packageName.length() > 0) {
            lPath = File.separator + packageName.replace('.', File.separatorChar);
        }
        lPath = lPath + File.separator + fileName + DOT + fileExtension;
        return lPath;
    }

    private static String getRelativePath(String packageName) {
        String lPath = new String();
        if (packageName != null && packageName.length() > 0) {
            lPath = File.separator + packageName.replace('.', File.separatorChar);
        }
        return lPath;
    }

    public ArrayList getProjectSourcePaths() {
        ArrayList<String> list = new ArrayList<String>();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
        IClasspathEntry[] classpaths = MetamodelManager.getJavaProjectClassPaths(project);
        int i = 0;
        while (i < classpaths.length) {
            if (classpaths[i].getEntryKind() == 3) {
                String path = project.getLocation().append(classpaths[i].getPath().removeFirstSegments(1)).toOSString();
                if (path.endsWith("/") || path.endsWith("\\")) {
                    path = path.length() >= 1 ? path.substring(0, path.length() - 1) : EMPTY_STRING;
                }
                list.add(path);
            }
            ++i;
        }
        return list;
    }

    public IMMRepositoryObjectProvider[] getRepositoryObjectProvider() {
        ArrayList<IMMRepositoryObjectProvider> list = new ArrayList<IMMRepositoryObjectProvider>();
        ICoreModelExtender[] extenders = MetamodelCoreEclipsePlugin.getDefault().getExtenders();
        int i = 0;
        while (i < extenders.length) {
            ICoreModelExtender extender = extenders[i];
            try {
                IMMRepositoryObjectProvider repositoryObjectProvider = extender.getRepositoryObjectProvider();
                if (repositoryObjectProvider != null) {
                    list.add(repositoryObjectProvider);
                }
            }
            catch (Throwable t) {
                MetamodelCoreEclipsePlugin.internalError(this.getClass(), "getRepositoryObjectProvider", "Exception occured", t, true);
            }
            ++i;
        }
        return list.toArray(new IMMRepositoryObjectProvider[0]);
    }

    public static IClasspathEntry[] getJavaProjectClassPaths(IProject project) {
        if (project == null) {
            return new IClasspathEntry[0];
        }
        IProjectNature nature = null;
        IJavaProject javaProject = null;
        try {
            nature = project.getNature("org.eclipse.jdt.core.javanature");
            if (nature instanceof IJavaProject) {
                javaProject = (IJavaProject)nature;
            }
        }
        catch (CoreException e) {
            String message = "project has no Java Nature. projectName =  " + project.getName();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "getJavaProjectClassPaths", message, e, false);
            return new IClasspathEntry[0];
        }
        if (javaProject == null) {
            String message = "project has no Java Nature. projectName =  " + project.getName();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "getJavaProjectClassPaths", message, null, false);
            return new IClasspathEntry[0];
        }
        IClasspathEntry[] classpaths = null;
        try {
            classpaths = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException e) {
            String message = "getResolvedClasspath failed. projectName =  " + project.getName();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "getJavaProjectClassPaths", message, e, false);
            return new IClasspathEntry[0];
        }
        return classpaths;
    }

    boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    boolean folderContainsFileWithExtension(String folderPath, String fileExtension) {
        final String lExtension = DOT + fileExtension;
        File[] lFiles = new File(folderPath).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(lExtension);
            }
        });
        return lFiles.length > 0;
    }

    public boolean isPackageEmpty(String packageName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
        ArrayList sourcePaths = this.getProjectSourcePaths();
        String relativePackagePath = MetamodelManager.getRelativePath(packageName);
        int i = 0;
        while (i < sourcePaths.size()) {
            String folderPath;
            String sourcePath = (String)sourcePaths.get(i);
            Path path = new Path(sourcePath);
            if (!ServicesEclipse.isGenerationSourcePath(project, (IPath)path) && this.fileExists(folderPath = sourcePath + relativePackagePath)) {
                return this.isEmptyFolderHierarchy(new File(folderPath));
            }
            ++i;
        }
        return true;
    }

    private boolean isEmptyFolderHierarchy(File folder) {
        File[] lFiles;
        if (folder != null && (lFiles = folder.listFiles()) != null) {
            int j = 0;
            while (j < lFiles.length) {
                if (lFiles[j] != null && (lFiles[j].isFile() || !this.isEmptyFolderHierarchy(lFiles[j]))) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    public String[] getPathsOfFilesInPackage(ArrayList sourcePaths, String packageName, String fileExtension) {
        ArrayList<String> paths = new ArrayList<String>();
        String relativePackagePath = MetamodelManager.getRelativePath(packageName);
        int i = 0;
        while (i < sourcePaths.size()) {
            String folderPath = sourcePaths.get(i) + relativePackagePath;
            if (this.fileExists(folderPath)) {
                final String lExtension = DOT + fileExtension;
                File[] lFiles = new File(folderPath).listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(lExtension);
                    }
                });
                int j = 0;
                while (j < lFiles.length) {
                    paths.add(lFiles[j].getAbsolutePath());
                    ++j;
                }
            }
            ++i;
        }
        String[] helperArray = new String[]{};
        String[] results = paths.toArray(helperArray);
        return results;
    }

    public String[] getAllPackagesContainingFilesOfType(String projectName, String fileExtension) {
        HashSet result = new HashSet();
        ArrayList packageRootPaths = new ArrayList();
        packageRootPaths.addAll(this.getProjectSourcePaths());
        int i = 0;
        while (i < packageRootPaths.size()) {
            String message;
            String fileName = (String)packageRootPaths.get(i);
            File folder = new File(fileName);
            if (!folder.exists()) {
                message = "classPath is not existing. projectName = " + this.mProjectName + " classPath = " + fileName;
                MetamodelCoreEclipsePlugin.internalWarning(this.getClass(), "getAllPackagesContainingFilesOfType", message, null);
            } else if (!folder.isDirectory()) {
                message = "classPath is no directory. projectName = " + this.mProjectName + " classPath = " + fileName;
                MetamodelCoreEclipsePlugin.internalWarning(this.getClass(), "getAllPackagesContainingFilesOfType", message, null);
            } else {
                this.getAllPackagesContainingFilesOfType(folder, EMPTY_STRING, DOT + fileExtension, result);
            }
            ++i;
        }
        String[] helperArray = new String[]{};
        String[] results = ((AbstractCollection)result).toArray(helperArray);
        return results;
    }

    void getAllPackagesContainingFilesOfType(File folder, String currentPackage, String fileExtension, HashSet result) {
        File[] children = folder.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (children[i].isFile() && children[i].getName().endsWith(fileExtension)) {
                    result.add(currentPackage);
                } else if (children[i].isDirectory()) {
                    String nextPackage = currentPackage == null || currentPackage.length() <= 0 ? children[i].getName() : currentPackage + '.' + children[i].getName();
                    this.getAllPackagesContainingFilesOfType(children[i], nextPackage, fileExtension, result);
                }
                ++i;
            }
        }
    }

    public IPath makePathAbsolute(IPath path) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mMetamodel.getName());
        IPath workspacePath = project.getLocation();
        return workspacePath.append(path.removeFirstSegments(1));
    }

    public SourcePathIdentifier getSourcePathIdentifier(IPath sourcePath) {
        ArrayList sourcePaths = this.getProjectSourcePaths();
        boolean sourcePathIsValid = false;
        int i = 0;
        while (i < sourcePaths.size()) {
            Path lSourcePath = new Path((String)sourcePaths.get(i));
            if (lSourcePath.equals((Object)sourcePath)) {
                sourcePathIsValid = true;
                break;
            }
            ++i;
        }
        if (sourcePathIsValid) {
            return new EclipseSourcePathIdentifier(this, sourcePath);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPackageFragmentRoot findPackageFragmentRoot(SourcePathIdentifier identifier) {
        if (identifier instanceof EclipseSourcePathIdentifier) {
            EclipseSourcePathIdentifier eclipseIdentifier = (EclipseSourcePathIdentifier)identifier;
            IPath sourcePath = eclipseIdentifier.getSourcePath();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
            IJavaProject javaProject = this.getJavaProject(project);
            if (javaProject == null) return null;
            IPath path = sourcePath;
            if (path.toString().startsWith(project.getLocation().toString())) {
                try {
                    IPackageFragmentRoot[] roots = javaProject.getAllPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        IPackageFragmentRoot root = roots[i];
                        if (path.toString().endsWith(root.getPath().toString())) {
                            return root;
                        }
                        ++i;
                    }
                    return null;
                }
                catch (JavaModelException e) {
                    MetamodelCoreEclipsePlugin.internalError(this.getClass(), "findPackageFragmentRoot(SourcePathIdentifier)", "no PackageFragmentRoots found", e, false);
                }
                return null;
            }
            try {
                return javaProject.findPackageFragmentRoot(path);
            }
            catch (JavaModelException e) {
                MetamodelCoreEclipsePlugin.internalError(this.getClass(), "findPackageFragmentRoot(SourcePathIdentifier)", "no IPackageFragmentRoot found", e, false);
                return null;
            }
        }
        if (identifier == null) return null;
        MetamodelCoreEclipsePlugin.internalError(this.getClass(), "findPackageFragmentRoot(SourcePathIdentifier)", "Unknown implementation of SourcePathIdentifier. Should be EclipseSourcePathIdentifier: " + identifier, null, false);
        return null;
    }

    public IJavaProject getJavaProject(IProject project) {
        IProjectNature nature = null;
        IJavaProject javaProject = null;
        try {
            nature = project.getNature("org.eclipse.jdt.core.javanature");
            if (nature instanceof IJavaProject) {
                javaProject = (IJavaProject)nature;
            }
        }
        catch (CoreException e) {
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "getJavaProject", "no valid name for an IJavaProject", e, false);
        }
        return javaProject;
    }

    public String getMDOPathForCreation(String mdoPackage, String mdoName, MDOEnum mdoType) {
        return null;
    }

    public void dirtyFlagChanged(boolean isDirty) {
        if (isDirty) {
            SaveActionManager.enableSaveAllButton();
            SaveActionManager.enableRollbackButton();
            MetamodelEditorPart editor = MetamodelEditorPart.getOpenMetamodelEditor(this.mMetamodel);
            if (editor == null) {
                MetamodelEditorPart.openMetamodelEditor(this.mMetamodel);
            }
        } else {
            this.disableSaveAndRollbackButton();
        }
    }

    private void disableSaveAndRollbackButton() {
        Metamodel[] modifiedMetamodels = MetamodelManager.getModifiedMetamodels();
        if (modifiedMetamodels.length == 0) {
            SaveActionManager.disableSaveAllButton();
            SaveActionManager.disableRollbackButton();
        }
    }

    public IFile getFile(String absolutePath) {
        Path path = new Path(absolutePath);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
        IPath location = project.getLocation();
        int nrOfMatchingSegments = path.matchingFirstSegments(location);
        Object lPath = nrOfMatchingSegments > 0 ? path.removeFirstSegments(nrOfMatchingSegments) : path;
        IFile file = project.getFile((IPath)lPath);
        return file;
    }

    public static void registerGenerationTransactionManager(IGenerationTransactionManager manager) {
        mGenerationTransactionManagers.add(manager);
    }

    public static void unRegisterGenerationTransactionManager(IGenerationTransactionManager manager) {
        if (mGenerationTransactionManagers.contains(manager)) {
            mGenerationTransactionManagers.remove(manager);
        }
    }

    private static void registerProjectUpdatedListener(IDCExtendedProject componentProject, IProject project) {
        IDevelopmentConfiguration developmentConfiguration = componentProject.getConfiguration();
        MetamodelProjectUpdatedListener listener = MetamodelProjectUpdatedListener.getInstance(project);
        if (developmentConfiguration != null) {
            ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)developmentConfiguration).addProjectUpdateListener((IProjectUpdatedListener)listener);
            MetamodelCoreEclipsePlugin.logMessage("Added ProjectUpdatedListener for project " + project.getName());
        } else {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "getMetamodelManager(String)", "Could not set project updated listener for project " + project.getName(), new Exception("Could not set project updated listener for project " + project.getName()), true);
        }
    }

    public static void closeMetamodelEditors(Metamodel metamodel) {
        IMetamodelSaveParticipant[] saveParticipants = MetamodelHelper.getAllActiveMetamodelEditors(metamodel);
        int i = 0;
        while (i < saveParticipants.length) {
            IEditorPart editorPart = (IEditorPart)saveParticipants[i];
            IWorkbenchPage workbenchPage = null;
            try {
                workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            }
            catch (NullPointerException e) {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager") : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "closeMetamodelEditors", "Exception occured", e, true);
            }
            if (workbenchPage != null) {
                workbenchPage.closeEditor(editorPart, false);
            }
            ++i;
        }
    }

    public static void closeDevelopmentObjectEditors(Metamodel metamodel) {
        IDevelopmentObjectEditor[] editors = MetamodelHelper.getAllActiveDevelopmentObjectEditors(metamodel);
        int i = 0;
        while (i < editors.length) {
            IEditorPart editorPart = (IEditorPart)editors[i];
            IWorkbenchPage workbenchPage = null;
            try {
                workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            }
            catch (NullPointerException e) {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager") : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "closeDevelopmentObjectEditors", "Exception occured", e, true);
            }
            if (workbenchPage != null) {
                workbenchPage.closeEditor(editorPart, false);
            }
            ++i;
        }
    }

    public static synchronized void reloadMetamodel(String projectName) {
        MetamodelManager metamodelManager = (MetamodelManager)mInstanceMap.get(projectName);
        if (metamodelManager == null) {
            return;
        }
        metamodelManager.reloadMetamodel();
    }

    private void doReloadMetamodelUIUpdates() {
        if (this.mMetamodel == null) {
            return;
        }
        MetamodelManager.closeDevelopmentObjectEditors(this.mMetamodel);
        MetamodelEditorPart editor = MetamodelEditorPart.getOpenMetamodelEditor(this.mMetamodel);
        if (editor != null) {
            editor.setPreventRollback(true);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
        }
        this.disableSaveAndRollbackButton();
        this.refreshTSModel2();
    }

    public synchronized void reloadMetamodel() {
        this.getGenerationObjectChangedCache().clear();
        try {
            this.mMetamodel.clear(this.mMetamodelTicket);
        }
        catch (MetamodelException e) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "reloadMetamodel", "clear failed", e, true);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
        ProjectService.updateMetamodelJarsFromClasspath(project);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MetamodelManager.this.doReloadMetamodelUIUpdates();
                ICoreModelExtender[] extenders = MetamodelCoreEclipsePlugin.getDefault().getExtenders();
                int i = 0;
                while (i < extenders.length) {
                    try {
                        extenders[i].postReload(MetamodelManager.this.mMetamodel);
                    }
                    catch (Throwable t) {
                        MetamodelCoreEclipsePlugin.internalError(this.getClass(), "reloadMetamodel", "postReload failed", t, true);
                    }
                    ++i;
                }
            }
        });
    }

    public void refreshTSModel2() {
        HierarchyDeltaProvider hierarchyDeltaProvider = HierarchyDeltaProvider.getHierarchyDeltaProvider(this.mProjectName);
        if (hierarchyDeltaProvider == null) {
            return;
        }
        hierarchyDeltaProvider.totalUpdate();
        UniqueName modelUniqueName = ModelAccess.createModelUniqueName((String)this.mProjectName);
        Model model = ModelAccess.getModel((UniqueName)modelUniqueName);
        if (model != null) {
            model.getExtensionManager().modelContentsChanged();
        } else {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelManager.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "refreshTSModel", "could not find Model " + modelUniqueName.toString(), null, false);
        }
        ViewManager viewManager = ViewAccess.getViewManager((UniqueName)modelUniqueName);
        Enumeration views = viewManager.views();
        while (views.hasMoreElements()) {
            View view = (View)views.nextElement();
            view.dispose();
        }
    }

    public void markMDOsAsChanged(MainDevelopmentObject[] mdos) {
        this.mGenerationObjectChangedCache.update(mdos);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MetamodelInitializationListener
    implements InfrastructureManager.InitialisationListener {
        private IDCExtendedProject mComponentProject = null;
        private IProject mProject = null;
        private MetamodelManager mMetamodelManager;

        public MetamodelInitializationListener(IDCExtendedProject componentProject, IProject project, MetamodelManager metamodelManager) {
            this.mComponentProject = componentProject;
            this.mProject = project;
            this.mMetamodelManager = metamodelManager;
        }

        public void initialisationFinished() {
            this.mMetamodelManager.performDCInfrastructureDependantInitializations(this.mComponentProject, this.mProject);
        }

        public IProject getProject() {
            return this.mProject;
        }
    }

    private class MMCDCChangeListener
    implements DCChangeListener {
        private MetamodelManager mMetamodelManager;

        public MMCDCChangeListener(MetamodelManager metamodelManager) {
            this.mMetamodelManager = metamodelManager;
        }

        public void dcSynced(IDCProject arg0) {
            if (this.mMetamodelManager.mMetamodel.isModified()) {
                ProjectReloadNotificator.showReloadProjectPopup(MetamodelManager.this.mMetamodel.getName());
            } else {
                this.mMetamodelManager.reloadMetamodel();
            }
        }

        public void dcBuilt(IDCProject dcProject) {
        }
    }
}

