/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.plugin;

import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import java.util.HashMap;

public class HierarchyDeltaProvider
implements ModelAware,
DeltaTreeProvider {
    private static HashMap mInstanceMap = new HashMap();
    private String mProjectName;
    private Model mModel;
    private RootModelDeltaNode mRootUpdateNode;

    public void registered(Model model) {
        this.mModel = model;
        this.mProjectName = model.getUniqueName().getName();
        mInstanceMap.put(this.mProjectName, this);
        this.mRootUpdateNode = new RootModelDeltaNode(this.mModel);
    }

    public void unregistered(Model model) {
        if (this.mModel == null || model == null) {
            return;
        }
        if (model != this.mModel) {
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "unregisterd", "model != mModel", null, false);
            return;
        }
        mInstanceMap.remove(this.mProjectName);
        this.mModel = null;
        this.mProjectName = null;
    }

    public ModelDeltaNode getModelChanges() {
        RootModelDeltaNode updateNode = this.mRootUpdateNode;
        this.mRootUpdateNode = new RootModelDeltaNode(this.mModel);
        return updateNode;
    }

    public void totalUpdate() {
        String message = "HierarchyDeltaProvider: totalUpdate for project: " + this.mModel.getUniqueName().getName();
        MetamodelCoreEclipsePlugin.logMessage(message);
        this.mRootUpdateNode.makeTotallyChanged();
    }

    public static HierarchyDeltaProvider getHierarchyDeltaProvider(String projectName) {
        HierarchyDeltaProvider hierarchyDeltaProvider = (HierarchyDeltaProvider)mInstanceMap.get(projectName);
        return hierarchyDeltaProvider;
    }
}

