/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.plugin;

import com.sap.ide.login.UserValidator;
import com.sap.ide.metamodel.core.plugin.MMDtrException;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.services.MultilineTextDialog;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DtrHelper {
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$plugin$DtrHelper;

    private static void deleteFile(IFile file) {
        if (file.isReadOnly()) {
            return;
        }
        try {
            file.delete(true, false, null);
        }
        catch (CoreException e) {
            String message = "Deleting File " + file.getFullPath().toString() + " failed";
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "deletedFile", message, e, false);
        }
    }

    private static void deleteFiles(List files) {
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            IFile file = (IFile)iterator.next();
            try {
                file.delete(true, false, null);
            }
            catch (CoreException e) {
                String message = "Deleting File " + file.getFullPath().toString() + " failed";
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper") : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "deleteFiles", message, e, false);
            }
        }
    }

    public static void deleteFiles(IProject project, List filesToDelete, IProgressMonitor progressMonitor) {
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)project);
        if (teamProvider == null) {
            DtrHelper.deleteFiles(filesToDelete);
            return;
        }
        if (!DtrHelper.isUserLoggedOn(project) && !DtrHelper.logon(project)) {
            DtrHelper.showNotDeletedFiles(filesToDelete);
            return;
        }
        DtrHelper.deleteFilesInDTRProject(teamProvider, filesToDelete, progressMonitor);
    }

    private static void showNotDeletedFiles(List filesToDelete) {
        String message = "The follwing files could not be deleted:\n\n";
        Iterator iterator = filesToDelete.iterator();
        while (iterator.hasNext()) {
            IFile file = (IFile)iterator.next();
            message = message + file.getLocation() + "\n";
        }
        MultilineTextDialog multilineTextDialog = new MultilineTextDialog("Errors occured on deletion", message);
        multilineTextDialog.open();
    }

    public static void deleteFilesInDTRProject(DAVTeamProvider teamProvider, List files, IProgressMonitor progressMonitor) {
        ArrayList<IVfsActivityRecordedFolderItem> cheFiles = new ArrayList<IVfsActivityRecordedFolderItem>();
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            boolean isNew;
            IFile file = (IFile)iterator.next();
            if (file.isReadOnly()) {
                String message = "File " + file.getFullPath().toString() + " is readonly";
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper") : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "deleteFileInDTRProject", message, null, false);
                continue;
            }
            try {
                isNew = DtrHelper.isLocalOnlyAndNotCheckedOut(teamProvider, file);
            }
            catch (MMDtrException e) {
                DtrHelper.deleteFile(file);
                continue;
            }
            if (isNew) {
                DtrHelper.deleteFile(file);
                continue;
            }
            IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = DtrHelper.getVfsActivityRecordedFolderItem(teamProvider, file);
            if (vfsActivityRecordedFolderItem == null) continue;
            VfsFolderItemActivityState state = vfsActivityRecordedFolderItem.getActivityState();
            if (state == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                try {
                    progressMonitor.subTask("uncheckout " + file.getFullPath().toString());
                    vfsActivityRecordedFolderItem.uncheckout();
                }
                catch (VfsException e) {
                    MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper") : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "deleteFileInDTRProject", "uncheckout failed", e, false);
                }
                DtrHelper.deleteFile(file);
                continue;
            }
            if (state == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
                cheFiles.add(vfsActivityRecordedFolderItem);
                continue;
            }
            if (state == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
                DtrHelper.deleteFile(file);
                continue;
            }
            DtrHelper.deleteFile(file);
            String message = "File " + file.getFullPath().toString() + " has illegal Repository state: not CHECKED_OUT_FOR_CREATE and not CHECKED_OUT_FOR_EDIT";
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper") : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "deleteFileInDTRProject", message, null, false);
        }
        if (cheFiles.size() == 0) {
            return;
        }
        IVfsActivityRecordedFolderItem[] folderItems = cheFiles.toArray(new IVfsActivityRecordedFolderItem[cheFiles.size()]);
        progressMonitor.subTask("deleting files...");
        DtrHelper.deleteFiles(folderItems);
    }

    private static void deleteFiles(IVfsActivityRecordedFolderItem[] folderItems) {
        if (folderItems.length == 0) {
            return;
        }
        IVfsWorkspace vfsWorkspace = folderItems[0].getWorkspace();
        HashMap activityToFolderItems = new HashMap();
        int i = 0;
        while (i < folderItems.length) {
            IVfsActivityRecordedFolderItem folderItem = folderItems[i];
            IVfsActivity[] activities = folderItem.getOpenActivities();
            if (activities.length > 0) {
                Set<IVfsActivityRecordedFolderItem> folderItemSet;
                IVfsActivity vfsActivity = activities[0];
                if (activityToFolderItems.containsKey(vfsActivity)) {
                    folderItemSet = (Set)activityToFolderItems.get(vfsActivity);
                } else {
                    folderItemSet = new HashSet();
                    activityToFolderItems.put(vfsActivity, folderItemSet);
                }
                folderItemSet.add(folderItem);
            }
            ++i;
        }
        Iterator iterator = activityToFolderItems.keySet().iterator();
        while (iterator.hasNext()) {
            IVfsActivity vfsActivity = (IVfsActivity)iterator.next();
            Set folderItemSet = (Set)activityToFolderItems.get(vfsActivity);
            IVfsActivityRecordedFolderItem[] folderItemsToUncheckout = folderItemSet.toArray(new IVfsActivityRecordedFolderItem[folderItemSet.size()]);
            IVfsActivityRecordedFolderItem[] failedItemsUncheckout = new IVfsActivityRecordedFolderItem[]{};
            try {
                failedItemsUncheckout = vfsWorkspace.uncheckout(folderItemsToUncheckout, vfsActivity, false);
            }
            catch (VfsException e) {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper") : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "deleteFiles", "uncheckout failed", e, false);
            }
            int i2 = 0;
            while (i2 < failedItemsUncheckout.length) {
                folderItemSet.remove(failedItemsUncheckout[i2]);
                ++i2;
            }
            IVfsActivityRecordedFolderItem[] folderItemsToDelete = folderItemSet.toArray(new IVfsActivityRecordedFolderItem[folderItemSet.size()]);
            IVfsActivityRecordedFolderItem[] failedItemsDelete = new IVfsActivityRecordedFolderItem[]{};
            try {
                failedItemsDelete = vfsWorkspace.checkoutAndDelete(folderItemsToDelete, vfsActivity);
            }
            catch (VfsException e) {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper") : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "deleteFiles", "checkoutAndDelete failed", e, false);
            }
            DtrHelper.showFailedItems(failedItemsUncheckout, failedItemsDelete);
        }
    }

    private static void showFailedItems(IVfsActivityRecordedFolderItem[] failedItemsUncheckout, IVfsActivityRecordedFolderItem[] failedItemsDelete) {
        IVfsActivityRecordedFolderItem folderItem;
        int i;
        if (failedItemsUncheckout.length == 0 && failedItemsDelete.length == 0) {
            return;
        }
        String message = "";
        if (failedItemsUncheckout.length > 0) {
            message = message + "Uncheckout failed for the following files:\n";
            i = 0;
            while (i < failedItemsUncheckout.length) {
                folderItem = failedItemsUncheckout[i];
                message = message + "    " + folderItem.getLocalPath() + "\n";
                ++i;
            }
        }
        if (failedItemsDelete.length > 0) {
            message = message + "Checkout for delete failed for the following files:\n";
            i = 0;
            while (i < failedItemsDelete.length) {
                folderItem = failedItemsDelete[i];
                message = message + "    " + folderItem.getLocalPath() + "\n";
                ++i;
            }
        }
        MultilineTextDialog multilineTextDialog = new MultilineTextDialog("Errors occured on deletion", message);
        multilineTextDialog.open();
    }

    public static boolean isLocalOnlyAndNotCheckedOut(DAVTeamProvider teamProvider, IFile file) throws MMDtrException {
        IVfsFolderItem vfsFolderItem = teamProvider.getFolderItem((IResource)file);
        if (vfsFolderItem == null) {
            String message = "getFolderItem failed for " + file.getFullPath().toString();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "isLocalOnly", message, null, false);
            throw new MMDtrException();
        }
        VfsFolderItemLocationState state = vfsFolderItem.getLocationState();
        if (state != VfsFolderItemLocationState.LOCAL_ONLY) {
            return false;
        }
        IVfsActivityRecordedFolderItem activityRecordedFolderItem = vfsFolderItem.asActivityRecordedFolderItem();
        if (activityRecordedFolderItem == null) {
            String message = "asActivityRecordedFolderItem failed for " + file.getFullPath().toString();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "isLocalOnly", message, null, false);
            throw new MMDtrException();
        }
        return activityRecordedFolderItem.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT;
    }

    public static IVfsActivityRecordedFolderItem getVfsActivityRecordedFolderItem(DAVTeamProvider teamProvider, IFile file) {
        IVfsFolderItem vfsFolderItem = teamProvider.getFolderItem((IResource)file);
        if (vfsFolderItem == null) {
            String message = "getFolderItem failed for " + file.getFullPath().toString();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "getVfsActivityRecordedFolderItem", message, null, false);
            return null;
        }
        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = vfsFolderItem.asActivityRecordedFolderItem();
        if (vfsActivityRecordedFolderItem == null) {
            String message = "asActivityRecordedFolderItem failed for " + file.getFullPath().toString();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "getVfsActivityRecordedFolderItem", message, null, false);
            return null;
        }
        return vfsActivityRecordedFolderItem;
    }

    public static boolean isProjectUnderSourceControl(IProject project) {
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)project);
        return teamProvider != null;
    }

    public static boolean isUserLoggedOn() {
        return UserValidator.isDefaultServerOnline();
    }

    public static boolean isUserLoggedOn(IProject project) {
        if (project == null) {
            return false;
        }
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)project);
        if (teamProvider == null) {
            return false;
        }
        IVersionedFileSystemManager vfsManager = teamProvider.getVFSManager();
        if (vfsManager == null) {
            return false;
        }
        IVfsContext vfsContext = vfsManager.getCurrentContext();
        if (vfsContext == null) {
            return false;
        }
        String absoluteProjectPath = teamProvider.getProject().getLocation().toOSString();
        IVfsRemoteLocator vfsRemoteLocator = vfsContext.getRemoteLocator(absoluteProjectPath);
        if (vfsRemoteLocator == null) {
            return false;
        }
        boolean isUserLoggedOn = vfsContext.ping(vfsRemoteLocator, 2, 2000, 20000);
        return isUserLoggedOn;
    }

    public static boolean logon(IProject project) {
        if (project == null) {
            return false;
        }
        if (!ServicesUI.askUserToLogonToDtr()) {
            return false;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        UserValidator.getDefaultServerData((int)UserValidator.USER_LOGIN, (Shell)shell);
        return DtrHelper.isUserLoggedOn(project);
    }

    public static boolean isLocalOnly(DAVTeamProvider teamProvider, IFile file) throws MMDtrException {
        IVfsFolderItem vfsFolderItem = teamProvider.getFolderItem((IResource)file);
        if (vfsFolderItem == null) {
            String errorMessage = "getFolderItem failed for " + file.getFullPath().toString();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "isLocalOnly", errorMessage, null, false);
            throw new MMDtrException();
        }
        VfsFolderItemLocationState state = vfsFolderItem.getLocationState();
        return state == VfsFolderItemLocationState.LOCAL_ONLY;
    }

    public static boolean refreshFiles(DAVTeamProvider teamProvider, IFile[] files) {
        HashSet<String> alreadyRefreshedFolders = new HashSet<String>();
        int i = 0;
        while (i < files.length) {
            String message;
            IFile file = files[i];
            IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = DtrHelper.getVfsActivityRecordedFolderItem(teamProvider, file);
            if (vfsActivityRecordedFolderItem == null) {
                return false;
            }
            IVfsFile vfsFile = vfsActivityRecordedFolderItem.asFile();
            if (vfsFile == null) {
                String message2 = "asFile failed for " + file.getFullPath().toString();
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "refreshFiles", message2, null, false);
                return false;
            }
            IVfsFolder vfsFolder = null;
            IVfsGenericFolder vfsGenericFolder = null;
            try {
                vfsGenericFolder = vfsFile.getParent();
            }
            catch (VfsException e) {
                String message3 = "getParent failed for " + vfsFile.getAbsoluteRemotePath();
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "refreshFiles", message3, e, false);
                return false;
            }
            if (vfsGenericFolder == null) {
                message = "parent == null " + vfsFile.getAbsoluteRemotePath();
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "refreshFiles", message, null, false);
                return false;
            }
            vfsFolder = vfsGenericFolder.asFolder();
            if (vfsFolder == null) {
                message = "asFolder failed for " + vfsFolder.getLocalPath().toString();
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "refreshFiles", message, null, false);
                return false;
            }
            String path = vfsFolder.getAbsoluteRemotePath();
            if (!alreadyRefreshedFolders.contains(path)) {
                try {
                    vfsFolder.refreshFolderItems();
                }
                catch (VfsException e) {
                    String message4 = "refreshFolderItems failed for " + vfsFolder.getAbsoluteRemotePath();
                    MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$DtrHelper == null ? (class$com$sap$ide$metamodel$core$plugin$DtrHelper = DtrHelper.class$("com.sap.ide.metamodel.core.plugin.DtrHelper")) : class$com$sap$ide$metamodel$core$plugin$DtrHelper, "refreshFiles", message4, e, false);
                    return false;
                }
                alreadyRefreshedFolders.add(path);
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

