/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.generation;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.metainfo.Aggregation;
import com.sap.ide.metamodel.general.metainfo.Association;
import com.sap.ide.metamodel.general.metainfo.CardinalityEnum;
import com.sap.ide.metamodel.general.metainfo.MetaClass;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;

public class GenerationObjectRelationEvaluator {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$metamodel$core$generation$GenerationObjectRelationEvaluator == null ? (class$com$sap$ide$metamodel$core$generation$GenerationObjectRelationEvaluator = GenerationObjectRelationEvaluator.class$("com.sap.ide.metamodel.core.generation.GenerationObjectRelationEvaluator")) : class$com$sap$ide$metamodel$core$generation$GenerationObjectRelationEvaluator).getName());
    private HashSet mRelatedMainDevObjectKeys = new HashSet();
    private HashSet mRelatedDevObjectKeys = new HashSet();
    private HashMap mCache = new HashMap();
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$generation$GenerationObjectRelationEvaluator;

    public void initialize() {
        this.getRelatedDevObjectKeys().clear();
        this.getRelatedMainDevObjectKeys().clear();
        this.getCache().clear();
    }

    public final HashSet evaluateRelatedMainDevObjects(DevelopmentObject devObject) {
        long lStartingTime;
        long lEndingTime = lStartingTime = System.currentTimeMillis();
        if (this.getCache().containsKey(devObject.getKey())) {
            this.setRelatedMainDevObjectKeys((HashSet)this.getCache().get(devObject.getKey()));
        } else {
            this.getRelatedMainDevObjectKeys().clear();
            this.getRelatedMainDevObjectKeys().add(devObject.getMDO().getKey());
            this.getRelatedDevObjectKeys().clear();
            this.getRelatedDevObjectKeys().add(devObject.getMDO().getKey());
            try {
                this.evaluateAggregations(devObject.getMDO(), devObject, devObject.getMetaClass());
                this.evaluateAssociations(devObject.getMDO(), devObject, devObject.getMetaClass());
            }
            catch (Exception e) {
                TRACE_LOCATION.catching((Throwable)e);
                e.printStackTrace();
            }
            this.getCache().put(devObject.getKey(), this.getRelatedMainDevObjectKeys().clone());
        }
        lEndingTime = System.currentTimeMillis();
        TRACE_LOCATION.infoT("Calculating dependencies for " + devObject.getKey() + ": " + (lEndingTime - lStartingTime) + " ms)");
        return (HashSet)this.getRelatedMainDevObjectKeys().clone();
    }

    private void evaluateAggregations(MainDevelopmentObject originMainDevObject, DevelopmentObject devObject, MetaClass metaClass) {
        if (metaClass.getSuperClass() != null) {
            this.evaluateAggregations(originMainDevObject, devObject, metaClass.getSuperClass());
            this.evaluateAssociations(originMainDevObject, devObject, metaClass.getSuperClass());
        }
        Aggregation[] lAggregations = metaClass.getAggregations();
        String lMethodName = null;
        DevelopmentObject[] lDevObjects = null;
        DevelopmentObject lDevObject = null;
        int i = 0;
        while (i < lAggregations.length) {
            int y;
            lDevObjects = null;
            lDevObject = null;
            Method lMethod = null;
            if (CardinalityEnum.MULTIPLE.equals(lAggregations[i].getCardinality())) {
                lMethodName = "get" + lAggregations[i].getName();
                Class<?>[] lInterfaces = devObject.getClass().getInterfaces();
                y = 0;
                while (y < lInterfaces.length) {
                    try {
                        lMethod = lInterfaces[y].getMethod(lMethodName, new Class[0]);
                        lDevObjects = (DevelopmentObject[])lMethod.invoke((Object)devObject, new Object[0]);
                        break;
                    }
                    catch (Exception ex) {
                        TRACE_LOCATION.catching((Throwable)ex);
                        ex.printStackTrace();
                        ++y;
                    }
                }
            } else if (CardinalityEnum.SINGLE.equals(lAggregations[i].getCardinality())) {
                lMethodName = "get" + lAggregations[i].getSingularName();
                Class<?>[] lInterfaces = devObject.getClass().getInterfaces();
                y = 0;
                while (y < lInterfaces.length) {
                    try {
                        lMethod = lInterfaces[y].getMethod(lMethodName, new Class[0]);
                        lDevObject = (DevelopmentObject)lMethod.invoke((Object)devObject, new Object[0]);
                        lDevObjects = lDevObject == null ? new DevelopmentObject[]{} : new DevelopmentObject[]{lDevObject};
                        break;
                    }
                    catch (Exception ex) {
                        TRACE_LOCATION.catching((Throwable)ex);
                        ex.printStackTrace();
                        ++y;
                    }
                }
            }
            if (lDevObjects != null) {
                int x = 0;
                while (x < lDevObjects.length) {
                    if (!this.getRelatedDevObjectKeys().contains(lDevObjects[x].getKey())) {
                        this.getRelatedDevObjectKeys().add(lDevObjects[x].getKey());
                        if (lDevObjects[x].getMetaClass().getIsMDO()) {
                            this.getRelatedMainDevObjectKeys().add(((MainDevelopmentObject)lDevObjects[x]).getKey());
                        }
                        this.evaluateAggregations(originMainDevObject, lDevObjects[x], lDevObjects[x].getMetaClass());
                        this.evaluateAssociations(originMainDevObject, lDevObjects[x], lDevObjects[x].getMetaClass());
                    }
                    ++x;
                }
            }
            ++i;
        }
    }

    private void evaluateAssociations(MainDevelopmentObject originMainDevObject, DevelopmentObject devObject, MetaClass metaClass) {
        if (metaClass.getSuperClass() != null) {
            this.evaluateAssociations(originMainDevObject, devObject, metaClass.getSuperClass());
            this.evaluateAggregations(originMainDevObject, devObject, metaClass.getSuperClass());
        }
        Association[] lAssociations = metaClass.getAssociations();
        String lMethodName = null;
        DevelopmentObject[] lDevObjects = null;
        DevelopmentObject lDevObject = null;
        int i = 0;
        while (i < lAssociations.length) {
            int y;
            lDevObjects = null;
            lDevObject = null;
            Method lMethod = null;
            if (CardinalityEnum.MULTIPLE.equals(lAssociations[i].getCardinality())) {
                lMethodName = "get" + lAssociations[i].getName();
                Class<?>[] lInterfaces = devObject.getClass().getInterfaces();
                y = 0;
                while (y < lInterfaces.length) {
                    try {
                        lMethod = lInterfaces[y].getMethod(lMethodName, new Class[0]);
                        lDevObjects = (DevelopmentObject[])lMethod.invoke((Object)devObject, new Object[0]);
                        break;
                    }
                    catch (Exception ex) {
                        TRACE_LOCATION.catching((Throwable)ex);
                        ex.printStackTrace();
                        ++y;
                    }
                }
            } else if (CardinalityEnum.SINGLE.equals(lAssociations[i].getCardinality())) {
                lMethodName = "get" + lAssociations[i].getSingularName();
                Class<?>[] lInterfaces = devObject.getClass().getInterfaces();
                y = 0;
                while (y < lInterfaces.length) {
                    try {
                        lMethod = lInterfaces[y].getMethod(lMethodName, new Class[0]);
                        lDevObject = (DevelopmentObject)lMethod.invoke((Object)devObject, new Object[0]);
                        lDevObjects = lDevObject == null ? new DevelopmentObject[]{} : new DevelopmentObject[]{lDevObject};
                        break;
                    }
                    catch (Exception ex) {
                        TRACE_LOCATION.catching((Throwable)ex);
                        ex.printStackTrace();
                        ++y;
                    }
                }
            }
            if (lDevObjects != null) {
                int x = 0;
                while (x < lDevObjects.length) {
                    if (!this.getRelatedDevObjectKeys().contains(lDevObjects[x].getKey())) {
                        this.getRelatedDevObjectKeys().add(lDevObjects[x].getKey());
                        if (lDevObjects[x].getMetaClass().getIsMDO() && !originMainDevObject.getKey().equals(lDevObjects[x].getKey())) {
                            this.getRelatedMainDevObjectKeys().add(((MainDevelopmentObject)lDevObjects[x]).getKey());
                        } else {
                            this.evaluateAssociations(originMainDevObject, lDevObjects[x], lDevObjects[x].getMetaClass());
                            this.evaluateAggregations(originMainDevObject, lDevObjects[x], lDevObjects[x].getMetaClass());
                        }
                    }
                    ++x;
                }
            }
            ++i;
        }
    }

    private HashSet getRelatedMainDevObjectKeys() {
        return this.mRelatedMainDevObjectKeys;
    }

    private void setRelatedMainDevObjectKeys(HashSet relatedMainDevObjectKeys) {
        this.mRelatedMainDevObjectKeys = relatedMainDevObjectKeys;
    }

    private HashSet getRelatedDevObjectKeys() {
        return this.mRelatedDevObjectKeys;
    }

    private HashMap getCache() {
        return this.mCache;
    }

    private void setCache(HashMap cache) {
        this.mCache = cache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

