/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.generation;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class GenerationObjectChangedCache
implements DevelopmentObjectObserver {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$metamodel$core$generation$GenerationObjectChangedCache == null ? (class$com$sap$ide$metamodel$core$generation$GenerationObjectChangedCache = GenerationObjectChangedCache.class$("com.sap.ide.metamodel.core.generation.GenerationObjectChangedCache")) : class$com$sap$ide$metamodel$core$generation$GenerationObjectChangedCache).getName());
    private static final String WEB_DYNPRO_BUILDER_ID = "com.sap.ide.webdynpro.generation.GenerationBuilder";
    private static final String DICTIONARY_BUILDER_ID = "com.sap.dictionary.tools.generation.GenerationBuilder";
    private IProject mProject = null;
    private HashSet mModifiedMainDevObjectKeys = new HashSet();
    private boolean mValid = false;
    private String[] mConsumers = new String[0];
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$generation$GenerationObjectChangedCache;

    public GenerationObjectChangedCache(String projectName) {
        this();
        this.setProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        this.evaluateConsumers();
    }

    public GenerationObjectChangedCache() {
    }

    public final void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.update(events[i]);
            ++i;
        }
    }

    public final void update(MetamodelEvent event) {
        this.update(event.getModifiedObject().getMDO());
    }

    public final void update(MainDevelopmentObject[] mainDevObjects) {
        int i = 0;
        while (i < mainDevObjects.length) {
            this.update(mainDevObjects[i]);
            ++i;
        }
    }

    public final void update(MainDevelopmentObject mainDevObject) {
        Metamodel lMetamodel = mainDevObject.getMetamodel();
        if (lMetamodel == null) {
            return;
        }
        if (!lMetamodel.getName().equals(this.getProject().getName())) {
            TRACE_LOCATION.errorT("MDO " + mainDevObject.getKey().toString() + " has wrong meta model " + lMetamodel.getName() + ". Meta model " + this.getProject().getName() + " was expected.");
            return;
        }
        if (!this.isValid()) {
            this.clear();
            this.setValid(true);
        }
        if (!this.getModifiedMainDevObjectKeys().contains(mainDevObject.getKey())) {
            this.getModifiedMainDevObjectKeys().add(mainDevObject.getKey());
        }
    }

    public final void clear() {
        this.getModifiedMainDevObjectKeys().clear();
        this.setValid(true);
    }

    public final boolean isEmpty() {
        return this.getModifiedMainDevObjectKeys().isEmpty();
    }

    public final boolean isMainDevObjectModified(DevelopmentObjectKey mainDevObjectKey) {
        return this.getModifiedMainDevObjectKeys().contains(mainDevObjectKey);
    }

    private HashSet getModifiedMainDevObjectKeys() {
        return this.mModifiedMainDevObjectKeys;
    }

    public final void removeMainDevObject(DevelopmentObjectKey mainDevObjectKey) {
        if (this.getModifiedMainDevObjectKeys().contains(mainDevObjectKey)) {
            this.getModifiedMainDevObjectKeys().remove(mainDevObjectKey);
        }
    }

    public final boolean isValid() {
        return this.mValid;
    }

    public final void setValid(boolean valid, String consumer) {
        if (this.isLastConsumer(consumer)) {
            this.setValid(valid);
        }
    }

    public final void setValid(boolean valid) {
        this.mValid = valid;
    }

    public final IProject getProject() {
        return this.mProject;
    }

    private void setProject(IProject project) {
        this.mProject = project;
    }

    private String[] getConsumers() {
        return this.mConsumers;
    }

    private void setConsumers(String[] consumers) {
        this.mConsumers = consumers;
    }

    private boolean isLastConsumer(String consumer) {
        if (this.getConsumers().length > 0) {
            return this.getConsumers()[this.getConsumers().length - 1].equals(consumer);
        }
        return false;
    }

    public final String[] evaluateConsumers() {
        IProjectDescription lDescription = null;
        try {
            lDescription = this.getProject().getDescription();
        }
        catch (CoreException e) {
            return new String[0];
        }
        ICommand[] lCommands = lDescription.getBuildSpec();
        Vector<String> lConsumersVector = new Vector<String>();
        int i = 0;
        while (i < lCommands.length) {
            if (lCommands[i].getBuilderName().equals(WEB_DYNPRO_BUILDER_ID) || lCommands[i].getBuilderName().equals(DICTIONARY_BUILDER_ID)) {
                lConsumersVector.add(lCommands[i].getBuilderName());
            }
            ++i;
        }
        String[] lConsumers = new String[]{};
        this.setConsumers(lConsumersVector.toArray(lConsumers));
        return this.getConsumers();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

