/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.editor;

import com.sap.ide.eclipse.dii.component.IAskForSaveEditor;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.MetamodelObserver;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import java.io.ByteArrayInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class MetamodelEditorPart
extends EditorPart
implements MetamodelObserver,
IAskForSaveEditor {
    public static final String EDITOR_ID = "com.sap.ide.metamodel.core.metamodel";
    public static final String METAMODEL_FILE_NAME = ".metamodel";
    private Metamodel mMetamodel = null;
    private boolean mPreventRollback = false;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$plugin$MetamodelManager;

    public void createPartControl(Composite parent) {
        Text text = new Text(parent, 74);
        text.setText("This editor represents the changed metamodel for project '" + this.mMetamodel.getName() + "'. It is unsaved when there are unsaved changes within this metamodel and stops Eclipse from closing down without saving.");
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor monitor) {
        boolean result = MetamodelManager.saveAllMetaData(this.mMetamodel);
        if (result) {
            this.firePropertyChange(257);
        } else {
            monitor.setCanceled(true);
        }
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)input;
            IProject project = fileEditorInput.getFile().getProject();
            this.mMetamodel = MetamodelManager.getMetamodel(project.getName());
            this.mMetamodel.attachMetamodelObserver((MetamodelObserver)this);
            this.setTitle(this.mMetamodel.getName());
        }
    }

    public boolean isDirty() {
        return this.mMetamodel.isModified();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dirtyFlagChanged(boolean isDirty) {
        this.firePropertyChange(257);
    }

    public void dispose() {
        super.dispose();
        if (Metamodel.getInstance((String)this.mMetamodel.getName()) == null) {
            return;
        }
        if (this.mMetamodel.isModified() && !this.mPreventRollback) {
            MetamodelManager.rollbackMetaData(this.mMetamodel);
        }
        this.mMetamodel.detachMetamodelObserver((MetamodelObserver)this);
    }

    public static MetamodelEditorPart getOpenMetamodelEditor(Metamodel metamodel) {
        if (metamodel == null) {
            return null;
        }
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            return null;
        }
        IEditorReference[] editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorPart editor = editorReferences[i].getEditor(false);
            if (editor instanceof MetamodelEditorPart) {
                MetamodelEditorPart metamodelEditorPart = (MetamodelEditorPart)editor;
                if (metamodel.equals(metamodelEditorPart.mMetamodel)) {
                    return metamodelEditorPart;
                }
            }
            ++i;
        }
        return null;
    }

    public static void openMetamodelEditor(Metamodel metamodel) {
        String message;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            return;
        }
        IEditorPart openEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(metamodel.getName());
        final IFile file = project.getFile(METAMODEL_FILE_NAME);
        if (!file.exists()) {
            final ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){
                    static /* synthetic */ Class class$com$sap$ide$metamodel$core$plugin$MetamodelManager;

                    public void run(IProgressMonitor monitor) {
                        try {
                            file.create(in, true, null);
                        }
                        catch (CoreException e) {
                            String message = "could not create '.metadata' file. projectName =  " + project.getName();
                            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = 1.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "openMetamodelEditor", message, e, false);
                            return;
                        }
                        try {
                            file.setDerived(true);
                        }
                        catch (CoreException e) {
                            String message = "could not set derived flag for '.metadata' file. projectName =  " + project.getName();
                            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = 1.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "openMetamodelEditor", message, e, false);
                        }
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                }, null);
            }
            catch (CoreException e) {
                return;
            }
        }
        try {
            file.setDerived(true);
        }
        catch (CoreException e) {
            message = "could not set derived flag for '.metadata' file. projectName =  " + project.getName();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelEditorPart.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "openMetamodelEditor", message, e, false);
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(file, EDITOR_ID, false);
        }
        catch (PartInitException e) {
            message = "openMetamodelEditor failed. projectName =  " + project.getName();
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$plugin$MetamodelManager == null ? (class$com$sap$ide$metamodel$core$plugin$MetamodelManager = MetamodelEditorPart.class$("com.sap.ide.metamodel.core.plugin.MetamodelManager")) : class$com$sap$ide$metamodel$core$plugin$MetamodelManager, "openMetamodelEditor", message, e, false);
        }
        if (openEditor != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)openEditor);
            openEditor.setFocus();
        }
    }

    public boolean getPreventRollback() {
        return this.mPreventRollback;
    }

    public void setPreventRollback(boolean preventRollback) {
        this.mPreventRollback = preventRollback;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

