/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.actions.contextmenu;

import com.sap.ide.metamodel.core.services.TextPool;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;

public class MMPropertiesAction
implements IElementSingleAction {
    private final TextPool mText = TextPool.getInstance();

    public ICategory getCategory() {
        return Category.PROPERTIES;
    }

    public boolean isEnabled(Element element) {
        return this.isAvailable(element);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        return element instanceof Model;
    }

    public void run(Element element) {
        Shell shell = Display.getDefault().getActiveShell();
        PropertyPageManager pageManager = new PropertyPageManager();
        if (element != null) {
            MMSelectionAdapter selProvider = new MMSelectionAdapter(element);
            PropertyDialogAction propertyAction = new PropertyDialogAction(shell, (ISelectionProvider)selProvider);
            propertyAction.run();
        }
    }

    private IProject getEclipseProject(Element element) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String projectName = element.getModel().getUniqueName().getName();
        IProject eclipseProject = workspaceRoot.getProject(projectName);
        return eclipseProject;
    }

    private class MMSelectionAdapter
    implements ISelectionProvider {
        private Element mElement;

        public MMSelectionAdapter(Element element) {
            this.mElement = element;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            IProject eclipseProject = MMPropertiesAction.this.getEclipseProject(this.mElement);
            StructuredSelection selection = null;
            if (eclipseProject != null) {
                selection = new StructuredSelection((Object)eclipseProject);
            }
            return selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

