/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.actions.contextmenu;

import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.services.MetamodelImage;
import com.sap.ide.metamodel.core.services.TextPool;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;

public class MMDeleteProjectAction
implements IElementMultiAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private static final Image IMAGE;
    private static final ICategory CATEGORY;

    public ICategory getCategory() {
        return CATEGORY;
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof Model)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        return this.isAvailable(elements);
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        Vector<IProject> selectedProjects = new Vector<IProject>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                Entity entity = (Entity)elements[i];
                String projectName = entity.getUniqueName().getName();
                IProject project = workspaceRoot.getProject(projectName);
                selectedProjects.add(project);
            }
            ++i;
        }
        Object[] projects = selectedProjects.toArray(new IProject[0]);
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = workbenchWindow.getShell();
        DeleteResourceAction action = new DeleteResourceAction(shell);
        StructuredSelection structuredSelection = new StructuredSelection(projects);
        action.selectionChanged((IStructuredSelection)structuredSelection);
        action.run();
    }

    static {
        INFO = NAME = mText.getText(407);
        DESCRIPTION = mText.getText(409);
        IMAGE = SapIdeUtilImages.getSapImage((ISapImage)MetamodelImage.ICON_DELETE);
        CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)IMAGE);
    }
}

