/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.actions.contextmenu;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.core.services.MultilineTextDialog;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.core.services.TextPool;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.ICategory;
import org.eclipse.core.runtime.IPath;

public abstract class LanguageFilesAction
implements IElementMultiAction {
    protected static TextPool mTextPool = TextPool.getInstance();
    protected String mDecisionDialogTitle;
    protected String mDecisionDialogMessage;
    protected String mResultDialogTitle;
    protected String mResultDialogOperationMessage;

    public abstract ICategory getCategory();

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof Model)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        return this.isAvailable(elements);
    }

    protected abstract MainDevelopmentObject[] getAffectedMDOs(Metamodel var1);

    protected abstract void performLanguageFilesOperation(MainDevelopmentObject[] var1);

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        if (!ServicesUI.askUserToDecide(this.mDecisionDialogTitle, this.mDecisionDialogMessage)) {
            return;
        }
        String message = "";
        int i = 0;
        while (i < elements.length) {
            String projectName = elements[i].getModel().getUniqueName().getName();
            MetamodelManager manager = MetamodelManager.getMetamodelManager(projectName);
            Metamodel metamodel = manager.getMetamodel();
            MainDevelopmentObject[] mdos = this.getAffectedMDOs(metamodel);
            message = message + "Project " + metamodel.getName() + " :\n";
            if (mdos.length > 0) {
                if (this.checkLanguageFilesWriteability(manager, mdos)) {
                    this.performLanguageFilesOperation(mdos);
                    manager.markMDOsAsChanged(mdos);
                    MetamodelManager.saveAllMetaData(projectName);
                    int j = 0;
                    while (j < mdos.length) {
                        MainDevelopmentObject mdo = mdos[j];
                        message = message + "  " + this.mResultDialogOperationMessage + " " + mdo.getPackage() + "." + mdo.getName() + "\n";
                        ++j;
                    }
                } else {
                    message = message + "   canceled\n";
                }
            } else {
                message = message + "   nothing to do\n";
            }
            ++i;
        }
        MultilineTextDialog multilineTextDialog = new MultilineTextDialog(this.mResultDialogTitle, message);
        multilineTextDialog.open();
    }

    private boolean checkLanguageFilesWriteability(MetamodelManager metamodelManager, MainDevelopmentObject[] mdos) {
        MMRepositoryObject repositoryObject = new MMRepositoryObject(metamodelManager.getMetamodel(), "Language Files", "", false);
        int i = 0;
        while (i < mdos.length) {
            MainDevelopmentObject mdo = mdos[i];
            String[] languages = mdo.getTextPool().getAvailableLanguages();
            int j = 0;
            while (j < languages.length) {
                String pathString = mdo.getTextPool().getAbsolutePath(languages[j]);
                IPath path = metamodelManager.getFile(pathString).getFullPath();
                path = path.removeFirstSegments(1);
                repositoryObject.addAdditionalFile(path);
                ++j;
            }
            ++i;
        }
        MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
        repositoryObjectList.addRepositoryObject(repositoryObject);
        boolean rtn = RepositoryServices.checkWriteability(repositoryObjectList.getRepositoryObjects());
        return rtn;
    }
}

