/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.actions.contextmenu;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.core.services.MultilineTextDialog;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.core.services.TextPool;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.util.RawLanguageConverter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import org.eclipse.core.runtime.IPath;

public class I18NRepairAction
implements IElementMultiAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private static final ICategory CATEGORY;

    public ICategory getCategory() {
        return CATEGORY;
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof Model)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        return this.isAvailable(elements);
    }

    public void run(Element[] elements) {
        String dialogMessage;
        if (elements == null) {
            return;
        }
        String title = mText.getText(427);
        if (!ServicesUI.askUserToDecide(title, dialogMessage = mText.getText(428))) {
            return;
        }
        String message = "";
        int i = 0;
        while (i < elements.length) {
            String projectName = elements[i].getModel().getUniqueName().getName();
            MetamodelManager manager = MetamodelManager.getMetamodelManager(projectName);
            Metamodel metamodel = manager.getMetamodel();
            MainDevelopmentObject[] mdos = RawLanguageConverter.getAffectedMDOs((Metamodel)metamodel);
            message = message + "Project " + metamodel.getName() + " :\n";
            if (mdos.length > 0) {
                if (this.checkLanguageFilesWriteability(manager, mdos)) {
                    RawLanguageConverter.convert((MainDevelopmentObject[])mdos);
                    manager.markMDOsAsChanged(mdos);
                    MetamodelManager.saveAllMetaData(projectName);
                    int j = 0;
                    while (j < mdos.length) {
                        MainDevelopmentObject mdo = mdos[j];
                        message = message + "  added raw language file for " + mdo.getPackage() + "." + mdo.getName() + "\n";
                        ++j;
                    }
                } else {
                    message = message + "   canceled\n";
                }
            } else {
                message = message + "   nothing to do\n";
            }
            ++i;
        }
        MultilineTextDialog multilineTextDialog = new MultilineTextDialog(NAME, message);
        multilineTextDialog.open();
    }

    private boolean checkLanguageFilesWriteability(MetamodelManager metamodelManager, MainDevelopmentObject[] mdos) {
        MMRepositoryObject repositoryObject = new MMRepositoryObject(metamodelManager.getMetamodel(), "Language Files", "", false);
        int i = 0;
        while (i < mdos.length) {
            MainDevelopmentObject mdo = mdos[i];
            String pathString = mdo.getTextPool().getAbsolutePath(mdo.getTextPool().getMasterLanguage());
            IPath path = metamodelManager.getFile(pathString).getFullPath();
            path = path.removeFirstSegments(1);
            repositoryObject.addAdditionalFile(path);
            ++i;
        }
        MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
        repositoryObjectList.addRepositoryObject(repositoryObject);
        boolean rtn = RepositoryServices.checkWriteability(repositoryObjectList.getRepositoryObjects());
        return rtn;
    }

    static {
        INFO = NAME = mText.getText(425);
        DESCRIPTION = mText.getText(426);
        CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainRepairCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, null);
    }
}

