/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.actions.contextmenu;

import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.TextPool;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class CloseProjectAction
implements IElementMultiAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private static final String ERROR;
    private static final String NOT_CLOSE;
    private static final Image IMAGE;
    private static final ICategory CATEGORY;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$actions$contextmenu$CloseProjectAction;

    public ICategory getCategory() {
        return CATEGORY;
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName = elements[i].getModel().getUniqueName().getName();
                IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                Object nature = null;
                Entity entity = (Entity)elements[i];
                boolean enable = entity.canDelete();
                if (!enable) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        if (i < elements.length) {
            return elements[i] instanceof Entity;
        }
        return true;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                Entity entity = (Entity)elements[i];
                String projectName = entity.getUniqueName().getName();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                try {
                    if (ServicesEclipse.closeProjectEditors(project)) {
                        project.close((IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException e) {
                    MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$actions$contextmenu$CloseProjectAction == null ? CloseProjectAction.class$("com.sap.ide.metamodel.core.actions.contextmenu.CloseProjectAction") : class$com$sap$ide$metamodel$core$actions$contextmenu$CloseProjectAction, "run", "Failed to close project", e, true);
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ERROR, (String)(NOT_CLOSE + e.getMessage() + "."));
                }
            }
            ++i;
        }
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof ViewPart) {
            ViewPart view = (ViewPart)part;
            IAction closeAction = view.getViewSite().getActionBars().getGlobalActionHandler("closeProject");
            closeAction.setEnabled(closeAction.isEnabled());
            IAction openAction = view.getViewSite().getActionBars().getGlobalActionHandler("openProject");
            openAction.setEnabled(openAction.isEnabled());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        INFO = NAME = mText.getText(423);
        DESCRIPTION = mText.getText(424);
        ERROR = mText.getText(9);
        NOT_CLOSE = mText.getText(216);
        IMAGE = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_PROJECT_CLOSED");
        CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainBuildCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)IMAGE);
    }
}

