/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.actions;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.actions.SaveActionManager;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.MetamodelImage;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.core.services.TextPool;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ReloadMetadataAction
implements IElementMultiAction {
    private static final TextPool mTextPool = new TextPool();
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private static final Image IMAGE;
    private static final ICategory CATEGORY;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$actions$ReloadMetadataAction;

    public ICategory getCategory() {
        return CATEGORY;
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof Model)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        return this.isAvailable(elements);
    }

    private boolean containsModifiedMetamodels(Element[] elements) {
        int i = 0;
        while (i < elements.length) {
            Model model;
            String projectName;
            Metamodel metamodel;
            if (elements[i] instanceof Model && (metamodel = MetamodelManager.getMetamodel(projectName = (model = (Model)elements[i]).getUniqueName().getName())).isModified()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        boolean containsModifiedMetamodels = this.containsModifiedMetamodels(elements);
        ReloadConfirmation reloadConfirmation = this.confirmReload(containsModifiedMetamodels);
        if (!reloadConfirmation.reload) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Model) {
                Model model = (Model)elements[i];
                String projectName = model.getUniqueName().getName();
                MetamodelManager.reloadMetamodel(projectName);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (reloadConfirmation.rebuild) {
                    this.rebuildProject(project);
                } else {
                    ReloadMetadataAction.deleteAllProblemMarkers(project);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rebuildProject(IProject project) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            try {
                dialog.open();
                project.build(6, dialog.getProgressMonitor());
            }
            catch (Throwable t) {
                MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$actions$ReloadMetadataAction == null ? (class$com$sap$ide$metamodel$core$actions$ReloadMetadataAction = ReloadMetadataAction.class$("com.sap.ide.metamodel.core.actions.ReloadMetadataAction")) : class$com$sap$ide$metamodel$core$actions$ReloadMetadataAction, "rebuildProject", "Exception ocurred ", (Exception)t, true);
                Object var5_4 = null;
                dialog.close();
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dialog.close();
            throw throwable;
        }
        dialog.close();
    }

    private ReloadConfirmation confirmReload(boolean containsModifiedMetamodels) {
        String message = mTextPool.getText(405);
        if (containsModifiedMetamodels) {
            message = message + "\n" + mTextPool.getText(406);
        }
        String[] buttons = new String[]{"Reload+Rebuild", IDialogConstants.CANCEL_LABEL};
        ReloadConfirmation reloadConfirmation = new ReloadConfirmation();
        MessageDialog dialog = ServicesUI.createMessageDialog(mTextPool.getText(404), message, buttons, 3, null, 0);
        switch (dialog.open()) {
            case 0: {
                reloadConfirmation.reload = true;
                reloadConfirmation.rebuild = true;
                break;
            }
            default: {
                reloadConfirmation.reload = false;
                reloadConfirmation.rebuild = false;
            }
        }
        return reloadConfirmation;
    }

    public void closeAndReopenProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            String message = "getting project failed. projectName = " + projectName;
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "reloadMetamodel", message, null, false);
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        progressMonitorDialog.open();
        try {
            project.close(progressMonitorDialog.getProgressMonitor());
        }
        catch (CoreException e) {
            String message = "closing project failed. projectName = " + projectName;
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "reloadMetamodel", message, e, false);
            progressMonitorDialog.close();
            return;
        }
        if (!MetamodelManager.modifiedMetamodelsExist()) {
            SaveActionManager.disableSaveAllButton();
            SaveActionManager.disableRollbackButton();
        }
        try {
            project.open(progressMonitorDialog.getProgressMonitor());
        }
        catch (CoreException e) {
            String message = "opening project failed. projectName = " + projectName;
            MetamodelCoreEclipsePlugin.internalError(this.getClass(), "reloadMetamodel", message, e, false);
        }
        progressMonitorDialog.close();
    }

    private static final void deleteAllProblemMarkers(IProject project) {
        if (project == null) {
            return;
        }
        try {
            IMarker[] lMarkers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int i = 0;
            while (i < lMarkers.length) {
                lMarkers[i].delete();
                ++i;
            }
        }
        catch (Exception ex) {
            MetamodelCoreEclipsePlugin.internalError(class$com$sap$ide$metamodel$core$actions$ReloadMetadataAction == null ? (class$com$sap$ide$metamodel$core$actions$ReloadMetadataAction = ReloadMetadataAction.class$("com.sap.ide.metamodel.core.actions.ReloadMetadataAction")) : class$com$sap$ide$metamodel$core$actions$ReloadMetadataAction, "deleteAllProblemMarkers", "Exception ocurred getting Project Nature", ex, true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        INFO = NAME = mTextPool.getText(400);
        DESCRIPTION = mTextPool.getText(401);
        IMAGE = SapIdeUtilImages.getSapImage((ISapImage)MetamodelImage.ICON_RELOAD);
        CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)IMAGE);
    }

    private class ReloadConfirmation {
        boolean reload;
        boolean rebuild;

        private ReloadConfirmation() {
        }
    }
}

