/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.odbo.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.odbo.OdboConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.ADOMDAxis;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.ADOMDCell;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.ADOMDCellSet;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.ADOMDMember;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.ADOMDPosition;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.ADOProperty;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.Recordset;
import com.sap.ip.bi.sdk.dac.connector.olap.BIVariant;
import com.sap.ip.bi.sdk.dac.result.IBICellStatus;
import com.sap.ip.bi.sdk.dac.result.IBICursorColumn;
import com.sap.ip.bi.sdk.dac.result.impl.BIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.BIDataSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSetData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSetData;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.exception.BISQLException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BIMonitor;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.bi.sdk.util.impl.ServerRTCounter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ADOCommon {
    private ServerRTCounter counter;
    private Properties properties;
    private int _ObjPtr = 0;
    private String _conStr;
    private String _userID = "";
    private String _passWD = "";
    private long _openOption = -1L;
    private String _logonAsUserID = "";
    private String _logonAsUserDomain = "";
    private String _logonAsUserPassword = "";
    private ADOMDCellSet _cellSet = null;
    private int axisSize = 0;
    private static IBIDataSet dataSet;
    private static IBIColumnMetaData[] cellMeta;
    private static IBIResultSetData cellData;
    private List axisMetas = new ArrayList();
    private List axisDatas = new ArrayList();
    private static List axisCursors;
    private static final int FIXED_PROPS_COUNT = 10;
    private static final int OPTIONAL_PROPS_COUNT = 1;
    private static final Location loc;
    private static final Category cat;
    private IBIMonitor monitor;
    public static final int AD_ASYNC_CONNECT = 16;
    public static final int AD_CONNECT_UNSPECIFIED = -1;
    public static final int AD_SCHEMA_ASSERTS = 0;
    public static final int AD_SCHEMA_CATALOGS = 1;
    public static final int AD_SCHEMA_CHARACTER_SETS = 2;
    public static final int AD_SCHMEA_CHECK_CONSTRAINTS = 5;
    public static final int AD_SCHEMA_COLLATIONS = 3;
    public static final int AD_SCHEMA_COLUMN_PRIVILEGES = 13;
    public static final int AD_SCHEMA_COLUMNS = 4;
    public static final int AD_SCHEMA_COLUMNS_DOMAIN_USAGE = 11;
    public static final int AD_SCHEMA_CONSTRAINT_COLUMN_USAGE = 6;
    public static final int AD_SCHEMA_CONSTRAINT_TABLE_USAGE = 7;
    public static final int AD_SCHEMA_CUBES = 32;
    public static final int AD_SCHEMA_DBINFO_KEYWORDS = 30;
    public static final int AD_SCHEMA_DBINFO_LITERALS = 31;
    public static final int AD_SCHEMA_DIMENSIONS = 33;
    public static final int AD_SCHEMA_FOREIGNKEYS = 27;
    public static final int AD_SCHEMA_HIERARCHIES = 34;
    public static final int AD_SCHEMA_INDEXES = 12;
    public static final int AD_SCHEMA_KEY_COLUMN_USAGE = 8;
    public static final int AD_SCHEMA_LEVELS = 35;
    public static final int AD_SCHEMA_MEASURES = 36;
    public static final int AD_SCHEMA_MEMBERS = 38;
    public static final int AD_SCHEMA_PRIMARY_KEYS = 28;
    public static final int AD_SCHEMA_PROCEDURE_COLUMNS = 29;
    public static final int AD_SCHEMA_PROCEDURE_PARAMETERS = 26;
    public static final int AD_SCHEMA_PROCEDURES = 16;
    public static final int AD_SCHEMA_PROPERTIES = 37;
    public static final int AD_SCHEMA_PROVIDER_SPECIFIC = -1;
    public static final int AD_SCHEMA_PROVIDER_TYPES = 22;
    public static final int AD_SCHEMA_REFERENTIAL_CONSTRAINTS = 9;
    public static final int AD_SCHEMA_SCHEMATA = 17;
    public static final int AD_SCHEMA_SQLLANGUAGES = 18;
    public static final int AD_SCHEMA_STATISTICS = 19;
    public static final int AD_SCHEMA_TABLE_CONSTRAINTS = 10;
    public static final int AD_SCHEMA_TABLE_PRIVILEGES = 14;
    public static final int AD_SCHEMA_TABLES = 20;
    public static final int AD_SCHEMA_TRANSLATIONS = 21;
    public static final int AD_SCHEMA_TRUSTEES = 39;
    public static final int AD_SCHEMA_USAGE_PRIVILEGES = 15;
    public static final int AD_SCHEMA_VIEW_COLUMN_USAGE = 24;
    public static final int AD_SCHEMA_VIEWS = 23;
    public static final int AD_SCHEMA_VIEW_TABLE_USAGE = 25;
    private IBIConnectionInfo connectionInfo = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$ADOCommon;

    public ADOCommon() {
        this.counter = ServerRTCounter.getInstance();
    }

    public ADOCommon(Properties prop) {
        this.counter = ServerRTCounter.getInstance();
        loc.entering("ADOCommon(Properties prop)");
        this.properties = prop;
        Enumeration e = ((Hashtable)prop).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            loc.debugT("key:" + key);
            loc.debugT("value:" + prop.getProperty(key));
        }
        loc.exiting();
    }

    public ADOCommon(String conStr) {
        this.counter = ServerRTCounter.getInstance();
        loc.entering("ADOCommon(String conStr)");
        this._conStr = conStr;
        loc.exiting();
    }

    public void connect(IBIConnectionInfo connectionInfo) throws BIResourceException {
        loc.entering("connect()");
        this.connectionInfo = connectionInfo;
        this.connectAdo();
        loc.exiting();
    }

    private void connectAdo() throws BIResourceException {
        loc.entering("connectAdo()");
        this._userID = this.getBIProperty(BIConnectionConstants.USERNAME, this._userID);
        this._passWD = this.getBIProperty(BIConnectionConstants.PASSWORD, this._passWD);
        this._conStr = this.getBIProperty(OdboConnectionConstants.CONNECTION_STRING, this._conStr);
        this._logonAsUserID = this.getBIProperty(OdboConnectionConstants.LOGON_AS_USER_ID, this._logonAsUserID);
        this._logonAsUserDomain = this.getBIProperty(OdboConnectionConstants.LOGON_AS_USER_DOMAIN, this._logonAsUserDomain);
        this._logonAsUserPassword = this.getBIProperty(OdboConnectionConstants.LOGON_AS_USER_PASSWORD, this._logonAsUserPassword);
        this.open();
        loc.exiting();
    }

    public IBIConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void close() {
        loc.entering("close()");
        this.closeN();
        loc.exiting();
    }

    private final String getBIProperty(BIConnectionConstants key, String defaultValue) {
        String propValue = this.getProperty(key.toString());
        return propValue == null ? defaultValue : propValue;
    }

    public String getProperty(String key) {
        loc.entering("getProperty(String key)");
        loc.exiting();
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        loc.entering("setProperty(String key, String value)");
        this.properties.setProperty(key, value);
        loc.exiting();
    }

    public Properties getProperties() {
        loc.entering("getProperties()");
        loc.exiting();
        return this.properties;
    }

    public boolean isAlive() throws BIResourceException {
        loc.entering("isAlive()");
        loc.exiting();
        this.counter.incrementCounter();
        return this.isAliveN();
    }

    public native boolean isAliveN();

    private native void openN(String var1, String var2, String var3, long var4) throws BIResourceException;

    private native void openAsUserN(String var1, String var2, String var3, long var4, String var6, String var7, String var8) throws BIResourceException;

    public void open() throws BIResourceException {
        loc.entering("open()");
        try {
            this.counter.incrementCounter();
            if (this._logonAsUserID != null && this._logonAsUserID.length() != 0) {
                this.openAsUserN(this._conStr, this._userID, this._passWD, this._openOption, this._logonAsUserID, this._logonAsUserDomain, this._logonAsUserPassword);
            } else {
                this.openN(this._conStr, this._userID, this._passWD, this._openOption);
            }
        }
        catch (BIResourceException e) {
            throw new BIResourceException(this.getLocale(), "sdk.dac.connector.odbo_1001", (Throwable)e);
        }
        loc.exiting();
    }

    public void open(String conStr) throws BIResourceException {
        loc.entering("open(String conStr)");
        this._conStr = conStr;
        this.open();
        loc.exiting();
        loc.exiting();
    }

    public void open(String conStr, String userID) throws BIResourceException {
        loc.entering("open(String conStr, String userID)");
        this._conStr = conStr;
        this._userID = userID;
        this.open();
        loc.exiting();
        loc.exiting();
    }

    public void open(String conStr, String userID, String passWD) throws BIResourceException {
        loc.entering("open(String conStr, String userID, String passWD)");
        this._conStr = conStr;
        this._userID = userID;
        this._passWD = passWD;
        this.open();
        loc.exiting();
        loc.exiting();
    }

    public void open(String conStr, String userID, String passWD, long option) throws BIResourceException {
        loc.entering("open(String conStr, String userID, String passWD, long option)");
        this._conStr = conStr;
        this._userID = userID;
        this._passWD = passWD;
        this._openOption = option;
        this.open();
        loc.exiting();
    }

    public void open(String conStr, String userID, String passWD, long option, String logonAsUserID, String logonAsUserDomain, String logonAsUserPassword) throws BIResourceException {
        loc.entering("open(String conStr, String userID, String passWD, long option, String logonUser, String logonUserDomain, String logonUserPassword )");
        this._conStr = conStr;
        this._userID = userID;
        this._passWD = passWD;
        this._openOption = option;
        this.setLogonAs(logonAsUserID, logonAsUserDomain, logonAsUserPassword);
        this.open();
        loc.exiting();
        loc.exiting();
    }

    private native void closeN();

    public String getConnectionString() {
        return this._conStr;
    }

    public void setConnectionString(String conStr) {
        this._conStr = conStr;
    }

    public void setLogonAs(String logonAsUserID, String logonAsUserDomain, String logonAsUserPassword) {
        this._logonAsUserID = logonAsUserID;
        this._logonAsUserDomain = logonAsUserDomain;
        this._logonAsUserPassword = logonAsUserPassword;
    }

    private native void openSchemaN(int var1, String[] var2, String var3, Recordset var4);

    public Recordset openSchema(int schema, String[] restrictions, String schemaID) {
        loc.entering("openSchema(int schema,String[] restrictions, String schemaID");
        this.monitor = BIMonitor.createMonitor();
        this.monitor.startRequest(IBIMonitor.Request.CONNECTION);
        Recordset rs = new Recordset();
        this.counter.incrementCounter();
        this.openSchemaN(schema, restrictions, schemaID, rs);
        this.monitor.endRequest(IBIMonitor.Request.CONNECTION);
        loc.exiting();
        return rs;
    }

    public Recordset openSchema(int schema) {
        loc.entering("openSchema(int schema)");
        loc.exiting();
        return this.openSchema(schema, null, null);
    }

    public Recordset openSchema(int schema, String[] restrictions) {
        loc.entering("openSchema(int schema, String[] restrictions)");
        loc.exiting();
        return this.openSchema(schema, restrictions, null);
    }

    public IBIDataSet getDataSet(String commandString) throws BIResourceException {
        loc.entering("getDataSet()");
        this._cellSet = new ADOMDCellSet(this, this._conStr, commandString);
        this.axisSize = this._cellSet.getAxes().size();
        try {
            this.setupAxisData();
            this.setupCellData();
            dataSet = new BIDataSet(this.connectionInfo, cellData, cellMeta, IBIResultSet.Type.UNRESTRICTED, true, false);
            int i = 0;
            while (i < this.axisSize) {
                axisCursors.add(i, dataSet.createAxisCursor((IBIResultSetData)this.axisDatas.get(this.axisSize - i - 1), (IBIColumnMetaData[])this.axisMetas.get(this.axisSize - i - 1), false));
                this.setupDimensionCursors(this.axisSize - i - 1, (IBIAxisCursor)axisCursors.get(i));
                ++i;
            }
        }
        catch (BISQLException e) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.odbo_1005", (Throwable)e);
        }
        catch (SQLException e) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.odbo_1005", (Throwable)e);
        }
        loc.exiting();
        return dataSet;
    }

    private void setupDimensionCursors(int axis, IBIAxisCursor cursor) throws SQLException {
        loc.entering("setupDimensionCursors");
        ADOMDAxis adomdAxis = (ADOMDAxis)this._cellSet.getAxes().elementAt(axis);
        Vector positions = adomdAxis.getPositions();
        int offset = 0;
        if (positions.size() > 0) {
            ADOMDPosition position = (ADOMDPosition)positions.elementAt(0);
            Vector members = position.getMembers();
            int j = 0;
            while (j < members.size()) {
                ADOMDMember member = (ADOMDMember)members.elementAt(j);
                boolean hasProperty = false;
                Vector props = member.getProperties();
                if (props != null) {
                    hasProperty = true;
                }
                String dimNam = this.memToDimName(member.getName());
                int length = 10 + (hasProperty ? props.size() * 1 : 0);
                cursor.createDimensionCursor(dimNam, offset, length);
                offset += length;
                ++j;
            }
        }
        loc.exiting();
    }

    private void setupAxisData() throws BISQLException, SQLException {
        loc.entering("setupAxisData()");
        int i = 0;
        while (i < this.axisSize) {
            ArrayList axisData = new ArrayList();
            BIColumnMetaData[] axisMeta = this.setupAxisMeta(i, axisData);
            this.axisMetas.add(i, axisMeta);
            BIResultSetData data = new BIResultSetData(this.connectionInfo, axisData);
            this.axisDatas.add(i, data);
            ++i;
        }
        loc.exiting();
    }

    private boolean uniqueNameExist(Object[] existUName, String uName) {
        int i = 0;
        while (i < existUName.length) {
            if (existUName[i] == null) {
                existUName[i] = uName;
                return false;
            }
            if (((String)existUName[i]).compareTo(uName) == 0) {
                return true;
            }
            ++i;
        }
        return true;
    }

    private BIColumnMetaData[] setupAxisMeta(int axis, ArrayList data) throws SQLException {
        loc.entering("setupAxisMeta");
        Vector<String> colPrefixs = new Vector<String>();
        HashMap<String, String[]> propPrefixs = new HashMap<String, String[]>();
        Vector relaValues = new Vector();
        ArrayList tmpData = new ArrayList();
        int realColumnLength = 0;
        Vector positions = ((ADOMDAxis)this._cellSet.getAxes().elementAt(axis)).getPositions();
        int i = 0;
        while (i < positions.size()) {
            Vector members = ((ADOMDPosition)positions.elementAt(i)).getMembers();
            HashMap<String, Object[]> dataObj = new HashMap<String, Object[]>();
            int j = 0;
            while (j < members.size()) {
                int aLen = 10;
                ADOMDMember member = (ADOMDMember)members.elementAt(j);
                String colPrefix = this.memToDimName(member.getUniqueName());
                Vector properties = member.getProperties();
                if (properties != null) {
                    aLen += properties.size() * 1;
                }
                Object[] dataObject = new Object[aLen];
                if (!colPrefixs.contains(colPrefix)) {
                    colPrefixs.add(colPrefix);
                    realColumnLength += aLen;
                }
                dataObject[0] = member.getName();
                dataObject[1] = member.getCaption();
                dataObject[2] = member.getUniqueName();
                dataObject[3] = this.memToDimName(member.getUniqueName());
                dataObject[4] = member.getDescription();
                dataObject[5] = member.getLevelName();
                dataObject[6] = String.valueOf(member.getChildCount());
                dataObject[7] = String.valueOf(member.getDrilledDown());
                dataObject[8] = new Integer((int)member.getLevelDepth());
                dataObject[9] = String.valueOf(member.getParentSameAsPrev());
                int offset = 0;
                if (properties != null && properties.size() > 0) {
                    String[] propNameAll = new String[properties.size()];
                    int ps = 0;
                    while (ps < properties.size()) {
                        String propName;
                        String name = ((ADOProperty)properties.get(ps)).getName();
                        propNameAll[ps] = propName = name.substring(name.lastIndexOf(91) + 1, name.lastIndexOf(93));
                        dataObject[10 + offset] = ((ADOProperty)properties.get(ps)).getValue().toString();
                        ++offset;
                        ++ps;
                    }
                    propPrefixs.put(colPrefix, propNameAll);
                }
                dataObj.put(colPrefix, dataObject);
                ++j;
            }
            tmpData.add(dataObj);
            ++i;
        }
        int i2 = 0;
        while (i2 < tmpData.size()) {
            Object[] realDataObj = new Object[realColumnLength];
            Map dataObj = (Map)tmpData.get(i2);
            int offset = 0;
            int j = 0;
            while (j < colPrefixs.size()) {
                int dLen = 10;
                String prefix = (String)colPrefixs.elementAt(j);
                if (propPrefixs.containsKey(prefix)) {
                    dLen += ((String[])propPrefixs.get(prefix)).length * 1;
                }
                if (dataObj.containsKey(prefix)) {
                    System.arraycopy((Object[])dataObj.get(prefix), 0, realDataObj, offset, dLen);
                }
                offset += dLen;
                ++j;
            }
            data.add(realDataObj);
            ++i2;
        }
        BIColumnMetaData[] colMetas = new BIColumnMetaData[realColumnLength];
        int i3 = 0;
        int j = 0;
        while (j < colPrefixs.size()) {
            String prefix = (String)colPrefixs.elementAt(j);
            colMetas[i3] = new BIColumnMetaData(this.connectionInfo, 12, prefix + "." + IBICursorColumn.MEMBER_NAME);
            colMetas[i3 + 1] = new BIColumnMetaData(this.connectionInfo, 12, prefix + "." + IBICursorColumn.MEMBER_CAPTION);
            colMetas[i3 + 2] = new BIColumnMetaData(this.connectionInfo, 12, prefix + "." + IBICursorColumn.MEMBER_UNIQUE_NAME);
            colMetas[i3 + 3] = new BIColumnMetaData(this.connectionInfo, 12, prefix + "." + IBICursorColumn.DIMENSION_UNIQUE_NAME);
            colMetas[i3 + 4] = new BIColumnMetaData(this.connectionInfo, 12, prefix + "." + IBICursorColumn.DESCRIPTION);
            colMetas[i3 + 5] = new BIColumnMetaData(this.connectionInfo, 12, prefix + "." + IBICursorColumn.LEVEL_UNIQUE_NAME);
            colMetas[i3 + 6] = new BIColumnMetaData(this.connectionInfo, 12, prefix + "." + IBICursorColumn.CHILDREN_CARDINALITY);
            colMetas[i3 + 7] = new BIColumnMetaData(this.connectionInfo, 12, prefix + "." + IBICursorColumn.MEMBER_DRILLED_DOWN);
            colMetas[i3 + 8] = new BIColumnMetaData(this.connectionInfo, 4, prefix + "." + IBICursorColumn.LEVEL_NUMBER.toString());
            colMetas[i3 + 9] = new BIColumnMetaData(this.connectionInfo, 12, prefix + "." + IBICursorColumn.PARENT_SAME_AS_PROV);
            String propNam = null;
            if (propPrefixs.containsKey(prefix)) {
                int ps = 0;
                while (ps < ((String[])propPrefixs.get(prefix)).length) {
                    propNam = prefix + ".Attribute." + ((String[])propPrefixs.get(prefix))[ps] + ".";
                    colMetas[i3 + 10] = new BIColumnMetaData(this.connectionInfo, 12, propNam + IBICursorColumn.VALUE);
                    ++i3;
                    ++ps;
                }
            }
            i3 += 10;
            ++j;
        }
        loc.exiting();
        return colMetas;
    }

    private String memToDimName(String memUName) {
        String dimName = "";
        String tmp = memUName;
        int len = memUName.length();
        int i = 0;
        while (i < 3) {
            tmp = tmp.substring(tmp.indexOf("["), len);
            len = tmp.length();
            ++i;
        }
        dimName = tmp.substring(1, tmp.indexOf("]"));
        return dimName;
    }

    private void setupCellData() throws BISQLException, SQLException {
        loc.entering("setupCellData");
        cellMeta = new IBIColumnMetaData[]{new BIColumnMetaData(IBICursorColumn.VALUE), new BIColumnMetaData(IBICursorColumn.DATATYPE), new BIColumnMetaData(IBICursorColumn.STATUS), new BIColumnMetaData(IBICursorColumn.FORMATTED_VALUE)};
        ArrayList<Object[]> cd = new ArrayList<Object[]>();
        int cellNumber = this._cellSet.getCellNumber();
        int i = 0;
        while (i < cellNumber) {
            ADOMDCell cell = this._cellSet.getItem(i);
            loc.debugT("After setupCell::" + cell.getFormattedValue());
            BIVariant variant = cell.getValue();
            int type = cell.getValue().getType();
            switch (type) {
                case 3: {
                    cd.add(new Object[]{new Short(variant.getShort()), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 4: {
                    cd.add(new Object[]{new Integer(variant.getInt()), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 5: {
                    cd.add(new Object[]{new Long(variant.getLong()), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 6: {
                    cd.add(new Object[]{new Float(variant.getFloat()), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 7: {
                    cd.add(new Object[]{new Double(variant.getDouble()), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 8: {
                    cd.add(new Object[]{new Boolean(variant.getBoolean()), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 17: {
                    cd.add(new Object[]{new Character(variant.getChar()), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 16: {
                    cd.add(new Object[]{new String(variant.getString()), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 1: {
                    cd.add(new Object[]{null, new Integer(type), IBICellStatus.NULL, cell.getFormattedValue()});
                    break;
                }
                case 0: {
                    cd.add(new Object[]{new String(variant.getString()), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 13: {
                    cd.add(new Object[]{variant.getDate(), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 14: {
                    cd.add(new Object[]{variant.getTime(), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 15: {
                    cd.add(new Object[]{variant.getTimestamp(), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 18: {
                    cd.add(new Object[]{variant.getObject(), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                case 19: {
                    cd.add(new Object[]{variant.getByteArray(), new Integer(type), IBICellStatus.OK, cell.getFormattedValue()});
                    break;
                }
                default: {
                    throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.connector.olap_1006");
                }
            }
            ++i;
        }
        cellData = new BIResultSetData(this.connectionInfo, cd);
        loc.exiting();
    }

    private Locale getLocale() {
        return this.connectionInfo == null ? Locale.getDefault() : this.connectionInfo.getLocale();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        axisCursors = new ArrayList();
        System.loadLibrary("sapbiado");
        loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$ADOCommon == null ? (class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$ADOCommon = ADOCommon.class$("com.sap.ip.bi.sdk.dac.connector.odbo.impl.ADOCommon")) : class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$ADOCommon).getName());
        cat = BILoggingSetup.CONNECTION.getCategory();
    }
}

