/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.odbo;

import com.sap.ip.bi.sdk.dac.connector.odbo.OdboConnection;
import com.sap.ip.bi.sdk.dac.connector.odbo.OdboConnectionProperties;
import com.sap.ip.bi.sdk.dac.connector.odbo.OdboManagedConnectionFactory;
import com.sap.ip.bi.sdk.dac.connector.odbo.OdboManagedConnectionMetaData;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.Connection;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class OdboManagedConnection
implements ManagedConnection {
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboManagedConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboManagedConnection = OdboManagedConnection.class$("com.sap.ip.bi.sdk.dac.connector.odbo.OdboManagedConnection")) : class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboManagedConnection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private PrintWriter m_logWriter;
    protected OdboManagedConnectionFactory m_managedConnectionFactory;
    private Subject m_subject;
    private OdboConnectionProperties m_request_info;
    private Connection connection;
    private String user;
    private String passwd;
    protected Vector m_associated_connections = new Vector();
    protected Vector m_connection_listeners = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboManagedConnection;

    protected OdboManagedConnection(OdboManagedConnectionFactory managed_connection_factory, Subject subject, OdboConnectionProperties request_info) throws BIResourceException {
        loc.entering("OdboManagedConnection()");
        this.m_managedConnectionFactory = managed_connection_factory;
        this.m_logWriter = managed_connection_factory.m_logWriter;
        this.m_subject = subject;
        this.m_request_info = request_info;
        try {
            Properties connProps = new Properties(managed_connection_factory.m_properties);
            if (subject != null) {
                loc.debugT(OdboConnectionProperties.Parameter.USER.name + "::" + this.m_request_info.getUserName() + OdboConnectionProperties.Parameter.PASSWD.name + "::" + this.m_request_info.getPassword() + OdboConnectionProperties.Parameter.CONNSTR.name + "::" + this.m_request_info.getConnString() + OdboConnectionProperties.Parameter.LANGUAGE.name + "::" + this.m_request_info.getLanguage());
                Iterator<Object> it = subject.getPrivateCredentials().iterator();
                Object pc = null;
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!pc.getClass().isAssignableFrom(obj.getClass())) continue;
                    pc = (PasswordCredential)obj;
                    break;
                }
                if (pc != null) {
                    connProps.setProperty(OdboConnectionProperties.Parameter.USER.name, pc.getUserName());
                    connProps.setProperty(OdboConnectionProperties.Parameter.PASSWD.name, new String(pc.getPassword()));
                }
            } else if (request_info != null && request_info.m_properties != null) {
                Enumeration e = ((Hashtable)request_info.m_properties).keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    connProps.setProperty(key, request_info.getProperty(key));
                }
            }
            this.connection = Connection.connect(connProps);
        }
        catch (ResourceException ex) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1100", (Throwable)ex);
        }
        loc.exiting();
    }

    protected boolean equals(OdboManagedConnectionFactory managed_connection_factory, Subject subject, OdboConnectionProperties request_info) throws BIResourceException {
        String method = "equals( OdboManagedConnectionFactory, Subject, OdboConnectionProperties)";
        loc.entering("equals( OdboManagedConnectionFactory, Subject, OdboConnectionProperties)");
        if (this.m_subject != null && subject == null || this.m_subject == null && subject != null) {
            return false;
        }
        if (this.m_subject != null && !this.m_subject.equals(subject)) {
            return false;
        }
        if (managed_connection_factory != null && !this.m_managedConnectionFactory.equals(managed_connection_factory)) {
            return false;
        }
        return subject != null || this.compareProperties(request_info);
    }

    protected boolean compareProperties(OdboConnectionProperties other) throws BIResourceException {
        OdboConnectionProperties request_info = null;
        request_info = other == null ? new OdboConnectionProperties(this.m_managedConnectionFactory.m_properties) : other;
        if (request_info.m_properties == null) {
            request_info.m_properties = this.m_managedConnectionFactory.m_properties;
        }
        if (((Hashtable)this.connection.getProperties()).size() < ((Hashtable)request_info.m_properties).size()) {
            return false;
        }
        boolean is_equal = true;
        Enumeration keys = ((Hashtable)this.connection.getProperties()).keys();
        while (keys.hasMoreElements() && is_equal) {
            String key = (String)keys.nextElement();
            String valueMC = this.connection.getProperty(key);
            String valueNew = request_info.m_properties.getProperty(key);
            loc.debugT(cat, "key:" + key + "valueMC:" + valueMC + "valueNew:" + valueNew);
            if (valueMC != null && valueMC.length() > 0 && (valueNew == null || valueNew.length() == 0)) {
                is_equal = false;
                continue;
            }
            if ((valueMC == null || valueMC.length() == 0) && valueNew != null && valueNew.length() > 0) {
                is_equal = false;
                continue;
            }
            if (valueMC == null || valueNew == null || valueMC.equals(valueNew)) continue;
            is_equal = false;
        }
        return is_equal;
    }

    /*
     * Loose catch block
     */
    public void destroy() throws BIResourceException {
        Object v0;
        block11: {
            if (this.connection == null) {
                return;
            }
            this.cleanup();
            Object var3_1 = null;
            try {
                this.connection.close();
                v0 = null;
                break block11;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            {
                break block11;
                catch (BIResourceException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                Object v1;
                Object var3_2 = null;
                try {
                    this.connection.close();
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var6_8 = v1;
                this.connection = null;
                throw throwable;
            }
        }
        Object var6_7 = v0;
        this.connection = null;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        this.assertConnection();
        return new OdboConnection(this);
    }

    public void cleanup() throws BIResourceException {
        Vector vector = this.m_associated_connections;
        synchronized (vector) {
            Vector list = (Vector)this.m_associated_connections.clone();
            int num_connections = list.size();
            int i = 0;
            while (i < num_connections) {
                ((OdboConnection)((Object)list.elementAt(i))).dissociateManagedConnection();
                ++i;
            }
            this.m_associated_connections.removeAllElements();
        }
    }

    public void associateConnection(Object connection) throws BIResourceException {
        if (connection == null) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1101");
        }
        if (!(connection instanceof OdboConnection)) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1007", new Object[]{connection.getClass().toString()});
        }
        this.assertConnection();
        ((OdboConnection)((Object)connection)).associateConnection(this);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.m_connection_listeners == null) {
            this.m_connection_listeners = new Vector();
        }
        this.m_connection_listeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.m_connection_listeners != null) {
            this.m_connection_listeners.removeElement(listener);
        }
    }

    public XAResource getXAResource() throws BIResourceException {
        throw new BIRuntimeException(Locale.getDefault(), "sdk_1000");
    }

    public LocalTransaction getLocalTransaction() throws BIResourceException {
        throw new BIRuntimeException(Locale.getDefault(), "sdk_1000");
    }

    public ManagedConnectionMetaData getMetaData() throws BIResourceException {
        this.assertConnection();
        return new OdboManagedConnectionMetaData(this);
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.m_logWriter = logWriter;
    }

    public PrintWriter getLogWriter() throws BIResourceException {
        return this.m_logWriter;
    }

    public OdboManagedConnectionFactory getManagedConnectionFactory() {
        return this.m_managedConnectionFactory;
    }

    protected void unregisterConnection(OdboConnection connection) {
        this.m_associated_connections.removeElement((Object)connection);
    }

    protected void assertConnection() throws BIResourceException {
        if (this.connection == null || !this.connection.isAlive()) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1101");
        }
    }

    protected Connection getConnection() throws BIResourceException {
        return this.connection;
    }

    protected void fireConnectionClosedEvent(javax.resource.cci.Connection connection) throws BIResourceException {
        if (this.m_connection_listeners == null) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)connection);
        Vector list = (Vector)this.m_connection_listeners.clone();
        int i = 0;
        while (i < list.size()) {
            ((ConnectionEventListener)list.elementAt(i)).connectionClosed(event);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

