/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.EarProject;
import com.tssap.j2ee.core.ear.WebModule;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.internal.core.providers.ear.EarProvidersPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.providers.proxy.ProxyRule;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class WebModuleProxyRule
implements ProxyRule {
    public UniqueNameEnumeration getProxies(Model proxyModel, Model sourceModel, UniqueName source) {
        if (!WebAppModelMetaInfo.isWebApp((UniqueName)source)) {
            return null;
        }
        String fileName = WebAppModelMetaInfo.getWebAppFileName((UniqueName)source);
        if (fileName == null || fileName.trim().length() == 0) {
            EarProvidersPlugin.logWarning("Invalid web app encountered [" + source + "] in model [" + sourceModel + "]");
            return null;
        }
        IProject sourceProject = ModelUinSupport.getProject((UniqueName)sourceModel.getUniqueName());
        if (sourceProject == null) {
            return null;
        }
        WebAppProject webAppProject = WebAppProject.getInstance((IProject)sourceProject);
        if (webAppProject == null) {
            return null;
        }
        IProject proxyProject = ModelUinSupport.getProject((UniqueName)proxyModel.getUniqueName());
        if (proxyProject == null) {
            return null;
        }
        EarProject earProject = EarProject.getInstance((IProject)proxyProject);
        if (earProject == null) {
            return null;
        }
        Ear[] ears = earProject.getEars();
        if (ears == null || ears.length == 0) {
            return null;
        }
        if (!UtilsPlugin.references((IProject)proxyProject, (IProject)sourceProject)) {
            return null;
        }
        ArrayList uins = new ArrayList();
        int i = 0;
        while (i < ears.length) {
            this.addProxies(uins, ears[i], sourceProject, fileName, sourceModel, source);
            ++i;
        }
        if (uins.isEmpty()) {
            return null;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }

    public void addProxies(List uins, Ear ear, IProject webAppProject, String fileName, Model webAppModel, UniqueName webAppUin) {
        WebModule[] webModules = ear.getWebModules();
        if (webModules == null || webModules.length == 0) {
            return;
        }
        UniqueName earUin = null;
        int i = 0;
        while (i < webModules.length) {
            IProject webAppProjectRef;
            WebApp webApp;
            WebModule webModule = webModules[i];
            if (webModule != null && (webApp = webModule.getReferencedWebApp()) != null && webApp.isValid() && fileName.equals(webApp.getFile().getProjectRelativePath().toString()) && (webAppProjectRef = webApp.getFile().getProject()) != null && webAppProjectRef.getName().equals(webAppProject.getName())) {
                if (earUin == null) {
                    earUin = EarModelMetaInfo.getEar(ear.getFile());
                }
                UniqueName proxyUin = EarModelMetaInfo.getModule(webAppModel, webAppUin, earUin, webModule.getUri());
                uins.add(proxyUin);
            }
            ++i;
        }
    }
}

