/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.WebModule;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ear.EarModelAccess;
import com.tssap.j2ee.internal.core.providers.ear.EarProvidersPlugin;
import com.tssap.j2ee.internal.core.providers.webapp.WebAppModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public final class WebModuleProxyProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EarModelMetaInfo.isWebModule(element.getUniqueName());
    }

    private boolean moduleExists(UniqueName uin) {
        WebModule module = EarModelAccess.getWebModule(this.getModel(), uin);
        if (module == null) {
            return false;
        }
        Model moduleRefModel = EarModelMetaInfo.getModuleModel(uin);
        if (moduleRefModel == null || moduleRefModel.isDeleted()) {
            return false;
        }
        Entity moduleRef = moduleRefModel.findEntity(EarModelMetaInfo.getModule(uin));
        if (moduleRef == null || moduleRef.isDeleted()) {
            return false;
        }
        WebApp webApp = module.getReferencedWebApp();
        if (webApp == null || !webApp.isValid()) {
            return false;
        }
        UniqueName webAppUin = WebAppModelMetaInfo.getWebApp((IFile)webApp.getFile());
        return moduleRef.getUniqueName().equals(webAppUin);
    }

    public boolean isDeleted(Element element) {
        return !this.moduleExists(element.getUniqueName());
    }

    public boolean exists(UniqueName uin) {
        if (!EarModelMetaInfo.isWebModule(uin)) {
            return false;
        }
        return this.moduleExists(uin);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String uri;
        if (!"com.tssap.j2ee.core.webapp.WebApp".equals(shapeType)) {
            return false;
        }
        if (!EarModelMetaInfo.isEar(parent.getUniqueName())) {
            return false;
        }
        Ear ear = EarModelAccess.getEar(this.getModel(), parent.getUniqueName());
        if (ear == null) {
            return false;
        }
        if (template == null) {
            return true;
        }
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if ((uri = template.getPropertyValue("$name")) == null) {
            Entity webAppEntity = EarModelMetaInfo.getModuleSource(template);
            if (webAppEntity == null || !WebAppModelMetaInfo.isWebApp((UniqueName)webAppEntity.getUniqueName())) {
                return false;
            }
            WebApp webApp = WebAppModelAccess.getWebApp((Model)webAppEntity.getModel(), (UniqueName)webAppEntity.getUniqueName());
            if (webApp == null || !webApp.isValid()) {
                return false;
            }
            uri = ear.getWebModuleUri(webApp);
        } else {
            String sourceProjectName = template.getPropertyValue("sourceProject");
            if (sourceProjectName == null) {
                return false;
            }
            IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject(sourceProjectName);
            if (sourceProject == null || !sourceProject.isAccessible()) {
                return false;
            }
            String fileName = template.getPropertyValue("$file");
            if (fileName == null) {
                return false;
            }
            IFile file = sourceProject.getFile(fileName);
            if (file == null || !file.isAccessible()) {
                return false;
            }
            WebAppProject webAppProject = WebAppProject.getInstance((IProject)sourceProject);
            if (webAppProject == null) {
                return false;
            }
            WebApp webApp = webAppProject.getWebApp(file);
            if (webApp == null || !webApp.isValid()) {
                return false;
            }
        }
        String altDd = template.getPropertyValue("altDd");
        String contextRoot = template.getPropertyValue("contextRoot");
        if (contextRoot == null) {
            contextRoot = "";
        }
        return ear.canCreateWebModule(uri, altDd, contextRoot);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        WebModule module;
        UniqueName sourceUin;
        Model sourceModel;
        String uri;
        if (template == null || !this.canCreateUniqueName(parent, shapeType, template)) {
            return null;
        }
        Ear ear = EarModelAccess.getEar(this.getModel(), parent.getUniqueName());
        if (!ear.ensureSaved(true)) {
            return null;
        }
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if ((uri = template.getPropertyValue("$name")) == null) {
            Entity webAppEntity = EarModelMetaInfo.getModuleSource(template);
            WebApp webApp = WebAppModelAccess.getWebApp((Model)webAppEntity.getModel(), (UniqueName)webAppEntity.getUniqueName());
            uri = ear.getWebModuleUri(webApp);
            sourceModel = webAppEntity.getModel();
            sourceUin = webAppEntity.getUniqueName();
        } else {
            String sourceProjectName = template.getPropertyValue("sourceProject");
            IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject(sourceProjectName);
            String fileName = template.getPropertyValue("$file");
            IFile file = sourceProject.getFile(fileName);
            sourceModel = ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((String)sourceProjectName));
            sourceUin = WebAppModelMetaInfo.getWebApp((IFile)file);
        }
        String altDd = template.getPropertyValue("altDd");
        String contextRoot = template.getPropertyValue("contextRoot");
        if (contextRoot == null) {
            contextRoot = "";
        }
        if ((module = ear.createWebModule(uri, altDd, contextRoot)) == null) {
            return null;
        }
        return EarModelMetaInfo.getModule(sourceModel, sourceUin, parent.getUniqueName(), module.getUri());
    }

    public boolean canDelete(Element element) {
        WebModule module = EarModelAccess.getWebModule(this.getModel(), element.getUniqueName());
        return module != null && module.canDelete();
    }

    public void delete(Element element) {
        Ear ear = EarModelAccess.getEar(this.getModel(), element.getParent().getUniqueName());
        if (!ear.ensureSaved(true)) {
            return;
        }
        WebModule module = EarModelAccess.getWebModule(this.getModel(), element.getUniqueName());
        module.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return EarModelMetaInfo.isEar(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        Ear ear = EarModelAccess.getEar(this.getModel(), parent.getUniqueName());
        if (ear == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        WebModule[] modules = ear.getWebModules();
        if (modules == null || modules.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(modules.length);
        int i = 0;
        while (i < modules.length) {
            WebModule module = modules[i];
            WebApp webApp = module.getReferencedWebApp();
            if (webApp != null) {
                UniqueName source = WebAppModelMetaInfo.getWebApp((IFile)webApp.getFile());
                IProject webAppProject = webApp.getFile().getProject();
                Model sourceModel = ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((String)webAppProject.getName()));
                if (sourceModel.findEntity(source) == null) {
                    EarProvidersPlugin.logWarning("Web app [" + webApp.getFile() + "] not found");
                } else {
                    UniqueName uin = EarModelMetaInfo.getModule(sourceModel, source, parent.getUniqueName(), module.getUri());
                    ProxyMetaInfo.bind((UniqueName)uin, (UniqueName)this.getModel().getUniqueName());
                    module.setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
                    uins.add(uin);
                }
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

