/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import java.util.List;

public class TemplatePropertyProvider
extends AbstractProvider
implements PropertyGetProvider {
    private static final List ourSecurityRoleProperties = new ArrayList();
    private static final List ourEjbModuleProperties;
    private static final List ourWebModuleProperties;

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (!"$templateProperties".equals(propertyName)) {
            return false;
        }
        if (EarModelMetaInfo.isSecurityRole(element.getUniqueName())) {
            return true;
        }
        if (EarModelMetaInfo.isEjbModule(element.getUniqueName())) {
            return true;
        }
        return EarModelMetaInfo.isWebModule(element.getUniqueName());
    }

    public boolean hasProperty(Element element, String propertyName) {
        return false;
    }

    public Property getProperty(Element element, String propertyName) {
        return null;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public String getPropertyValue(Element element, String propertyName) {
        return null;
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return this.properties(element);
    }

    public PropertyEnumeration properties(Element element) {
        if (EarModelMetaInfo.isSecurityRole(element.getUniqueName())) {
            return EnumerationConverter.toPropertyEnumeration(ourSecurityRoleProperties.iterator());
        }
        if (EarModelMetaInfo.isEjbModule(element.getUniqueName())) {
            return EnumerationConverter.toPropertyEnumeration(ourEjbModuleProperties.iterator());
        }
        if (EarModelMetaInfo.isWebModule(element.getUniqueName())) {
            return EnumerationConverter.toPropertyEnumeration(ourWebModuleProperties.iterator());
        }
        return EmptyEnumeration.getPropertyEnumeration();
    }

    private static Property createTemplateProperty(String value) {
        return new PropertyAdapter("$templateProperties", value, null);
    }

    static {
        ourSecurityRoleProperties.add(TemplatePropertyProvider.createTemplateProperty("$name"));
        ourSecurityRoleProperties.add(TemplatePropertyProvider.createTemplateProperty("$metaclass"));
        ourSecurityRoleProperties.add(TemplatePropertyProvider.createTemplateProperty("description"));
        ourEjbModuleProperties = new ArrayList();
        ourEjbModuleProperties.add(TemplatePropertyProvider.createTemplateProperty("$metaclass"));
        ourEjbModuleProperties.add(TemplatePropertyProvider.createTemplateProperty("altDd"));
        ourWebModuleProperties = new ArrayList();
        ourWebModuleProperties.add(TemplatePropertyProvider.createTemplateProperty("$metaclass"));
        ourWebModuleProperties.add(TemplatePropertyProvider.createTemplateProperty("altDd"));
        ourWebModuleProperties.add(TemplatePropertyProvider.createTemplateProperty("contextRoot"));
    }
}

