/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.namegen.SecurityRoleNameGen;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ear.EarModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;

public final class SecurityRoleProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EarModelMetaInfo.isSecurityRole(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return EarModelAccess.getSecurityRole(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!EarModelMetaInfo.isSecurityRole(uin)) {
            return false;
        }
        return EarModelAccess.getSecurityRole(this.getModel(), uin) != null;
    }

    private String genName(Ear ear, String name) {
        SecurityRoleNameGen gen = new SecurityRoleNameGen(ear);
        return gen.getUniqueName(name == null ? "role1" : name);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String name;
        if (!"com.tssap.j2ee.core.ear.SecurityRole".equals(shapeType)) {
            return false;
        }
        if (!EarModelMetaInfo.isEar(parent.getUniqueName())) {
            return false;
        }
        Ear ear = EarModelAccess.getEar(this.getModel(), parent.getUniqueName());
        if (ear == null) {
            return false;
        }
        if (template == null) {
            name = this.genName(ear, null);
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(ear, template.getPropertyValue("$name"));
            description = template.getPropertyValue("description");
        }
        return ear.canCreateSecurityRole(name, description);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String description;
        String name;
        Ear ear = EarModelAccess.getEar(this.getModel(), parent.getUniqueName());
        if (template == null) {
            name = this.genName(ear, null);
            description = null;
        } else {
            Object source = template.getObjectPropertyValue("$elementToClone");
            if (source instanceof Entity) {
                template = (Entity)source;
            }
            name = this.genName(ear, template.getPropertyValue("$name"));
            description = template.getPropertyValue("description");
        }
        SecurityRole role = ear.createSecurityRole(name, description);
        if (role == null) {
            return null;
        }
        return EarModelMetaInfo.getSecurityRole(ear.getFile(), role.getName());
    }

    public boolean canDelete(Element element) {
        SecurityRole role = EarModelAccess.getSecurityRole(this.getModel(), element.getUniqueName());
        return role != null && role.canDelete();
    }

    public void delete(Element element) {
        SecurityRole role = EarModelAccess.getSecurityRole(this.getModel(), element.getUniqueName());
        role.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return EarModelMetaInfo.isEar(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        Ear ear = EarModelAccess.getEar(this.getModel(), parent.getUniqueName());
        if (ear == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        SecurityRole[] roles = ear.getSecurityRoles();
        if (roles == null || roles.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(roles.length);
        int i = 0;
        while (i < roles.length) {
            UniqueName uin = EarModelMetaInfo.getSecurityRole(ear.getFile(), roles[i].getName());
            roles[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

