/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.ear.EjbModule;
import com.tssap.j2ee.core.ear.Module;
import com.tssap.j2ee.core.ear.WebModule;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.ear.EarModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.extension.AbstractPropertyWriter;

public final class ModulePropertyProvider
extends AbstractPropertyWriter {
    public ModulePropertyProvider() {
        this.getPropertyNames().add("$file");
        this.getPropertyNames().add("$enableGenericCopy");
        this.getPropertyNames().add("$enableGenericCut");
        this.getPropertyNames().add("deployed");
        this.getPropertyNames().add("sourceProject");
        this.getPropertyNames().add("id");
        this.getPropertyNames().add("altDd");
    }

    private boolean isValidType(Element element) {
        if (EarModelMetaInfo.isEjbModule(element.getUniqueName())) {
            return true;
        }
        return EarModelMetaInfo.isWebModule(element.getUniqueName());
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (!this.isValidType(element)) {
            return false;
        }
        return this.getPropertyNames().contains(propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        Module module = this.getModule(element.getUniqueName());
        if (module == null) {
            return null;
        }
        if ("$enableGenericCopy".equals(propertyName)) {
            return Boolean.TRUE.toString();
        }
        if ("$enableGenericCut".equals(propertyName)) {
            return Boolean.TRUE.toString();
        }
        if ("deployed".equals(propertyName)) {
            return Boolean.TRUE.toString();
        }
        if ("sourceProject".equals(propertyName)) {
            if (module instanceof EjbModule) {
                EjbJar ejbJar = ((EjbModule)module).getReferencedEjbJar();
                if (ejbJar == null || !ejbJar.isValid()) {
                    return null;
                }
                return ejbJar.getFile().getProject().getName();
            }
            if (module instanceof WebModule) {
                WebApp webApp = ((WebModule)module).getReferencedWebApp();
                if (webApp == null || !webApp.isValid()) {
                    return null;
                }
                return webApp.getFile().getProject().getName();
            }
            return null;
        }
        if ("id".equals(propertyName)) {
            return module.getId();
        }
        if ("altDd".equals(propertyName)) {
            return module.getAltDd();
        }
        if ("$file".equals(propertyName)) {
            Entity parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return parent.getUniqueName().getLocation();
        }
        return this.unknownProperty(propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        Module module = this.getModule(element.getUniqueName());
        if (module == null) {
            return false;
        }
        if ("id".equals(propertyName)) {
            return module.canSetId(propertyValue);
        }
        if ("altDd".equals(propertyName)) {
            return module.canSetAltDd(propertyValue);
        }
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        Module module = this.getModule(element.getUniqueName());
        if ("id".equals(propertyName)) {
            module.setId(propertyValue);
            return;
        }
        if ("altDd".equals(propertyName)) {
            module.setAltDd(propertyValue);
            return;
        }
        this.unknownProperty(propertyName);
    }

    private Module getModule(UniqueName uin) {
        if (EarModelMetaInfo.isEjbModule(uin)) {
            return EarModelAccess.getEjbModule(this.getModel(), uin);
        }
        if (EarModelMetaInfo.isWebModule(uin)) {
            return EarModelAccess.getWebModule(this.getModel(), uin);
        }
        return null;
    }
}

