/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.EarProject;
import com.tssap.j2ee.core.ear.EjbModule;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.internal.core.providers.ear.EarProvidersPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.providers.proxy.ProxyRule;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class EjbModuleProxyRule
implements ProxyRule {
    public UniqueNameEnumeration getProxies(Model proxyModel, Model sourceModel, UniqueName source) {
        if (!EjbJarModelMetaInfo.isEjbJar((UniqueName)source)) {
            return null;
        }
        String fileName = EjbJarModelMetaInfo.getEjbJarFileName((UniqueName)source);
        if (fileName == null || fileName.trim().length() == 0) {
            EarProvidersPlugin.logWarning("Invalid ejb jar encountered [" + source + "] in model [" + sourceModel + "]");
            return null;
        }
        IProject sourceProject = ModelUinSupport.getProject((UniqueName)sourceModel.getUniqueName());
        if (sourceProject == null) {
            return null;
        }
        EjbJarProject ejbJarProject = EjbJarProject.getInstance((IProject)sourceProject);
        if (ejbJarProject == null) {
            return null;
        }
        IProject proxyProject = ModelUinSupport.getProject((UniqueName)proxyModel.getUniqueName());
        if (proxyProject == null) {
            return null;
        }
        EarProject earProject = EarProject.getInstance((IProject)proxyProject);
        if (earProject == null) {
            return null;
        }
        Ear[] ears = earProject.getEars();
        if (ears == null || ears.length == 0) {
            return null;
        }
        if (!UtilsPlugin.references((IProject)proxyProject, (IProject)sourceProject)) {
            return null;
        }
        ArrayList uins = new ArrayList();
        int i = 0;
        while (i < ears.length) {
            this.addProxies(uins, ears[i], sourceProject, fileName, sourceModel, source);
            ++i;
        }
        if (uins.isEmpty()) {
            return null;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }

    public void addProxies(List uins, Ear ear, IProject ejbJarProject, String fileName, Model ejbJarModel, UniqueName ejbJarUin) {
        EjbModule[] ejbModules = ear.getEjbModules();
        if (ejbModules == null || ejbModules.length == 0) {
            return;
        }
        UniqueName earUin = null;
        int i = 0;
        while (i < ejbModules.length) {
            IProject ejbJarProjectRef;
            EjbJar ejbJar;
            EjbModule ejbModule = ejbModules[i];
            if (ejbModule != null && (ejbJar = ejbModule.getReferencedEjbJar()) != null && ejbJar.isValid() && fileName.equals(ejbJar.getFile().getProjectRelativePath().toString()) && (ejbJarProjectRef = ejbJar.getFile().getProject()) != null && ejbJarProjectRef.getName().equals(ejbJarProject.getName())) {
                if (earUin == null) {
                    earUin = EarModelMetaInfo.getEar(ear.getFile());
                }
                UniqueName proxyUin = EarModelMetaInfo.getModule(ejbJarModel, ejbJarUin, earUin, ejbModule.getUri());
                uins.add(proxyUin);
            }
            ++i;
        }
    }
}

