/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.EjbModule;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ear.EarModelAccess;
import com.tssap.j2ee.internal.core.providers.ear.EarProvidersPlugin;
import com.tssap.j2ee.internal.core.providers.ejbjar.EjbJarModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public final class EjbModuleProxyProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EarModelMetaInfo.isEjbModule(element.getUniqueName());
    }

    private boolean moduleExists(UniqueName uin) {
        EjbModule module = EarModelAccess.getEjbModule(this.getModel(), uin);
        if (module == null) {
            return false;
        }
        Model moduleRefModel = EarModelMetaInfo.getModuleModel(uin);
        if (moduleRefModel == null || moduleRefModel.isDeleted()) {
            return false;
        }
        Entity moduleRef = moduleRefModel.findEntity(EarModelMetaInfo.getModule(uin));
        if (moduleRef == null || moduleRef.isDeleted()) {
            return false;
        }
        EjbJar ejbJar = module.getReferencedEjbJar();
        if (ejbJar == null || !ejbJar.isValid()) {
            return false;
        }
        UniqueName ejbJarUin = EjbJarModelMetaInfo.getEjbJar((IFile)ejbJar.getFile());
        return moduleRef.getUniqueName().equals(ejbJarUin);
    }

    public boolean isDeleted(Element element) {
        return !this.moduleExists(element.getUniqueName());
    }

    public boolean exists(UniqueName uin) {
        if (!EarModelMetaInfo.isEjbModule(uin)) {
            return false;
        }
        return this.moduleExists(uin);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String uri;
        if (!"com.tssap.j2ee.core.ejbjar.EjbJar".equals(shapeType)) {
            return false;
        }
        if (!EarModelMetaInfo.isEar(parent.getUniqueName())) {
            return false;
        }
        Ear ear = EarModelAccess.getEar(this.getModel(), parent.getUniqueName());
        if (ear == null) {
            return false;
        }
        if (template == null) {
            return true;
        }
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if ((uri = template.getPropertyValue("$name")) == null) {
            Entity ejbJarEntity = EarModelMetaInfo.getModuleSource(template);
            if (ejbJarEntity == null || !EjbJarModelMetaInfo.isEjbJar((UniqueName)ejbJarEntity.getUniqueName())) {
                return false;
            }
            EjbJar ejbJar = EjbJarModelAccess.getEjbJar((Model)ejbJarEntity.getModel(), (UniqueName)ejbJarEntity.getUniqueName());
            if (ejbJar == null || !ejbJar.isValid()) {
                return false;
            }
            uri = ear.getEjbModuleUri(ejbJar);
        } else {
            String sourceProjectName = template.getPropertyValue("sourceProject");
            if (sourceProjectName == null) {
                return false;
            }
            IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject(sourceProjectName);
            if (sourceProject == null || !sourceProject.isAccessible()) {
                return false;
            }
            String fileName = template.getPropertyValue("$file");
            if (fileName == null) {
                return false;
            }
            IFile file = sourceProject.getFile(fileName);
            if (file == null || !file.isAccessible()) {
                return false;
            }
            EjbJarProject ejbJarProject = EjbJarProject.getInstance((IProject)sourceProject);
            if (ejbJarProject == null) {
                return false;
            }
            EjbJar ejbJar = ejbJarProject.getEjbJar(file);
            if (ejbJar == null || !ejbJar.isValid()) {
                return false;
            }
        }
        String altDd = template.getPropertyValue("altDd");
        return ear.canCreateEjbModule(uri, altDd);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName sourceUin;
        Model sourceModel;
        String uri;
        if (template == null || !this.canCreateUniqueName(parent, shapeType, template)) {
            return null;
        }
        Ear ear = EarModelAccess.getEar(this.getModel(), parent.getUniqueName());
        if (!ear.ensureSaved(true)) {
            return null;
        }
        Object source = template.getObjectPropertyValue("$elementToClone");
        if (source instanceof Entity) {
            template = (Entity)source;
        }
        if ((uri = template.getPropertyValue("$name")) == null) {
            Entity ejbJarEntity = EarModelMetaInfo.getModuleSource(template);
            EjbJar ejbJar = EjbJarModelAccess.getEjbJar((Model)ejbJarEntity.getModel(), (UniqueName)ejbJarEntity.getUniqueName());
            uri = ear.getEjbModuleUri(ejbJar);
            sourceModel = ejbJarEntity.getModel();
            sourceUin = ejbJarEntity.getUniqueName();
        } else {
            String sourceProjectName = template.getPropertyValue("sourceProject");
            IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject(sourceProjectName);
            String fileName = template.getPropertyValue("$file");
            IFile file = sourceProject.getFile(fileName);
            sourceModel = ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((String)sourceProjectName));
            sourceUin = EjbJarModelMetaInfo.getEjbJar((IFile)file);
        }
        String altDd = template.getPropertyValue("altDd");
        EjbModule module = ear.createEjbModule(uri, altDd);
        if (module == null) {
            return null;
        }
        return EarModelMetaInfo.getModule(sourceModel, sourceUin, parent.getUniqueName(), module.getUri());
    }

    public boolean canDelete(Element element) {
        EjbModule module = EarModelAccess.getEjbModule(this.getModel(), element.getUniqueName());
        return module != null && module.canDelete();
    }

    public void delete(Element element) {
        Ear ear = EarModelAccess.getEar(this.getModel(), element.getParent().getUniqueName());
        if (!ear.ensureSaved(true)) {
            return;
        }
        EjbModule module = EarModelAccess.getEjbModule(this.getModel(), element.getUniqueName());
        module.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return EarModelMetaInfo.isEar(parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        Ear ear = EarModelAccess.getEar(this.getModel(), parent.getUniqueName());
        if (ear == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        EjbModule[] modules = ear.getEjbModules();
        if (modules == null || modules.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(modules.length);
        int i = 0;
        while (i < modules.length) {
            EjbModule module = modules[i];
            EjbJar ejbJar = module.getReferencedEjbJar();
            if (ejbJar != null) {
                UniqueName source = EjbJarModelMetaInfo.getEjbJar((IFile)ejbJar.getFile());
                IProject ejbJarProject = ejbJar.getFile().getProject();
                Model sourceModel = ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((String)ejbJarProject.getName()));
                if (sourceModel.findEntity(source) == null) {
                    EarProvidersPlugin.logWarning("Ejb jar [" + ejbJar.getFile() + "] not found");
                } else {
                    UniqueName uin = EarModelMetaInfo.getModule(sourceModel, source, parent.getUniqueName(), module.getUri());
                    ProxyMetaInfo.bind((UniqueName)uin, (UniqueName)this.getModel().getUniqueName());
                    module.setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
                    uins.add(uin);
                }
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

