/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.EjbModule;
import com.tssap.j2ee.core.ear.WebModule;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.ear.EarModelAccess;
import com.tssap.selena.model.elements.UniqueName;

public class EarUinSupport {
    private EarUinSupport() {
    }

    public static UniqueName getUniqueName(DescriptorEntity entity) {
        if (entity instanceof Ear) {
            return EarUinSupport.getUniqueName((Ear)entity);
        }
        if (entity instanceof SecurityRole) {
            return EarUinSupport.getUniqueName((SecurityRole)entity);
        }
        if (entity instanceof EjbModule) {
            return EarUinSupport.getUniqueName((EjbModule)entity);
        }
        if (entity instanceof WebModule) {
            return EarUinSupport.getUniqueName((WebModule)entity);
        }
        return null;
    }

    public static UniqueName getUniqueName(Ear entity) {
        return EarModelMetaInfo.getEar(entity.getFile());
    }

    public static UniqueName getUniqueName(SecurityRole entity) {
        Ear ear = (Ear)entity.getParent();
        if (ear == null) {
            return null;
        }
        return EarModelMetaInfo.getSecurityRole(ear.getFile(), entity.getName());
    }

    public static UniqueName getUniqueName(EjbModule entity) {
        Ear ear = (Ear)entity.getParent();
        if (ear == null) {
            return null;
        }
        UniqueName earUin = EarModelMetaInfo.getEar(ear.getFile());
        EjbJar moduleRef = entity.getReferencedEjbJar();
        if (moduleRef == null) {
            return null;
        }
        return EarModelAccess.getEjbModuleUniqueName(moduleRef, entity.getUri(), earUin, true);
    }

    public static UniqueName getUniqueName(WebModule entity) {
        Ear ear = (Ear)entity.getParent();
        if (ear == null) {
            return null;
        }
        UniqueName earUin = EarModelMetaInfo.getEar(ear.getFile());
        WebApp moduleRef = entity.getReferencedWebApp();
        if (moduleRef == null) {
            return null;
        }
        return EarModelAccess.getWebModuleUniqueName(moduleRef, entity.getUri(), earUin, true);
    }
}

