/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class EarProvidersPlugin
extends Plugin {
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private static EarProvidersPlugin ourInstance;

    public EarProvidersPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
        this.myDebuggingDelta = UtilsPlugin.getDeltaDebugOption((IPluginDescriptor)descriptor);
    }

    public static EarProvidersPlugin getDefault() {
        return ourInstance;
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        EarProvidersPlugin instance = EarProvidersPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        EarProvidersPlugin.log(1, text);
    }

    public static void logError(String text) {
        EarProvidersPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        EarProvidersPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        EarProvidersPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        EarProvidersPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        EarProvidersPlugin instance = EarProvidersPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            EarProvidersPlugin.log(type, text, new Throwable());
        } else {
            EarProvidersPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        EarProvidersPlugin instance = EarProvidersPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

