/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.EarProject;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.internal.core.descriptor.AbstractDeltaProvider;
import com.tssap.j2ee.internal.core.providers.ear.EarModelAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ExistenceProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public final class EarProvider
extends AbstractProvider
implements EntityExistenceProvider,
ExistenceProviderEx,
ChildrenProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return EarModelMetaInfo.isEar(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return EarModelAccess.getEar(this.getModel(), element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uin) {
        if (!EarModelMetaInfo.isEar(uin)) {
            return false;
        }
        return EarModelAccess.getEar(this.getModel(), uin) != null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!"com.tssap.j2ee.core.ear.EnterpriseApp".equals(shapeType)) {
            return false;
        }
        if (!ModelUinSupport.isModelUin((UniqueName)parent.getUniqueName())) {
            return false;
        }
        if (!template.hasProperty("$file")) {
            return false;
        }
        String fileName = template.getPropertyValue("$file");
        if (!fileName.endsWith("application.xml")) {
            return false;
        }
        IFile file = this.getProject().getFile(fileName);
        if (file.exists()) {
            return false;
        }
        IContainer container = file.getParent();
        if (!container.isAccessible()) {
            return false;
        }
        return EarModelAccess.getEar(this.getModel(), EarModelMetaInfo.getEar(file)) == null;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        IFile file = this.getProject().getFile(template.getPropertyValue("$file"));
        EarProject.getInstance((IProject)this.getProject()).createEar(file);
        return EarModelMetaInfo.getEar(file);
    }

    public boolean canDelete(Element element) {
        Ear ear = EarModelAccess.getEar(this.getModel(), element.getUniqueName());
        return ear != null && ear.canDelete();
    }

    public void delete(Element element) {
        Ear ear = EarModelAccess.getEar(this.getModel(), element.getUniqueName());
        ear.delete();
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return ModelUinSupport.isModelUin((UniqueName)parent.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        EarProject earProject = EarProject.getInstance((IProject)this.getProject());
        if (earProject == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        Ear[] ears = earProject.getEars();
        if (ears == null || ears.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>(ears.length);
        int i = 0;
        while (i < ears.length) {
            UniqueName uin = EarModelMetaInfo.getEar(ears[i].getFile());
            ears[i].setUserData(AbstractDeltaProvider.DELTA_KEY, (Object)uin);
            uins.add(uin);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(uins.iterator());
    }
}

