/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ear;

import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.EarProject;
import com.tssap.j2ee.core.ear.EjbModule;
import com.tssap.j2ee.core.ear.WebModule;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.providers.ear.EarModelMetaInfo;
import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.providers.ear.EarProvidersPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class EarModelAccess {
    private EarModelAccess() {
    }

    public static Ear getEar(Model model, UniqueName uin) {
        if (model == null || model.isDeleted()) {
            return null;
        }
        IProject project = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
        if (project == null || !project.isAccessible()) {
            return null;
        }
        EarProject earProject = EarProject.getInstance((IProject)project);
        if (earProject == null) {
            return null;
        }
        IFile file = project.getFile(EarModelMetaInfo.getEarFileName(uin));
        return earProject.getEar(file);
    }

    public static SecurityRole getSecurityRole(Model model, UniqueName uin) {
        Ear ear = EarModelAccess.getEar(model, uin);
        if (ear == null) {
            return null;
        }
        return ear.getSecurityRole(EarModelMetaInfo.getSecurityRoleName(uin));
    }

    public static EjbModule getEjbModule(Model model, UniqueName uin) {
        Ear ear = EarModelAccess.getEar(model, EarModelMetaInfo.getEarOfModule(uin));
        if (ear == null) {
            return null;
        }
        return ear.getEjbModule(EarModelMetaInfo.getModuleUri(uin));
    }

    public static WebModule getWebModule(Model model, UniqueName uin) {
        Ear ear = EarModelAccess.getEar(model, EarModelMetaInfo.getEarOfModule(uin));
        if (ear == null) {
            return null;
        }
        return ear.getWebModule(EarModelMetaInfo.getModuleUri(uin));
    }

    public static UniqueName getEjbModuleUniqueName(EjbJar moduleRef, String uri, UniqueName earUin) {
        return EarModelAccess.getEjbModuleUniqueName(moduleRef, uri, earUin, false);
    }

    public static UniqueName getEjbModuleUniqueName(EjbJar moduleRef, String uri, UniqueName earUin, boolean acceptNonExistent) {
        UniqueName source = EjbJarModelMetaInfo.getEjbJar((IFile)moduleRef.getFile());
        IProject ejbJarProject = moduleRef.getFile().getProject();
        if (ejbJarProject == null) {
            return null;
        }
        UniqueName sourceModel = ModelUinSupport.createModelUin((String)ejbJarProject.getName());
        if (!acceptNonExistent && ModelAccess.getModel((UniqueName)sourceModel).findEntity(source) == null) {
            EarProvidersPlugin.logWarning("Ejb jar [" + moduleRef.getFile() + "] is not provided in the model");
            return null;
        }
        return EarModelMetaInfo.getModule(ModelAccess.getModel((UniqueName)sourceModel), source, earUin, uri);
    }

    public static UniqueName getWebModuleUniqueName(WebApp moduleRef, String uri, UniqueName earUin) {
        return EarModelAccess.getWebModuleUniqueName(moduleRef, uri, earUin, false);
    }

    public static UniqueName getWebModuleUniqueName(WebApp moduleRef, String uri, UniqueName earUin, boolean acceptNonExistent) {
        UniqueName source = WebAppModelMetaInfo.getWebApp((IFile)moduleRef.getFile());
        IProject webAppProject = moduleRef.getFile().getProject();
        if (webAppProject == null) {
            return null;
        }
        UniqueName sourceModel = ModelUinSupport.createModelUin((String)webAppProject.getName());
        if (!acceptNonExistent && ModelAccess.getModel((UniqueName)sourceModel).findEntity(source) == null) {
            EarProvidersPlugin.logWarning("Web app [" + moduleRef.getFile() + "] is not provided in the model");
            return null;
        }
        return EarModelMetaInfo.getModule(ModelAccess.getModel((UniqueName)sourceModel), source, earUin, uri);
    }
}

