/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.providers.ear;

import com.tssap.j2ee.core.providers.ejbjar.EjbJarModelMetaInfo;
import com.tssap.j2ee.core.providers.webapp.WebAppModelMetaInfo;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.UinEscaper;
import org.eclipse.core.resources.IFile;

public class EarModelMetaInfo {
    public static final String EAR_NATURE_ID = "com.tssap.j2ee.core.ear.earNature";
    public static final String DOMAIN = "com.tssap.j2ee.core.ear";
    public static final String EAR_FILE_NAME = "application.xml";
    public static final String DIAGRAM_METACLASS = "EARDiagram";
    public static final String EAR_METACLASS = "com.tssap.j2ee.core.ear.EnterpriseApp";
    public static final String SECURITY_ROLE_METACLASS = "com.tssap.j2ee.core.ear.SecurityRole";
    public static final String EAR_SECURITY_ROLE_METACLASS = "com.tssap.j2ee.core.ear.SecurityRole";
    public static final String EJB_JAR_METACLASS = "com.tssap.j2ee.core.ejbjar.EjbJar";
    public static final String WEB_APP_METACLASS = "com.tssap.j2ee.core.webapp.WebApp";
    public static final String WAR_METACLASS = "com.tssap.j2ee.core.webapp.WebApp";
    public static final String ALT_DD_PROPERTY = "altDd";
    public static final String CONTEXT_ROOT_PROPERTY = "contextRoot";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String DISPLAY_NAME_PROPERTY = "displayName";
    public static final String ID_PROPERTY = "id";
    public static final String LARGE_ICON_PROPERTY = "largeIcon";
    public static final String SMALL_ICON_PROPERTY = "smallIcon";
    public static final String SPEC_VERSION_PROPERTY = "specVersion";
    public static final String URI = "$name";
    public static final String INVALID_PROPERTY = "invalid";
    public static final String DEPLOYED_PROPERTY = "deployed";
    public static final String SOURCE_PROJECT_PROPERTY = "sourceProject";
    public static final String MODULE_PROJECT = "sourceProject";
    public static final String DESCRIBED_PROPERTY = "described";
    private static final String SOURCE_MODULE = "sourceModule";

    private EarModelMetaInfo() {
    }

    private static String toString(IFile file) {
        return file.getProjectRelativePath().toString();
    }

    private static UniqueName createUniqueName(String metaclass, IFile file, String name, String[] parameters) {
        String fileName = UinEscaper.escape((String)EarModelMetaInfo.toString(file));
        return ModelAccess.createUniqueName((String)DOMAIN, (String)metaclass, (String)fileName, (String)name, (String[])parameters);
    }

    private static UniqueName createUniqueName(String metaclass, IFile file, String name) {
        return EarModelMetaInfo.createUniqueName(metaclass, file, name, null);
    }

    private static boolean isValidType(UniqueName uin, String subdomain) {
        return DOMAIN.equals(uin.getDomain()) && subdomain.equals(uin.getSubDomain());
    }

    public static String getEarFileName(UniqueName uin) {
        return UinEscaper.unescape((String)uin.getLocation());
    }

    public static UniqueName getEar(IFile file) {
        String fileName = EarModelMetaInfo.toString(file);
        return EarModelMetaInfo.createUniqueName(EAR_METACLASS, file, fileName);
    }

    public static boolean isEar(UniqueName uin) {
        return EarModelMetaInfo.isValidType(uin, EAR_METACLASS);
    }

    public static boolean isEAR(UniqueName uniqueName) {
        return EarModelMetaInfo.isEar(uniqueName);
    }

    public static UniqueName getSecurityRole(IFile file, String name) {
        name = UinEscaper.escape((String)name);
        return EarModelMetaInfo.createUniqueName("com.tssap.j2ee.core.ear.SecurityRole", file, name, null);
    }

    public static boolean isSecurityRole(UniqueName uin) {
        return EarModelMetaInfo.isValidType(uin, "com.tssap.j2ee.core.ear.SecurityRole");
    }

    public static String getSecurityRoleName(UniqueName uin) {
        return UinEscaper.unescape((String)uin.getName());
    }

    public static UniqueName getModule(Model moduleModel, UniqueName moduleUin, UniqueName earUin, String uri) {
        uri = UinEscaper.escape((String)uri);
        return ProxyMetaInfo.getProxyUniqueName((UniqueName)earUin, (UniqueName)moduleModel.getUniqueName(), (UniqueName)moduleUin, (String[])new String[]{uri});
    }

    private static UniqueName getModuleSource(UniqueName uin) {
        if (!ProxyMetaInfo.isProxyUniqueName((UniqueName)uin)) {
            return null;
        }
        UniqueName earUin = ProxyMetaInfo.getParentUniqueName((UniqueName)uin);
        if (!EarModelMetaInfo.isEar(earUin)) {
            return null;
        }
        if (ProxyMetaInfo.getParametersCount((UniqueName)uin) < 1) {
            return null;
        }
        String uri = ProxyMetaInfo.getParameter((UniqueName)uin, (int)0);
        if (uri == null || uri.trim().length() == 0) {
            return null;
        }
        return ProxyMetaInfo.getSourceUniqueName((UniqueName)uin);
    }

    public static boolean isEjbModule(UniqueName uin) {
        UniqueName sourceUin = EarModelMetaInfo.getModuleSource(uin);
        if (sourceUin == null) {
            return false;
        }
        return EjbJarModelMetaInfo.isEjbJar((UniqueName)sourceUin);
    }

    public static boolean isEJBJarReference(UniqueName uniqueName) {
        return EarModelMetaInfo.isEjbModule(uniqueName);
    }

    public static boolean isWebModule(UniqueName uin) {
        UniqueName sourceUin = EarModelMetaInfo.getModuleSource(uin);
        if (sourceUin == null) {
            return false;
        }
        return WebAppModelMetaInfo.isWebApp((UniqueName)sourceUin);
    }

    public static boolean isWebAppReference(UniqueName uniqueName) {
        return EarModelMetaInfo.isWebModule(uniqueName);
    }

    public static UniqueName getEarOfModule(UniqueName moduleUin) {
        return ProxyMetaInfo.getParentUniqueName((UniqueName)moduleUin);
    }

    public static UniqueName getModule(UniqueName moduleUin) {
        return ProxyMetaInfo.getSourceUniqueName((UniqueName)moduleUin);
    }

    public static Model getModuleModel(UniqueName moduleUin) {
        return ProxyMetaInfo.getSourceModel((UniqueName)moduleUin);
    }

    public static String getModuleUri(UniqueName moduleUin) {
        return UinEscaper.unescape((String)ProxyMetaInfo.getParameter((UniqueName)moduleUin, (int)0));
    }

    public static Entity getModuleSource(Entity template) {
        return (Entity)template.getObjectPropertyValue(SOURCE_MODULE);
    }

    public static void setModuleSource(Entity template, Entity module) {
        template.setObjectPropertyValue(SOURCE_MODULE, (Object)module);
    }

    public static boolean addModuleReference(ReferenceCollection ear, Entity module, Entity template) {
        Entity parent = ear.getParent();
        template.setObjectPropertyValue(SOURCE_MODULE, (Object)module);
        Entity child = parent.createChildEntity(module.getPropertyValue("$metaclass"), template);
        return child != null && !child.isDeleted();
    }

    public static Entity addModuleReference(Entity ear, Entity module, Entity template) {
        template.setObjectPropertyValue(SOURCE_MODULE, (Object)module);
        return ear.createChildEntity(module.getPropertyValue("$metaclass"), template);
    }

    public static ReferenceCollection getAssociatedReferenceCollection(Entity ear) {
        String diagramUin;
        if (ProxyMetaInfo.isProxyUniqueName((UniqueName)ear.getUniqueName())) {
            ear = ProxyMetaInfo.getSourceEntity((UniqueName)ear.getUniqueName());
        }
        if ((diagramUin = ear.getPropertyValue("DiagramUIN")) == null) {
            return null;
        }
        UniqueName uin = ModelAccess.createUniqueName((String)diagramUin);
        return ear.getModel().findReferenceCollection(uin);
    }

    public static UniqueName getModule(Entity ear, String uri) {
        if (uri == null || uri.trim().length() == 0) {
            return null;
        }
        EntityEnumeration children = ear.childEntities();
        while (children.hasMoreElements()) {
            UniqueName next = children.next().getUniqueName();
            if (!EarModelMetaInfo.isEjbModule(next) && !EarModelMetaInfo.isWebModule(next) || !uri.equals(EarModelMetaInfo.getModuleUri(next))) continue;
            return next;
        }
        return null;
    }
}

