/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CharDataGenerator;
import org.apache.jasper.compiler.CommentGenerator;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JspLineMap;
import org.apache.jasper.compiler.JspLineMapItem;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServletWriter;

public class JakartaCommentGenerator
implements CommentGenerator {
    JspLineMapItem lineMapItem;

    public void generateStartComment(Generator generator, ServletWriter out, Mark start, Mark stop) throws JasperException {
        String html = "";
        if (generator instanceof CharDataGenerator) {
            html = "// HTML ";
        }
        if (start != null && stop != null) {
            if (start.fileid == stop.fileid) {
                String fileName = out.quoteString(start.getFile());
                out.println(html + "// begin [file=" + fileName + ";from=" + start.toShortString() + ";to=" + stop.toShortString() + "]");
            } else {
                out.println(html + "// begin [from=" + start + ";to=" + stop + "]");
            }
        } else {
            out.println(html + "// begin");
        }
        this.lineMapItem = new JspLineMapItem();
        this.lineMapItem.setBeginServletLnr(out.getJavaLine());
        out.pushIndent();
    }

    public void generateEndComment(Generator generator, ServletWriter out, Mark start, Mark stop) throws JasperException {
        out.popIndent();
        out.println("// end");
        JspLineMap myLineMap = out.getLineMap();
        this.lineMapItem.setEndServletLnr(out.getJavaLine());
        this.lineMapItem.setStartJspFileNr(myLineMap.addFileName(start.getSystemId()));
        this.lineMapItem.setBeginJspLnr(start.getLineNumber() + 1);
        this.lineMapItem.setBeginJspColNr(start.getColumnNumber() + 1);
        this.lineMapItem.setStopJspFileNr(myLineMap.addFileName(stop.getSystemId()));
        this.lineMapItem.setEndJspLnr(stop.getLineNumber() + 1);
        this.lineMapItem.setEndJspColNr(stop.getColumnNumber() + 1);
        myLineMap.add(this.lineMapItem);
    }

    private String toShortString(Mark mark) {
        return "(" + mark.getLineNumber() + "," + mark.getColumnNumber() + ")";
    }

    private String toString(Mark mark) {
        return mark.getSystemId() + "(" + mark.getLineNumber() + "," + mark.getColumnNumber() + ")";
    }
}

