/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Map;
import java.util.Stack;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;

public class ExecutionContext {
    private int m_maxFieldSize = 0;
    private int m_maxRows = 0;
    private int m_queryTimeout = 0;
    private int m_updateCount = -2;
    private SQLWarning m_warnings = null;
    private int m_fetchDirection = 4;
    private int m_fetchSize = 0;
    private StatementStack m_statementStack = new StatementStack();
    public static final int QUERY_COUNT = -1;
    public static final int EXCEPTION_COUNT = -2;
    public static final int ADD_BATCH_COUNT = -3;
    public static final int EXEC_BATCH_COUNT = -5;
    public static final int NEW_BATCH_COUNT = -6;
    public static final int UNLIMITED_BATCH = -7;
    public static final int AUTO_BATCH = -8;
    private boolean m_doBatch = false;
    private int m_batchLimit = -7;
    private BatchContext m_bCtx;
    private int[] m_batchUpdateCounts = null;
    private int m_currentBatchSize = 0;
    private static final boolean DEBUG = false;

    public int getFetchDirection() throws SQLException {
        return this.m_fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 || rows > this.getMaxRows()) {
            throw new SQLException(new IllegalArgumentException(rows + "").getMessage());
        }
        this.m_fetchSize = rows;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 4 && direction != 5 && direction != 6) {
            throw new SQLException(new IllegalArgumentException(direction + "").getMessage());
        }
        this.m_fetchDirection = direction;
    }

    public synchronized void setBatching(boolean doBatch) {
        this.m_doBatch = doBatch;
        if (!doBatch) {
            this.m_currentBatchSize = 0;
            this.m_bCtx = null;
        }
    }

    public synchronized boolean isBatching() {
        return this.m_doBatch;
    }

    public void setBatchLimit(int batchLimit) {
        this.m_batchLimit = batchLimit < 0 ? -7 : batchLimit;
    }

    public int getBatchLimit() {
        return this.m_batchLimit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        block6: {
            int[] nArray2;
            block5: {
                this.startExec();
                try {
                    if (this.m_bCtx != null) {
                        this.m_batchUpdateCounts = this.m_bCtx.executeBatch();
                        this.m_updateCount = -5;
                        nArray2 = this.m_batchUpdateCounts;
                        Object var3_4 = null;
                        break block5;
                    }
                    this.m_updateCount = -5;
                    nArray = null;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    this.endExec();
                    this.m_currentBatchSize = 0;
                    this.m_bCtx = null;
                    throw throwable;
                }
            }
            this.endExec();
            this.m_currentBatchSize = 0;
            this.m_bCtx = null;
            return nArray2;
        }
        Object var3_5 = null;
        this.endExec();
        this.m_currentBatchSize = 0;
        this.m_bCtx = null;
        return nArray;
    }

    public int[] getBatchUpdateCounts() {
        return this.m_batchUpdateCounts;
    }

    private boolean checkIfBatchLimitMet() {
        if (this.m_batchLimit == -7) {
            return false;
        }
        return this.m_batchLimit > 0 && this.m_currentBatchSize >= this.m_batchLimit || this.m_batchLimit == -8 && this.m_currentBatchSize >= -8;
    }

    private void implicitBatchExecute() throws SQLException {
        try {
            this.m_batchUpdateCounts = this.m_bCtx.executeBatch();
            this.m_updateCount = -5;
            Object var2_1 = null;
            this.m_currentBatchSize = 0;
            this.m_bCtx = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.m_currentBatchSize = 0;
            this.m_bCtx = null;
            throw throwable;
        }
    }

    public synchronized int getMaxFieldSize() {
        return this.m_maxFieldSize;
    }

    public synchronized void setMaxFieldSize(int max) {
        this.m_maxFieldSize = max;
    }

    public synchronized int getMaxRows() {
        return this.m_maxRows;
    }

    public synchronized void setMaxRows(int max) {
        this.m_maxRows = max;
    }

    public synchronized int getQueryTimeout() {
        return this.m_queryTimeout;
    }

    public synchronized void setQueryTimeout(int seconds) {
        this.m_queryTimeout = seconds;
    }

    public synchronized SQLWarning getWarnings() {
        return this.m_warnings;
    }

    public synchronized int getUpdateCount() {
        return this.m_updateCount;
    }

    public void cancel() throws SQLException {
        try {
            if (this.m_bCtx != null && this.m_currentBatchSize >= 1) {
                this.m_bCtx.clearBatch();
            }
            this.m_statementStack.cancelCurrent();
            Object var2_1 = null;
            if (this.m_bCtx != null && this.m_currentBatchSize >= 1) {
                this.m_currentBatchSize = 0;
                this.m_bCtx = null;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.m_bCtx != null && this.m_currentBatchSize >= 1) {
                this.m_currentBatchSize = 0;
                this.m_bCtx = null;
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RTStatement registerStatement(ConnectionContext connCtx, Object profileKey, int stmtNdx) throws SQLException {
        ConnectedProfile profile = connCtx.getConnectedProfile(profileKey);
        Map typeMap = connCtx.getTypeMap();
        RTStatement stmt = null;
        stmt = this.m_statementStack.setStatement(profile, stmtNdx, this.m_bCtx, typeMap);
        boolean wasError = true;
        try {
            if (this.m_maxRows != 0) {
                stmt.setMaxRows(this.m_maxRows);
            }
            if (this.m_maxFieldSize != 0) {
                stmt.setMaxFieldSize(this.m_maxFieldSize);
            }
            if (this.m_queryTimeout != 0) {
                stmt.setQueryTimeout(this.m_queryTimeout);
            }
            wasError = false;
            if (this.m_doBatch) {
                if (stmt.isBatchable()) {
                    if (this.m_bCtx == null) {
                        this.m_bCtx = stmt.getBatchContext();
                        this.m_currentBatchSize = 1;
                    } else if (stmt.isBatchCompatible()) {
                        ++this.m_currentBatchSize;
                    } else {
                        this.implicitBatchExecute();
                        this.m_bCtx = stmt.getBatchContext();
                        this.m_currentBatchSize = 1;
                    }
                } else {
                    if (this.m_bCtx != null && this.m_currentBatchSize >= 1) {
                        this.implicitBatchExecute();
                    }
                    this.m_bCtx = null;
                }
            }
            Object var9_8 = null;
            if (!wasError) return stmt;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!wasError) throw throwable;
            this.releaseStatement();
            throw throwable;
        }
        this.releaseStatement();
        return stmt;
    }

    public int executeUpdate() throws SQLException {
        int n;
        this.startExec();
        try {
            this.m_updateCount = this.getStatement().executeUpdate();
            if (this.m_doBatch && this.m_bCtx != null) {
                if (this.checkIfBatchLimitMet()) {
                    this.implicitBatchExecute();
                } else {
                    this.m_updateCount = this.m_currentBatchSize == 1 ? -6 : -3;
                }
            }
            n = this.m_updateCount;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endExec();
            throw throwable;
        }
        this.endExec();
        return n;
    }

    public RTResultSet executeQuery() throws SQLException {
        RTResultSet rTResultSet;
        this.startExec();
        try {
            RTResultSet rs = this.getStatement().executeQuery();
            this.m_updateCount = -1;
            rTResultSet = rs;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endExec();
            throw throwable;
        }
        this.endExec();
        return rTResultSet;
    }

    public boolean execute() throws SQLException {
        boolean bl;
        this.startExec();
        boolean ret = false;
        try {
            ret = this.getStatement().execute();
            if (this.m_doBatch && this.m_bCtx != null) {
                if (this.checkIfBatchLimitMet()) {
                    this.implicitBatchExecute();
                } else {
                    this.m_updateCount = this.m_currentBatchSize == 1 ? -6 : -3;
                }
            }
            bl = ret;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endExec();
            throw throwable;
        }
        this.endExec();
        return bl;
    }

    public synchronized ResultSet getNextResultSet() throws SQLException {
        StatementFrame stmt = this.getStatement();
        if (stmt.getStatement() != null) {
            try {
                ResultSet resultSet = stmt.getNextResultSet();
                Object var4_3 = null;
                this.m_warnings = stmt.getWarnings();
                return resultSet;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_warnings = stmt.getWarnings();
                throw throwable;
            }
        }
        return null;
    }

    public void releaseStatement() throws SQLException {
        StatementFrame stmt = this.getStatement();
        try {
            stmt.releaseStatement();
            Object var3_2 = null;
            this.m_warnings = stmt.getWarnings();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_warnings = stmt.getWarnings();
            throw throwable;
        }
    }

    private StatementFrame getStatement() {
        return this.m_statementStack.getStatement();
    }

    private void startExec() {
        this.m_statementStack.pushFrame();
    }

    private void endExec() throws SQLException {
        this.m_statementStack.popFrame();
    }

    private static void testAssertion(boolean condition) {
    }

    static /* synthetic */ void access$100(boolean x0) {
        ExecutionContext.testAssertion(x0);
    }

    private static class StatementFrame {
        RTStatement m_stmt = null;
        private int m_updateCount = 0;
        private SQLWarning m_warnings = null;
        private boolean m_executeResult = false;
        private boolean m_holdStmt = false;
        private StatementStack m_lock;
        private boolean m_pendingResults = false;

        StatementFrame(StatementStack lock) {
            this.m_lock = lock;
        }

        SQLWarning getWarnings() {
            return this.m_warnings;
        }

        int getUpdateCount() {
            return this.m_updateCount;
        }

        void cancel() throws SQLException {
            this.m_stmt.cancel();
        }

        RTStatement getStatement() {
            return this.m_stmt;
        }

        void setStatement(RTStatement stmt) {
            this.m_updateCount = -2;
            this.m_warnings = null;
            this.m_holdStmt = false;
            this.m_executeResult = false;
            this.m_stmt = stmt;
            this.m_pendingResults = false;
        }

        int executeUpdate() throws SQLException {
            this.m_updateCount = this.m_stmt.executeUpdate();
            return this.m_updateCount;
        }

        RTResultSet executeQuery() throws SQLException {
            RTResultSet result = this.m_stmt.executeRTQuery();
            this.m_updateCount = -1;
            return result;
        }

        boolean execute() throws SQLException {
            boolean hasResultSet = this.m_stmt.execute();
            while (!hasResultSet && this.m_stmt.getUpdateCount() != -1) {
                hasResultSet = this.m_stmt.getMoreResults();
            }
            this.m_holdStmt = this.m_executeResult = hasResultSet;
            this.m_updateCount = -1;
            return hasResultSet;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ResultSet getNextResultSet() throws SQLException {
            if (this.m_stmt == null) {
                return null;
            }
            boolean hasResultSet = true;
            try {
                if (this.m_executeResult) {
                    this.m_executeResult = false;
                } else {
                    while (!this.m_stmt.getMoreResults()) {
                        if (this.m_stmt.getUpdateCount() != -1) continue;
                        hasResultSet = false;
                        break;
                    }
                }
                if (hasResultSet) {
                    ResultSet result = this.m_stmt.getResultSet();
                    this.m_warnings = this.m_stmt.getWarnings();
                    return result;
                }
            }
            catch (SQLException e) {
                this.m_holdStmt = false;
                try {
                    this.releaseStatement();
                    throw e;
                }
                catch (SQLException e2) {
                    e.setNextException(e2);
                }
                throw e;
            }
            this.m_holdStmt = false;
            this.releaseStatement();
            return null;
        }

        void cleanupResults() throws SQLException {
            if (this.m_stmt != null) {
                while (this.getNextResultSet() != null) {
                }
            }
        }

        void releaseStatement() throws SQLException {
            block3: {
                if (!this.m_holdStmt) {
                    this.m_pendingResults = false;
                    RTStatement stmt = this.m_stmt;
                    this.m_lock.releaseStatement(this);
                    try {
                        this.m_warnings = stmt.getWarnings();
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        stmt.executeComplete();
                        throw throwable;
                    }
                    stmt.executeComplete();
                    {
                        break block3;
                    }
                }
                this.m_pendingResults = true;
                this.m_warnings = this.m_stmt.getWarnings();
            }
        }
    }

    private static class StatementStack {
        private int m_callDepth = 0;
        private Stack m_statementStack = new Stack();
        private StatementFrame m_stmt = new StatementFrame(this);

        private StatementStack() {
        }

        StatementFrame getStatement() {
            return this.m_stmt;
        }

        synchronized void cancelCurrent() throws SQLException {
            if (this.m_stmt.getStatement() != null) {
                this.m_stmt.cancel();
            } else if (!this.m_statementStack.empty()) {
                ((StatementFrame)this.m_statementStack.peek()).cancel();
            }
        }

        synchronized RTStatement setStatement(ConnectedProfile profile, int stmtNdx, BatchContext batch, Map typeMap) throws SQLException {
            if (this.m_statementStack.size() < this.m_callDepth) {
                this.m_statementStack.push(this.m_stmt);
                this.m_stmt = new StatementFrame(this);
            } else {
                this.m_stmt.cleanupResults();
            }
            RTStatement stmt = null;
            stmt = profile.getStatement(stmtNdx, batch, typeMap);
            this.m_stmt.setStatement(stmt);
            return stmt;
        }

        void pushFrame() {
            ++this.m_callDepth;
        }

        void popFrame() throws SQLException {
            --this.m_callDepth;
            if (this.m_statementStack.size() > this.m_callDepth) {
                this.doPopFrame();
            }
        }

        private synchronized void doPopFrame() throws SQLException {
            this.m_stmt.cleanupResults();
            this.m_stmt = (StatementFrame)this.m_statementStack.pop();
        }

        synchronized void releaseStatement(StatementFrame stmt) {
            stmt.m_stmt = null;
        }
    }
}

