/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.ref;

import com.sap.sql.sqlj.runtime.ref.RuntimeRefErrors;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import sqlj.runtime.ResultSetIterator;
import sqlj.runtime.profile.RTResultSet;

public class ResultSetIterImpl
implements ResultSetIterator {
    protected RTResultSet resultSet;

    public ResultSetIterImpl(RTResultSet rs) {
        this.resultSet = rs;
    }

    public ResultSetIterImpl(RTResultSet rs, int numColumns) throws SQLException {
        this(rs);
        try {
            ResultSetIterImpl.checkColumns(rs, numColumns);
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
    }

    public static void checkColumns(RTResultSet rs, int expectedColumns) throws SQLException {
        int rsCols = rs.getColumnCount();
        if (rsCols != expectedColumns) {
            RuntimeRefErrors.raise_WRONG_NUM_COLS(expectedColumns, rsCols);
        }
    }

    protected int findColumn(String name) throws SQLException {
        try {
            return this.resultSet.findColumn(name);
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        return this.resultSet.getJDBCResultSet();
    }

    public synchronized int getRow() throws SQLException {
        return this.getResultSet().getRow();
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.getResultSet().getFetchSize();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.getResultSet().setFetchSize(rows);
    }

    public void close() throws SQLException {
        this.resultSet.close();
    }

    public boolean isClosed() throws SQLException {
        return this.resultSet.isClosed();
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public boolean endFetch() throws SQLException {
        return !this.resultSet.isValidRow();
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    public int getSensitivity() throws SQLException {
        return 1;
    }
}

