/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.tsmodel.vi.provider;

import com.sap.ide.metamodel.general.CommitResult;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.vi.VIRoot;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.vi.plugin.VIRootManager;
import com.sap.ide.vi.check.result.TaskManager;
import com.sap.ide.vi.check.result.metamodel.CRRoot;
import com.sap.ide.vi.check.result.metamodel.CheckResult;
import com.sap.ide.vi.check.result.metamodel.plugin.CRRootManager;
import com.sap.ide.webservices.tsmodel.generic.provider.mdo.DataSourceManager;
import com.sap.ide.webservices.tsmodel.generic.provider.util.UpdateDescription;
import com.sap.ide.webservices.tsmodel.vi.provider.ViDeleteListener;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.dtr.MdoDtrService;
import com.sap.ide.ws.core.services.dtr.WsDtrService;
import com.sap.ide.ws.core.services.resources.WsRefreshAction;
import com.tssap.j2ee.core.providers.vi.ViModelMetaInfo;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class VIDataSourceManager
extends DataSourceManager {
    private static Vector viDeleteListeners = new Vector();
    private static VIDataSourceManager mDataSourceManager;
    private static HashMap mInstanceMap;
    static /* synthetic */ Class class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager;

    public static synchronized void addViDeleteListener(ViDeleteListener listener) {
        viDeleteListeners.add(listener);
    }

    public static synchronized void removeViDeleteListener(ViDeleteListener listener) {
        viDeleteListeners.remove(listener);
    }

    public static DataSourceManager getDataSourceManager(String projectName) {
        VIDataSourceManager dataSourceManager = (VIDataSourceManager)mInstanceMap.get(projectName);
        if (dataSourceManager == null) {
            dataSourceManager = new VIDataSourceManager(projectName);
            mInstanceMap.put(projectName, dataSourceManager);
        }
        return dataSourceManager;
    }

    protected VIDataSourceManager(String projectName) {
        super(projectName);
        VIRootManager.getVIRoot((String)projectName).attachGlobalObserver((DevelopmentObjectObserver)this);
    }

    public VIRoot getVIRoot() {
        return VIRootManager.getVIRoot((String)this.getProjectName());
    }

    public static void deleteVi(String projectName, VirtualInterface viDefinition, final boolean refresh) {
        if (viDefinition == null) {
            return;
        }
        final String prjName = projectName;
        final VirtualInterface vi = viDefinition;
        String viName = viDefinition.getName();
        String viPackage = viDefinition.getPackage();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (WsDtrService.isDtrRelevant((String)vi.getAbsolutePath())) {
                    if (MdoDtrService.checkOutMdoAndLanguageFiles((MainDevelopmentObject)vi).hasFailedFilePaths()) {
                        VIDataSourceManager.access$001(vi.getName() + ".videf");
                        return;
                    }
                    VIDataSourceManager.doDelete(prjName, vi, refresh);
                } else {
                    if (vi.isReadOnly()) {
                        VIDataSourceManager.access$201(vi.getName() + ".videf");
                        return;
                    }
                    VIDataSourceManager.doDelete(prjName, vi, refresh);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager = VIDataSourceManager.class$("com.sap.ide.webservices.tsmodel.vi.provider.VIDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager));
        }
        VIDataSourceManager.notifyViDeletionListeners(viName, viPackage, projectName);
    }

    private static void doDelete(String projectName, VirtualInterface viDefinition, boolean refresh) {
        if (viDefinition.isReadOnly() && MdoDtrService.checkOutMdoAndLanguageFiles((MainDevelopmentObject)viDefinition).hasFailedFilePaths()) {
            DataSourceManager.warnUserAboutDeleteNotPossible(viDefinition.getName() + ".videf");
            return;
        }
        TaskManager.deleteMarkers((VirtualInterface)viDefinition);
        try {
            DataSourceManager.doDeleteMdo((MainDevelopmentObject)viDefinition);
            VIDataSourceManager.deleteViCheckResult(projectName, VIDataSourceManager.getCheckResultForVi(projectName, viDefinition));
        }
        catch (DeleteException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager = VIDataSourceManager.class$("com.sap.ide.webservices.tsmodel.vi.provider.VIDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager));
        }
        catch (SaveException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager = VIDataSourceManager.class$("com.sap.ide.webservices.tsmodel.vi.provider.VIDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager));
        }
        if (refresh) {
            new WsRefreshAction().refresh(projectName);
        }
    }

    private static CheckResult getCheckResultForVi(String projectName, VirtualInterface vi) {
        CRRoot root = CRRootManager.getCRRoot((String)projectName);
        if (root.hasCheckResult(vi.getPackage(), vi.getName())) {
            try {
                return root.getCheckResult(vi.getPackage(), vi.getName());
            }
            catch (LoadException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager = VIDataSourceManager.class$("com.sap.ide.webservices.tsmodel.vi.provider.VIDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager));
            }
        }
        return null;
    }

    private static void deleteViCheckResult(String projectName, CheckResult checkResult) {
        if (checkResult != null) {
            String path = checkResult.getAbsolutePath();
            try {
                checkResult.delete();
                CommitResult result = checkResult.commitChanges();
                String[] deletedFiles = result.getAllDeletedFiles();
                int i = 0;
                while (i < deletedFiles.length) {
                    String absolutePath = deletedFiles[i];
                    File file = new File(absolutePath);
                    System.out.println("File was deleted: " + file.delete());
                    ++i;
                }
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager = VIDataSourceManager.class$("com.sap.ide.webservices.tsmodel.vi.provider.VIDataSourceManager")) : class$com$sap$ide$webservices$tsmodel$vi$provider$VIDataSourceManager));
            }
        }
    }

    private static synchronized void notifyViDeletionListeners(String viName, String viPackage, String projectName) {
        int i = 0;
        while (i < viDeleteListeners.size()) {
            if (((ViDeleteListener)viDeleteListeners.elementAt(i)).getProjectName().equals(projectName)) {
                ((ViDeleteListener)viDeleteListeners.elementAt(i)).viDeleled(viName, viPackage);
            }
            ++i;
        }
    }

    public void removeDataSourceManager(String projectName) {
        VIDataSourceManager dataSourceManager = (VIDataSourceManager)mInstanceMap.get(projectName);
        if (dataSourceManager == null) {
            return;
        }
        mInstanceMap.remove(projectName);
        VIRootManager.getVIRoot((String)projectName).detachGlobalObserver((DevelopmentObjectObserver)this);
        dataSourceManager.destructor();
    }

    public UpdateDescription[] getObjectsToUpdate(MetamodelEvent event) {
        ArrayList<UpdateDescription> list = new ArrayList<UpdateDescription>();
        UniqueName uniqueName = null;
        DevelopmentObject object = event.getModifiedObject();
        if (object == null) {
            return null;
        }
        if (event.getEventId() == 1 || event.getEventId() == 2) {
            DevelopmentObject changedObject = event.getModifiedObject();
            if (changedObject instanceof VirtualInterface) {
                uniqueName = DataSourceManager.createUniqueNameForStructureNode(ViModelMetaInfo.getSubDomainForStructureNode());
            }
            if (uniqueName != null) {
                list.add(new UpdateDescription(uniqueName, ModelDeltaNodeKind.CHANGED));
            } else {
                return null;
            }
        }
        if (list.size() > 0) {
            UpdateDescription[] helperArray = new UpdateDescription[]{};
            return list.toArray(helperArray);
        }
        return null;
    }

    static /* synthetic */ void access$001(String x0) {
        DataSourceManager.warnUserAboutDeleteNotPossible(x0);
    }

    static /* synthetic */ void access$201(String x0) {
        DataSourceManager.warnUserAboutDeleteNotPossible(x0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mInstanceMap = new HashMap();
    }
}

