/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.tsmodel.generic.provider.mdo;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.webservices.tsmodel.generic.provider.mdo.DataSourceManager;
import com.sap.ide.webservices.tsmodel.generic.provider.mdo.MdoAwareBaseProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public abstract class MdoAwareChildrenProvider
extends MdoAwareBaseProvider
implements ChildrenProvider,
EntityExistenceProvider {
    protected abstract MainDevelopmentObject[] getMDOs() throws LoadException;

    protected abstract void handleLoadException();

    protected abstract String getMdoSubDomain();

    public void registered(Model model) {
        super.registered(model);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public UniqueNameEnumeration children(Entity parent) {
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        String projectName = parent.getModel().getUniqueName().getName();
        MainDevelopmentObject[] mdos = null;
        try {
            mdos = this.getMDOs();
        }
        catch (LoadException e) {
            this.handleLoadException();
            return null;
        }
        if (mdos != null) {
            int i = 0;
            while (i < mdos.length) {
                if (MdoAwareChildrenProvider.exists(mdos[i]) && mdos[i].getName() != null) {
                    UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)mdos[i], this.getMdoSubDomain(), mdos[i].getPackage());
                    list.add(uniqueName);
                }
                ++i;
            }
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public static boolean exists(MainDevelopmentObject mdo) {
        File f = new File(mdo.getAbsolutePath());
        return f.exists();
    }

    public abstract boolean isChildrenProviderApplicable(Entity var1);

    public abstract boolean canCreateUniqueName(Entity var1, String var2, Entity var3);

    public abstract boolean exists(UniqueName var1);

    public abstract void delete(Element var1);
}

