/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webservices.tsmodel.generic.provider.mdo;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.CommitResult;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelDocument;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.InvalidKeyException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.vi.core.text.ViUiTexts;
import com.sap.ide.webservices.tsmodel.generic.provider.mdo.MdoAwareHierarchyDeltaProvider;
import com.sap.ide.webservices.tsmodel.generic.provider.mdo.SourceFolderChangeVisitor;
import com.sap.ide.webservices.tsmodel.generic.provider.util.UpdateDescription;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.editors.MdoEditorUtils;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.tssap.j2ee.core.providers.vi.ViModelMetaInfo;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class DataSourceManager
implements DevelopmentObjectObserver,
IResourceChangeListener {
    private String mProjectName;
    private MdoAwareHierarchyDeltaProvider mChangeListener;
    private List projectSourceFolderNames = new ArrayList();
    static /* synthetic */ Class class$com$sap$ide$webservices$tsmodel$generic$provider$mdo$DataSourceManager;

    protected DataSourceManager(String projectName) {
        this.setProjectName(projectName);
        this.initialiseSourceFolderList(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected static void warnUserAboutDeleteNotPossible(String objectTypeName) {
        MessageDialog dlg = new MessageDialog(Display.getCurrent().getActiveShell(), WsCoreUiTexts.getString((String)"DialogTitles.warning"), null, ViUiTexts.getString("Errors.NoDeleteReadOnly", objectTypeName), 4, new String[]{ViUiTexts.getString("GenaralQuestions.ok")}, 0);
        dlg.open();
    }

    protected static void doDeleteMdo(MainDevelopmentObject mdo) throws DeleteException, SaveException {
        MdoEditorUtils.closeEditor((MainDevelopmentObject)mdo);
        mdo.delete();
        CommitResult result = ((MetamodelDocument)mdo).commitChanges();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.open();
        IProgressMonitor progressMonitor = dialog.getProgressMonitor();
        MetamodelManager.getMetamodelManager((String)mdo.getMetamodel().getName()).processDeletedFiles(result, progressMonitor);
        dialog.close();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event != null && event.getDelta() != null) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)new SourceFolderChangeVisitor(this));
            }
            catch (CoreException e) {
                WebServiceCorePlugin.logError((Throwable)e, this.getClass());
            }
        }
    }

    public void removeListener(MdoAwareHierarchyDeltaProvider provider) {
    }

    public void update(MetamodelEvent event) {
        this.updateInternal(event);
        if (this.mChangeListener != null) {
            this.mChangeListener.getModel().getExtensionManager().modelContentsChanged();
        }
    }

    public static DataSourceManager getDataSourceManager(String projectName) {
        return null;
    }

    public abstract void removeDataSourceManager(String var1);

    protected void destructor() {
        this.mProjectName = null;
        this.mChangeListener = null;
    }

    public void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.updateInternal(events[i]);
            this.mChangeListener.getModel().getExtensionManager().modelContentsChanged();
            ++i;
        }
    }

    public void refresh() {
        this.mChangeListener.totalUpdate();
        this.mChangeListener.getModel().getExtensionManager().modelContentsChanged();
    }

    private void updateInternal(MetamodelEvent event) {
        DevelopmentObject object = event.getModifiedObject();
        UpdateDescription[] descriptions = this.getObjectsToUpdate(event);
        if (descriptions == null) {
            return;
        }
        if (this.mProjectName != null && this.mChangeListener != null) {
            int i = 0;
            while (i < descriptions.length) {
                this.mChangeListener.update(descriptions[i].getUniqueName(), descriptions[i].getModelDeltaNodeKind());
                ++i;
            }
            return;
        }
    }

    private static String adaptKey(String key) {
        return key.replace(':', '#');
    }

    public static UniqueName createUniqueName(DevelopmentObject object, String subDomain) {
        String key = object.getKey().toString();
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)subDomain, null, (String)object.getName(), (String[])new String[]{DataSourceManager.adaptKey(key)});
        return uniqueName;
    }

    public static UniqueName createUniqueName(DevelopmentObject object, String subDomain, String location) {
        String key = object.getKey().toString();
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)subDomain, (String)location, (String)object.getName(), (String[])new String[]{DataSourceManager.adaptKey(key)});
        return uniqueName;
    }

    public DevelopmentObject getDevelopmentObject(UniqueName uniqueName) {
        String name = null;
        if (uniqueName.getParametersCount() > 0) {
            name = uniqueName.getParameter(0);
        }
        if (name != null) {
            name = name.replace('#', ':');
        }
        DevelopmentObjectKey keyObject = null;
        try {
            keyObject = this.getMetamodel().createDevelopmentObjectKeyFromString(name);
        }
        catch (InvalidKeyException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$webservices$tsmodel$generic$provider$mdo$DataSourceManager == null ? (class$com$sap$ide$webservices$tsmodel$generic$provider$mdo$DataSourceManager = DataSourceManager.class$("com.sap.ide.webservices.tsmodel.generic.provider.mdo.DataSourceManager")) : class$com$sap$ide$webservices$tsmodel$generic$provider$mdo$DataSourceManager));
            return null;
        }
        return this.getMetamodel().getObjectFromKey(keyObject);
    }

    public abstract UpdateDescription[] getObjectsToUpdate(MetamodelEvent var1);

    protected void setProjectName(String name) {
        this.mProjectName = name;
    }

    private Metamodel getMetamodel() {
        return MetamodelManager.getMetamodel((String)this.mProjectName);
    }

    public String getProjectName() {
        return this.mProjectName;
    }

    public void setListener(MdoAwareHierarchyDeltaProvider provider) {
        this.mChangeListener = provider;
    }

    void addProjectSourFolderName(String name) {
        this.projectSourceFolderNames.add(name);
    }

    void removeProjectSourceFolderName(String name) {
        this.projectSourceFolderNames.remove(name);
    }

    boolean isProjectSourceFolderNameRegistered(String name) {
        return this.projectSourceFolderNames.contains(name);
    }

    private void initialiseSourceFolderList(IProject project) {
        try {
            IPackageFragmentRoot[] packageRoots = JavaCore.create((IProject)project).getPackageFragmentRoots();
            int i = 0;
            while (i < packageRoots.length) {
                if (packageRoots[i].getKind() == 1 && !this.isProjectSourceFolderNameRegistered(packageRoots[i].getElementName())) {
                    this.addProjectSourFolderName(packageRoots[i].getElementName());
                }
                ++i;
            }
        }
        catch (JavaModelException e1) {
            WebServiceCorePlugin.logError((Throwable)e1, this.getClass());
        }
    }

    public boolean developmentObjectExists(UniqueName uniqueName) {
        boolean exists = this.getDevelopmentObject(uniqueName) != null;
        return exists;
    }

    public static UniqueName createUniqueNameForStructureNode(String subDomain) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)ViModelMetaInfo.getWebServiceObjectDomain(), (String)subDomain, null, (String)ViModelMetaInfo.getNameForStructureNode(), null);
        return uniqueName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

