/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.logging.Location;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;

public class Util {
    private static String className;
    private static Location log;
    private boolean finest = log.beLogged(100);
    private static final String FIRST_LINE = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private static final int MAX_HEADER_LENGTH = 256;
    public static final String ASCII = "US-ASCII";
    public static final String UTF8 = "UTF8";
    public static final String UTF16_BIG_NO_BOM = "UnicodeBigUnmarked";
    public static final String UTF16_BIG_WITH_BOM = "UnicodeBig";
    public static final String UTF16_LITTLE_NO_BOM = "UnicodeLittleUnmarked";
    public static final String UTF16_LITTLE_WITH_BOM = "UnicodeLittle";
    public static final long IGS_TIMEOUT = 600000L;
    private static BitSet dontNeedEncoding;
    private static final int caseDiff = 32;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$Util;

    public static URL createUrlFromString(String url) throws GraphicsException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            String message = "fatal: invalid url string: " + url;
            log.debugT("createUrlFromString", message);
            throw new GraphicsException(message);
        }
    }

    public static byte[] readCompleteStream(InputStream is) throws IOException {
        byte[] tmp;
        int bufferSize = 10000;
        int offSet = 0;
        byte[] retVal = new byte[bufferSize];
        try {
            int bytesRead;
            while ((bytesRead = is.read(retVal, offSet, bufferSize - offSet)) != -1) {
                if ((offSet += bytesRead) != bufferSize) continue;
                tmp = new byte[bufferSize *= 2];
                System.arraycopy(retVal, 0, tmp, 0, offSet);
                retVal = tmp;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            is.close();
            throw throwable;
        }
        is.close();
        if (offSet != bufferSize) {
            tmp = new byte[offSet];
            System.arraycopy(retVal, 0, tmp, 0, offSet);
            retVal = tmp;
        }
        return retVal;
    }

    public static String readCompleteStream(BufferedReader reader) throws IOException {
        int bufferSize = 100000;
        char[] buffer = new char[100000];
        int offset = 0;
        StringBuffer retValBuffer = null;
        try {
            int bytesRead;
            while ((bytesRead = reader.read(buffer, offset, 100000 - offset)) != -1) {
                if ((offset += bytesRead) != 100000) continue;
                if (retValBuffer == null) {
                    retValBuffer = new StringBuffer(200000);
                }
                retValBuffer.append(buffer);
                offset = 0;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        if (offset > 0) {
            if (retValBuffer == null) {
                retValBuffer = new StringBuffer(offset);
            }
            retValBuffer.append(buffer, 0, offset);
        }
        return retValBuffer == null ? null : retValBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readXmlFromUrl(URL url) throws GraphicsException {
        if (url == null) {
            message = "fatal: Could not read data, url == null";
            Util.log.debugT("readDataFromUrl", message);
            throw new GraphicsException(message);
        }
        is = null;
        buffer = new byte[256];
        try {
            try {
                is = url.openStream();
                fis = new BufferedInputStream(is);
                bytesRead = fis.read(buffer, 0, 256);
                if (bytesRead == -1) {
                    message = "fatal: Could not read bytes from url: " + url;
                    Util.log.debugT("readDataFromUrl", message);
                    throw new GraphicsException(message);
                }
                var7_14 = null;
            }
            catch (IOException e) {
                message = "fatal: Could not read data from url: " + url + "; openStream failed: " + Util.extractCallstack(e);
                Util.log.debugT("readDataFromUrl", message);
                throw new GraphicsException(message);
            }
        }
        catch (Throwable var6_18) {
            var7_15 = null;
            try {
                if (is == null) throw var6_18;
                is.close();
                throw var6_18;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw var6_18;
        }
        try {}
        catch (IOException e) {}
        if (is != null) {
            is.close();
        }
        if ((encoding = Util.getEncoding(buffer)) == null) {
            message = "fatal: Could not detect encoding from url: " + url;
            Util.log.debugT("readDataFromUrl", message);
            throw new GraphicsException(message);
        }
        try {
            try {
                is = url.openStream();
                in = new BufferedReader(new InputStreamReader(is, encoding));
                result = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
                firstLine = in.readLine();
                var7_14 = result = result + Util.readCompleteStream(in);
                var10_20 = null;
            }
            catch (IOException e) {
                message = "fatal: Failed to read xml string from url, url: " + url + " error " + Util.extractCallstack(e);
                Util.log.debugT("readDataFromUrl", message);
                throw new GraphicsException(message);
            }
        }
        catch (Throwable var9_24) {
            var10_21 = null;
            try {
                if (is == null) throw var9_24;
                is.close();
                throw var9_24;
            }
            catch (IOException e) {
                throw var9_24;
            }
        }
        ** try [egrp 5[TRYBLOCK] [5 : 380->391)] { 
lbl73:
        // 1 sources

        if (is == null) return var7_14;
        is.close();
        return var7_14;
lbl76:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var7_14;
    }

    public static String getEncoding(byte[] bytes) throws GraphicsException {
        if (bytes == null || bytes.length < 5) {
            String message = "fatal: Could not detect encoding (file too small)";
            log.debugT("getEncoding", message);
            throw new GraphicsException(message);
        }
        if (bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return UTF8;
        }
        if (bytes[0] == -2 && bytes[1] == -1) {
            return UTF16_BIG_WITH_BOM;
        }
        if (bytes[0] == -1 && bytes[1] == -2 && bytes[2] != 0) {
            return UTF16_LITTLE_WITH_BOM;
        }
        if (bytes[0] == -1 && bytes[1] == -2 && bytes[2] == 0 && bytes[3] == 0) {
            String message = "fatal: Unsupported encoding (UTF32 with BOM)";
            log.debugT("getEncoding", message);
            throw new GraphicsException(message);
        }
        if (bytes[0] == 0 && bytes[2] == 0 && bytes[3] == -2 && bytes[4] == -1) {
            String message = "fatal: Unsupported encoding (UTF32 big endian with BOM)";
            log.debugT("getEncoding", message);
            throw new GraphicsException(message);
        }
        if (bytes[0] == 0 && bytes[1] == 60 && bytes[2] == 0 && bytes[3] == 63) {
            return UTF16_BIG_NO_BOM;
        }
        if (bytes[0] == 60 && bytes[1] == 0 && bytes[2] == 63 && bytes[3] == 0) {
            return UTF16_LITTLE_NO_BOM;
        }
        String s = new String(bytes);
        int i = s.indexOf("encoding=\"");
        if (i == -1) {
            String message = "fatal: Could not detect encoding (no BOM, no encoding=\")";
            log.debugT("getEncoding", message);
            throw new GraphicsException(message);
        }
        return s.substring(i + 10, s.indexOf(34, i + 10)).toUpperCase();
    }

    public static String encode(String s) {
        if (s == null) {
            return null;
        }
        String enc = "utf-8";
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        int i = 0;
        while (i < s.length()) {
            block14: {
                int c = s.charAt(i);
                if (dontNeedEncoding.get(c)) {
                    if (c == 32) {
                        c = 43;
                        needToChange = true;
                    }
                    out.append((char)c);
                    wroteUnencodedChar = true;
                } else {
                    try {
                        char d;
                        if (wroteUnencodedChar) {
                            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
                            wroteUnencodedChar = false;
                        }
                        writer.write(c);
                        if (c >= 55296 && c <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                            writer.write(d);
                            ++i;
                        }
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block14;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        out.append('%');
                        char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ch = Character.forDigit(ba[j] & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ++j;
                    }
                    buf.reset();
                    needToChange = true;
                }
            }
            ++i;
        }
        return needToChange ? out.toString() : s;
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static String decode(String s) throws UnsupportedEncodingException {
        String enc = "utf-8";
        boolean needToChange = false;
        StringBuffer sb = new StringBuffer();
        int numChars = s.length();
        int i = 0;
        while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    break;
                }
                case '%': {
                    try {
                        byte[] bytes = new byte[(numChars - i) / 3];
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, enc));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + Util.extractCallstack(e));
                    }
                    needToChange = true;
                    break;
                }
                default: {
                    sb.append(c);
                    ++i;
                }
            }
        }
        return needToChange ? sb.toString() : s;
    }

    public static String colorToString(Color color) {
        if (color == null) {
            return null;
        }
        return String.valueOf(color.getRed()) + "," + String.valueOf(color.getGreen()) + "," + String.valueOf(color.getBlue());
    }

    public static String extractCallstack(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String className = "Util";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$Util == null ? (class$com$sap$tc$graphics$igs$Util = Util.class$("com.sap.tc.graphics.igs.Util")) : class$com$sap$tc$graphics$igs$Util).getName());
        dontNeedEncoding = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            dontNeedEncoding.set(i);
            ++i;
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

