/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.CallIgs;
import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.IgsComponent;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.logging.Location;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;

public abstract class IgsImageComponent
extends IgsComponent {
    public static final int UNDEFINED = -1;
    public static final int GIF = 0;
    public static final int JPG = 1;
    public static final int PNG = 2;
    public static final int SVG = 3;
    public static final int VML = 4;
    private static byte[] errorImage;
    protected byte[] image;
    private static final String ERROR_IMAGE = "ErrorImage.gif";
    protected String imageUrl;
    protected int imageType;
    protected String mimeType;
    private static Location log;
    private static String className;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$IgsImageComponent;

    public IgsImageComponent() {
        this.finest = log.beLogged(100);
    }

    protected void clearResults() {
        this.igsError = null;
        this.imageType = -1;
        this.mimeType = null;
        this.imageUrl = null;
        this.image = null;
    }

    public boolean execute() {
        this.callIgsIfNecessary();
        return this.imageUrl != null;
    }

    protected void assignImageTypeIfNecessary() {
        this.callIgsIfNecessary();
        this.getImageAsByteArray();
        if (this.mimeType == null) {
            this.imageType = -1;
            return;
        }
        String capMimeType = this.mimeType.toUpperCase();
        this.imageType = capMimeType.endsWith("GIF") ? 0 : (capMimeType.endsWith("JPG") || capMimeType.endsWith("JPEG") ? 1 : (capMimeType.endsWith("PNG") ? 2 : (capMimeType.endsWith("SVG") ? 3 : (capMimeType.endsWith("VML") ? 4 : -1))));
    }

    /*
     * WARNING - void declaration
     */
    protected static byte[] getErrorImage() throws GraphicsException {
        if (errorImage != null) {
            return errorImage;
        }
        InputStream is = (class$com$sap$tc$graphics$igs$IgsImageComponent == null ? (class$com$sap$tc$graphics$igs$IgsImageComponent = IgsImageComponent.class$("com.sap.tc.graphics.igs.IgsImageComponent")) : class$com$sap$tc$graphics$igs$IgsImageComponent).getResourceAsStream(ERROR_IMAGE);
        if (is == null) {
            throw new GraphicsException("could not read error image: ErrorImage.gif");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int c;
            while ((c = is.read()) >= 0) {
                void var2_2;
                os.write((int)var2_2);
            }
        }
        catch (IOException e) {
            throw new GraphicsException("could not read error image" + Util.extractCallstack(e));
        }
        errorImage = os.toByteArray();
        return errorImage;
    }

    public byte[] getErrorImageAsByteArray() {
        try {
            IgsImageComponent.getErrorImage();
        }
        catch (GraphicsException e) {
            log.debugT("getErrorImageAsByteArray", "warning: " + e.getMessage());
        }
        this.imageType = 0;
        this.mimeType = "GIF";
        return errorImage;
    }

    public byte[] getImageAsByteArray() {
        String methodName = "getImageAsByteArray";
        this.callIgsIfNecessary();
        if (this.image != null) {
            return this.image;
        }
        if (this.imageUrl != null) {
            try {
                CallIgs.Result result = this.caller.getBytesFromIgsUrl(this.igsUrl, this.imageUrl);
                if (result != null) {
                    this.mimeType = result.getMimeType();
                    this.image = result.getBytes();
                    return this.image;
                }
                String errorMessage = "fatal: igs get image call returned null, igsUrl:" + this.igsUrl + " imageUrl: " + this.imageUrl;
                log.debugT(methodName, errorMessage);
            }
            catch (GraphicsException e) {
                String errorMessage = "fatal: retrieval of image from url failed: " + this.imageUrl;
                this.igsError = this.igsError == null ? errorMessage : this.igsError + " " + errorMessage;
                log.debugT(methodName, errorMessage);
            }
        }
        log.debugT(methodName, "fatal: could not generate image, return error image instead");
        return this.getErrorImageAsByteArray();
    }

    public int getImageType() {
        this.assignImageTypeIfNecessary();
        return this.imageType;
    }

    public String getMimeType() {
        this.assignImageTypeIfNecessary();
        return this.mimeType;
    }

    public String getImageUrlString() {
        this.callIgsIfNecessary();
        return this.imageUrl;
    }

    protected static Image byteArrayToImage(byte[] byteArray) throws GraphicsException {
        if (byteArray == null) {
            String errorMessage = "could not create image, empty image byte array";
            throw new GraphicsException(errorMessage);
        }
        return new ImageIcon(byteArray).getImage();
    }

    public Image getImage() {
        try {
            return IgsImageComponent.byteArrayToImage(this.getImageAsByteArray());
        }
        catch (GraphicsException e) {
            String errorMessage = e.getMessage();
            this.igsError = this.igsError == null ? errorMessage : this.igsError + " " + errorMessage;
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "IgsImageComponent";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$IgsImageComponent == null ? (class$com$sap$tc$graphics$igs$IgsImageComponent = IgsImageComponent.class$("com.sap.tc.graphics.igs.IgsImageComponent")) : class$com$sap$tc$graphics$igs$IgsImageComponent).getName());
    }
}

